/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.functions;

import com.natamus.collective.data.GlobalVariables;
import com.natamus.collective.functions.StringFunctions;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.WanderingTraderEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.MooshroomEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.passive.horse.DonkeyEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.entity.passive.horse.MuleEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MerchantOffer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class EntityFunctions {
    public static Boolean isHorse(Entity entity) {
        return entity instanceof AbstractHorseEntity;
    }

    public static boolean isModdedVillager(String entitystring) {
        String type = entitystring.split("\\[")[0];
        for (String moddedvillager : GlobalVariables.moddedvillagers) {
            if (!type.equalsIgnoreCase(moddedvillager)) continue;
            return true;
        }
        return false;
    }

    public static boolean isModdedVillager(Entity entity) {
        String entitystring = EntityFunctions.getEntityString(entity);
        return EntityFunctions.isModdedVillager(entitystring);
    }

    public static boolean isMilkable(Entity entity) {
        if (entity instanceof SheepEntity || entity instanceof LlamaEntity || entity instanceof PigEntity || entity instanceof DonkeyEntity || entity instanceof HorseEntity || entity instanceof MuleEntity) {
            if (!(entity instanceof AnimalEntity)) {
                return false;
            }
            AnimalEntity animal = (AnimalEntity)entity;
            return !animal.func_70631_g_();
        }
        return false;
    }

    public static String getEntityString(Entity entity) {
        String entitystring = "";
        ResourceLocation rl = entity.func_200600_R().getRegistryName();
        if (rl != null) {
            entitystring = rl.toString();
            if (entitystring.contains(":")) {
                entitystring = entitystring.split(":")[1];
            }
            entitystring = StringFunctions.capitalizeEveryWord(entitystring.replace("_", " ")).replace(" ", "").replace("Entity", "");
        }
        return entitystring;
    }

    public static void nameEntity(Entity entity, String name) {
        if (!name.equals("")) {
            entity.func_200203_b((ITextComponent)new StringTextComponent(name));
        }
    }

    public static void addPotionEffect(Entity entity, Effect effect, Integer ms) {
        EffectInstance freeze = new EffectInstance(effect, ms / 50);
        LivingEntity le = (LivingEntity)entity;
        le.func_195064_c(freeze);
    }

    public static void removePotionEffect(Entity entity, Effect effect) {
        LivingEntity le = (LivingEntity)entity;
        le.func_195063_d(effect);
    }

    public static void chargeEntity(Entity entity) {
        World world = entity.func_130014_f_();
        if (entity instanceof CreeperEntity) {
            entity.func_184212_Q().func_187227_b(CreeperEntity.field_184714_b, (Object)true);
        } else if (entity instanceof MooshroomEntity) {
            ((MooshroomEntity)entity).func_213446_a(MooshroomEntity.Type.BROWN);
        }
    }

    public static void setEntityFlag(Entity entity, int flag, boolean set) {
        entity.func_70052_a(flag, set);
    }

    public static void resetMerchantOffers(VillagerEntity villager) {
        for (MerchantOffer offer : villager.func_213706_dY()) {
            EntityFunctions.resetMerchantOffer(offer);
        }
    }

    public static void resetMerchantOffers(WanderingTraderEntity wanderingTrader) {
        for (MerchantOffer offer : wanderingTrader.func_213706_dY()) {
            EntityFunctions.resetMerchantOffer(offer);
        }
    }

    public static void resetMerchantOffer(MerchantOffer offer) {
        offer.field_222226_d = 0;
        offer.field_222227_e = Integer.MAX_VALUE;
        offer.field_222230_h = 0;
    }

    public static void forceSetHealth(LivingEntity livingEntity, float health) {
        livingEntity.func_184212_Q().func_187227_b(LivingEntity.field_184632_c, (Object)Float.valueOf(health));
    }

    public static void transferItemsBetweenEntities(Entity from, Entity to, boolean ignoremainhand) {
        if (!(from instanceof MobEntity)) {
            return;
        }
        MobEntity mobfrom = (MobEntity)from;
        for (EquipmentSlotType equipmentslottype : EquipmentSlotType.values()) {
            ItemStack itemstack;
            if (ignoremainhand && equipmentslottype.equals((Object)EquipmentSlotType.MAINHAND) || (itemstack = mobfrom.func_184582_a(equipmentslottype)).func_190926_b()) continue;
            to.func_184201_a(equipmentslottype, itemstack.func_77946_l());
        }
    }

    public static void transferItemsBetweenEntities(Entity from, Entity to) {
        EntityFunctions.transferItemsBetweenEntities(from, to, false);
    }

    public static Boolean doesEntitySurviveThisDamage(PlayerEntity player, int halfheartdamage) {
        return EntityFunctions.doesEntitySurviveThisDamage((LivingEntity)player, halfheartdamage);
    }

    public static Boolean doesEntitySurviveThisDamage(LivingEntity entity, int halfheartdamage) {
        float newhealth = entity.func_110143_aJ() - (float)halfheartdamage;
        if (!(newhealth > 0.0f)) {
            entity.func_70097_a(DamageSource.field_76376_m, Float.MAX_VALUE);
            return false;
        }
        entity.func_70097_a(DamageSource.field_76376_m, 0.1f);
        entity.func_70606_j(newhealth);
        return true;
    }
}

