/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.schematic;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective.schematic.ParsedSchematicObject;
import com.natamus.collective.schematic.Schematic;
import com.natamus.collective.schematic.SchematicBlockObject;
import java.io.InputStream;
import java.util.ArrayList;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ParseSchematicFile {
    public static ParsedSchematicObject getParsedSchematicObject(InputStream schematicInputStream, World level, BlockPos centerPos, int extraYOffset, boolean skipAir) {
        Schematic schematic = new Schematic(schematicInputStream);
        int maxBuildHeight = level.func_217301_I();
        short length = schematic.getLength();
        short width = schematic.getWidth();
        short height = schematic.getHeight();
        int yoffset = centerPos.func_177956_o() + extraYOffset;
        if (yoffset + height > maxBuildHeight) {
            yoffset = maxBuildHeight - height;
        }
        ArrayList<Pair<BlockPos, BlockState>> blocks = new ArrayList<Pair<BlockPos, BlockState>>();
        for (SchematicBlockObject blockObject : schematic.getBlocks()) {
            BlockState blockState = blockObject.getState();
            if (skipAir && blockState.func_177230_c().equals(Blocks.field_150350_a)) continue;
            blocks.add((Pair<BlockPos, BlockState>)new Pair((Object)blockObject.getPosition().func_177982_a(centerPos.func_177958_n() - width / 2, yoffset, centerPos.func_177952_p() - length / 2).func_185334_h(), (Object)blockState));
        }
        ArrayList<BlockPos> blockEntityPositions = new ArrayList<BlockPos>();
        for (CompoundNBT blockEntityCompoundTag : schematic.getBlockEntities()) {
            blockEntityPositions.add(schematic.getBlockPosFromCompoundTag(blockEntityCompoundTag).func_177982_a(centerPos.func_177958_n() - width / 2, yoffset, centerPos.func_177952_p() - length / 2));
        }
        return new ParsedSchematicObject(blocks, blockEntityPositions, "Parsed successfully.", true);
    }
}

