/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.schematic;

import com.mojang.brigadier.StringReader;
import com.natamus.collective.schematic.SchematicBlockObject;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.command.arguments.BlockStateParser;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;

public class Schematic {
    private int size;
    private short width;
    private short height;
    private short length;
    private boolean oldVersion;
    private HashMap<Integer, String> palette;
    private SchematicBlockObject[] blockObjects;
    private List<CompoundNBT> blockEntities;

    public Schematic(InputStream inputStream) {
        try {
            CompoundNBT nbtdata = CompressedStreamTools.func_74796_a((InputStream)inputStream);
            inputStream.close();
            this.width = nbtdata.func_74765_d("Width");
            this.height = nbtdata.func_74765_d("Height");
            this.length = nbtdata.func_74765_d("Length");
            this.size = this.width * this.height * this.length;
            this.oldVersion = !nbtdata.func_74764_b("DataVersion");
            this.blockObjects = new SchematicBlockObject[this.size];
            if (!this.oldVersion) {
                byte[] blocks = nbtdata.func_74770_j("BlockData");
                CompoundNBT palette = nbtdata.func_74775_l("Palette");
                this.palette = new HashMap();
                for (String k : palette.func_150296_c()) {
                    this.palette.put(palette.func_74762_e(k), k);
                }
                int counter = 0;
                for (int i = 0; i < this.height; ++i) {
                    for (int j = 0; j < this.length; ++j) {
                        for (int k = 0; k < this.width; ++k) {
                            BlockPos pos = new BlockPos(k, i, j);
                            int id = blocks[counter];
                            if (id < 0) {
                                id *= -1;
                            }
                            BlockState state = this.getStateFromID(id);
                            this.blockObjects[counter] = new SchematicBlockObject(pos, state);
                            ++counter;
                        }
                    }
                }
                ListNBT tileentitynbtlist = nbtdata.func_150295_c("BlockEntities", 10);
                this.blockEntities = new ArrayList<CompoundNBT>();
                for (int i = 0; i < tileentitynbtlist.size(); ++i) {
                    this.blockEntities.add(tileentitynbtlist.func_150305_b(i));
                }
            } else {
                byte[] blockIDs_byte = nbtdata.func_74770_j("Blocks");
                int[] blockIDs = new int[this.size];
                for (int x = 0; x < blockIDs_byte.length; ++x) {
                    blockIDs[x] = Byte.toUnsignedInt(blockIDs_byte[x]);
                }
                byte[] metadata = nbtdata.func_74770_j("Data");
                int counter = 0;
                for (int i = 0; i < this.height; ++i) {
                    for (int j = 0; j < this.length; ++j) {
                        for (int k = 0; k < this.width; ++k) {
                            BlockPos pos = new BlockPos(k, i, j);
                            BlockState state = this.getStateFromOldIds(blockIDs[counter], metadata[counter]);
                            this.blockObjects[counter] = new SchematicBlockObject(pos, state);
                            ++counter;
                        }
                    }
                }
                ListNBT tileentitynbtlist = nbtdata.func_150295_c("TileEntities", 10);
                this.blockEntities = new ArrayList<CompoundNBT>();
                for (int i = 0; i < tileentitynbtlist.size(); ++i) {
                    CompoundNBT compound = tileentitynbtlist.func_150305_b(i);
                    int i1 = compound.func_74762_e("x");
                    int i2 = compound.func_74762_e("y");
                    int i3 = compound.func_74762_e("z");
                    compound.func_74783_a("Pos", new int[]{i1, i2, i3});
                    this.blockEntities.add(compound);
                }
            }
        }
        catch (Exception e) {
            System.err.println("ERROR Cant load Schematic");
            e.printStackTrace();
            this.width = 0;
            this.height = 0;
            this.length = 0;
            this.size = 0;
            this.blockObjects = null;
            this.palette = null;
            this.blockEntities = null;
        }
    }

    public boolean isOldVersion() {
        return this.oldVersion;
    }

    private BlockState getStateFromOldIds(int blockID, byte meta) {
        return Block.func_196257_b((int)blockID);
    }

    public BlockState getBlockState(BlockPos pos) {
        for (SchematicBlockObject obj : this.blockObjects) {
            if (!obj.getPosition().equals((Object)pos)) continue;
            return obj.getState();
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public int getSize() {
        return this.size;
    }

    public SchematicBlockObject[] getBlocks() {
        return this.blockObjects;
    }

    public BlockState getStateFromID(int id) {
        String iblockstateS = this.palette.get(id);
        try {
            BlockStateParser parser = new BlockStateParser(new StringReader(iblockstateS), true);
            parser.func_197243_a(false);
            return parser.func_197249_b();
        }
        catch (Exception ex) {
            return Blocks.field_150350_a.func_176223_P();
        }
    }

    public List<CompoundNBT> getBlockEntities() {
        return this.blockEntities;
    }

    public CompoundNBT getTileEntity(BlockPos pos) {
        for (CompoundNBT compound : this.blockEntities) {
            int[] pos1 = compound.func_74759_k("Pos");
            if (pos1[0] != pos.func_177958_n() || pos1[1] != pos.func_177956_o() || pos1[2] != pos.func_177952_p()) continue;
            return compound;
        }
        return null;
    }

    public BlockPos getBlockPosFromCompoundTag(CompoundNBT compoundTag) {
        int[] pos = compoundTag.func_74759_k("Pos");
        return new BlockPos(pos[0], pos[1], pos[2]);
    }

    public short getWidth() {
        return this.width;
    }

    public short getHeight() {
        return this.height;
    }

    public short getLength() {
        return this.length;
    }
}

