/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.api;

import java.util.Objects;

public interface IMapping<Source, Product> {
    public static <Source, Product> IMapping<Source, Product> of(Source source, int sourceAmount, Product product, int productAmount) {
        if (0 == sourceAmount || 0 == productAmount) {
            return new NoneToNone<Source, Product>(source, product);
        }
        if (sourceAmount == productAmount) {
            return new OneToOne<Source, Product>(source, sourceAmount, product, productAmount);
        }
        return new ManyToMany<Source, Product>(source, sourceAmount, product, productAmount);
    }

    public Source getSource();

    public Product getProduct();

    public int getSourceAmount();

    public int getProductAmount();

    public int getProductAmount(int var1);

    public int getSourceAmount(int var1);

    default public IMapping<Product, Source> getReverse() {
        return IMapping.of(this.getProduct(), this.getProductAmount(), this.getSource(), this.getSourceAmount());
    }

    public static class NoneToNone<Source, Product>
    extends Impl<Source, Product> {
        public NoneToNone(Source source, Product product) {
            super(source, 0, product, 0);
        }

        @Override
        public int getProductAmount(int sourceQty) {
            return 0;
        }

        @Override
        public int getSourceAmount(int productQty) {
            return 0;
        }
    }

    public static class ManyToMany<Source, Product>
    extends Impl<Source, Product> {
        public ManyToMany(Source source, int sourceAmount, Product product, int productAmount) {
            super(source, sourceAmount, product, productAmount);
        }

        @Override
        public int getProductAmount(int sourceQty) {
            return sourceQty / this.getSourceAmount() * this.getProductAmount();
        }

        @Override
        public int getSourceAmount(int productQty) {
            return productQty / this.getProductAmount() * this.getSourceAmount();
        }
    }

    public static class OneToOne<Source, Product>
    extends Impl<Source, Product> {
        public OneToOne(Source source, int sourceAmount, Product product, int productAmount) {
            super(source, sourceAmount, product, productAmount);
        }

        @Override
        public int getProductAmount(int sourceQty) {
            return sourceQty;
        }

        @Override
        public int getSourceAmount(int productQty) {
            return productQty;
        }
    }

    public static abstract class Impl<Source, Product>
    implements IMapping<Source, Product> {
        private final Source _source;
        private final Product _product;
        private final int _sourceAmount;
        private final int _productAmount;

        Impl(Source source, int sourceAmount, Product product, int productAmount) {
            this._source = Objects.requireNonNull(source);
            this._product = Objects.requireNonNull(product);
            this._sourceAmount = sourceAmount;
            this._productAmount = productAmount;
        }

        @Override
        public Source getSource() {
            return this._source;
        }

        @Override
        public Product getProduct() {
            return this._product;
        }

        @Override
        public int getSourceAmount() {
            return this._sourceAmount;
        }

        @Override
        public int getProductAmount() {
            return this._productAmount;
        }

        public String toString() {
            return String.format("%d %s to %d %s", this.getSourceAmount(), this.getSource(), this.getProductAmount(), this.getProduct());
        }
    }
}

