/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.powertap.chargingport;

import it.zerono.mods.extremereactors.gamecontent.multiblock.common.AbstractGeneratorMultiblockController;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.AbstractMultiblockEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.powertap.AbstractPowerTapHandler;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.powertap.chargingport.IChargingPortHandler;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.variant.IMultiblockGeneratorVariant;
import it.zerono.mods.zerocore.lib.block.multiblock.IMultiblockVariantProvider;
import it.zerono.mods.zerocore.lib.data.IoDirection;
import it.zerono.mods.zerocore.lib.data.IoMode;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import it.zerono.mods.zerocore.lib.item.inventory.handler.TileEntityItemStackHandler;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public abstract class AbstractChargingPortHandler<Controller extends AbstractGeneratorMultiblockController<Controller, V>, V extends IMultiblockGeneratorVariant, T extends AbstractMultiblockEntity<Controller>>
extends AbstractPowerTapHandler<Controller, V, T>
implements IChargingPortHandler,
ISyncableEntity {
    public static String TILE_COMMAND_EJECT = "eject";
    private final ItemStackHandler _input;
    private final ItemStackHandler _output;
    private double _chargingRate;

    protected AbstractChargingPortHandler(EnergySystem energySystem, T part) {
        super(energySystem, part, IoMode.Active);
        this._input = new TileEntityItemStackHandler(part, 1);
        this._output = new TileEntityItemStackHandler(part, 1);
        this._chargingRate = 0.0;
    }

    protected double getChargingRate() {
        if (0.0 == this._chargingRate) {
            this._chargingRate = ((IMultiblockVariantProvider)this.getPart()).getMultiblockVariant().map(IMultiblockGeneratorVariant::getChargerMaxRate).orElse(0.0);
        }
        return this._chargingRate;
    }

    protected <T> LazyOptional<T> getCapabilityFromInventory(Capability<T> capability, boolean ejectIfNotFound) {
        ItemStack stack = this._input.getStackInSlot(0);
        if (!stack.func_190926_b()) {
            LazyOptional cap = stack.getCapability(capability, null);
            if (ejectIfNotFound && !cap.isPresent()) {
                this.onChargeComplete();
            }
            return cap;
        }
        return LazyOptional.empty();
    }

    protected void onChargeComplete() {
        if (this._output.getStackInSlot(0).func_190926_b()) {
            this._output.setStackInSlot(0, this._input.getStackInSlot(0));
            this._input.setStackInSlot(0, ItemStack.field_190927_a);
        }
    }

    @Override
    public IItemHandlerModifiable getItemStackHandler(IoDirection direction) {
        return direction.isInput() ? this._input : this._output;
    }

    @Override
    public void eject() {
        this.onChargeComplete();
    }

    @Override
    public boolean isConnected() {
        return !this._input.getStackInSlot(0).func_190926_b();
    }

    @Override
    public void checkConnections(@Nullable IWorldReader world, BlockPos position) {
    }

    @Override
    public void invalidate() {
    }

    public void syncDataFrom(CompoundNBT data, ISyncableEntity.SyncReason syncReason) {
        if (syncReason.isFullSync()) {
            AbstractChargingPortHandler.syncInvFrom(data, "in", this._input);
            AbstractChargingPortHandler.syncInvFrom(data, "out", this._output);
        }
    }

    public CompoundNBT syncDataTo(CompoundNBT data, ISyncableEntity.SyncReason syncReason) {
        if (syncReason.isFullSync()) {
            AbstractChargingPortHandler.syncInvTo(data, "in", this._input);
            AbstractChargingPortHandler.syncInvTo(data, "out", this._output);
        }
        return data;
    }

    private static void syncInvTo(CompoundNBT data, String name, ItemStackHandler inv) {
        if (!inv.getStackInSlot(0).func_190926_b()) {
            data.func_218657_a(name, (INBT)inv.serializeNBT());
        }
    }

    private static void syncInvFrom(CompoundNBT data, String name, ItemStackHandler inv) {
        if (data.func_74764_b(name)) {
            inv.deserializeNBT(data.func_74775_l(name));
        }
    }
}

