/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.turbine;

import it.zerono.mods.extremereactors.api.turbine.CoilMaterial;
import it.zerono.mods.extremereactors.config.Config;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.ITurbineEnvironment;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.VentSetting;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.variant.IMultiblockTurbineVariant;
import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.IDebuggable;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.data.nbt.NBTHelper;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.LogicalSide;

public class TurbineData
implements ISyncableEntity,
IDebuggable {
    private static final float INDUCTOR_BASE_DRAG_COEFFICIENT = 0.1f * ((Double)Config.COMMON.turbine.turbineCoilDragMultiplier.get()).floatValue();
    private static final float BASE_BLADE_DRAG_COEFFICIENT = 2.5E-4f;
    private final IMultiblockTurbineVariant _variant;
    private boolean _inductorEngaged;
    private float _rotorEnergy;
    private VentSetting _ventSetting;
    private int _maxIntakeRate;
    private int _bladeSurfaceArea;
    private int _rotorMass;
    private int _coilSize;
    private float _inductorDragCoefficient;
    private float _inductionEfficiency;
    private float _inductionEnergyExponentBonus;
    private final float _rotorDragCoefficient;
    private float _bladeDrag = 2.5E-4f;
    private float _frictionalDrag;
    private final int _inputFluidPerBlade;
    private double _energyGeneratedLastTick;
    private int _fluidConsumedLastTick;
    private float _rotorEfficiencyLastTick;

    public TurbineData(IMultiblockTurbineVariant variant) {
        this._variant = variant;
        this._ventSetting = VentSetting.getDefault();
        this._inductorEngaged = false;
        this._rotorEnergy = 0.0f;
        this._maxIntakeRate = variant.getMaxPermittedFlow();
        this._bladeSurfaceArea = 0;
        this._rotorMass = 0;
        this._coilSize = 0;
        this._energyGeneratedLastTick = 0.0;
        this._fluidConsumedLastTick = 0;
        this._rotorEfficiencyLastTick = 1.0f;
        this._inductorDragCoefficient = INDUCTOR_BASE_DRAG_COEFFICIENT;
        this._inductionEfficiency = 0.5f;
        this._inductionEnergyExponentBonus = 1.0f;
        this._rotorDragCoefficient = variant.getRotorDragCoefficient();
        this._bladeDrag = 2.5E-4f;
        this._inputFluidPerBlade = (int)Math.floor((double)variant.getBaseFluidPerBlade() * (Double)Config.COMMON.turbine.turbineFluidPerBladeMultiplier.get());
    }

    public void reset() {
        this._ventSetting = VentSetting.getDefault();
        this._inductorEngaged = false;
        this._rotorEnergy = 0.0f;
        this._maxIntakeRate = this._variant.getMaxPermittedFlow();
        this._bladeSurfaceArea = 0;
        this._rotorMass = 0;
        this._coilSize = 0;
        this._energyGeneratedLastTick = 0.0;
        this._fluidConsumedLastTick = 0;
        this._rotorEfficiencyLastTick = 1.0f;
        this._inductorDragCoefficient = INDUCTOR_BASE_DRAG_COEFFICIENT;
        this._inductionEfficiency = 0.5f;
        this._inductionEnergyExponentBonus = 1.0f;
        this._bladeDrag = 2.5E-4f;
    }

    public void onTurbineAssembled() {
    }

    public void onTurbineDisassembled() {
        this._bladeSurfaceArea = 0;
        this._rotorMass = 0;
        this._coilSize = 0;
        this._rotorEnergy = 0.0f;
    }

    public void onAssimilate(TurbineData other) {
        this.setRotorEnergy(Math.max(this.getRotorEnergy(), other.getRotorEnergy()));
    }

    public void update(ITurbineEnvironment environment, BlockPos minInterior, BlockPos maxInterior, IMultiblockTurbineVariant variant) {
        int rotorMass = 0;
        int bladeSurfaceArea = 0;
        int maxX = maxInterior.func_177958_n();
        int maxY = maxInterior.func_177956_o();
        int maxZ = maxInterior.func_177952_p();
        BlockPos.Mutable position = new BlockPos.Mutable();
        CoilStats coilStats = new CoilStats();
        for (int x = minInterior.func_177958_n(); x <= maxX; ++x) {
            for (int y = minInterior.func_177956_o(); y <= maxY; ++y) {
                block7: for (int z = minInterior.func_177952_p(); z <= maxZ; ++z) {
                    position.func_181079_c(x, y, z);
                    switch (environment.getRotorComponentTypeAt((BlockPos)position)) {
                        case Blade: {
                            rotorMass += variant.getRotorBladeMass();
                            ++bladeSurfaceArea;
                            continue block7;
                        }
                        case Shaft: {
                            rotorMass += variant.getRotorShaftMass();
                            continue block7;
                        }
                        case CandidateCoil: {
                            environment.getCoilBlock((BlockPos)position).ifPresent(coilStats);
                        }
                    }
                }
            }
        }
        this._frictionalDrag = (float)rotorMass * this._rotorDragCoefficient * ((Double)Config.COMMON.turbine.turbineMassDragMultiplier.get()).floatValue();
        this._bladeDrag = 2.5E-4f * (float)bladeSurfaceArea * ((Double)Config.COMMON.turbine.turbineAeroDragMultiplier.get()).floatValue();
        if (coilStats.Size <= 0) {
            this._inductionEfficiency = 0.0f;
            this._inductionEnergyExponentBonus = 1.0f;
            this._inductorDragCoefficient = 0.0f;
        } else {
            this._inductionEfficiency = coilStats.Efficiency * 0.33f / (float)coilStats.Size;
            this._inductionEnergyExponentBonus = Math.max(1.0f, coilStats.Bonus / (float)coilStats.Size);
            this._inductorDragCoefficient = coilStats.DragCoefficient / (float)coilStats.Size * this.getInductorBaseDragCoefficient();
        }
        this._coilSize = coilStats.Size;
        this._rotorMass = rotorMass;
        this._bladeSurfaceArea = bladeSurfaceArea;
    }

    public float getInductorBaseDragCoefficient() {
        return INDUCTOR_BASE_DRAG_COEFFICIENT;
    }

    public float getRotorEnergy() {
        return this._rotorEnergy;
    }

    public boolean isInductorEngaged() {
        return this._inductorEngaged;
    }

    public VentSetting getVentSetting() {
        return this._ventSetting;
    }

    public int getMaxIntakeRate() {
        return this._maxIntakeRate;
    }

    public int getBladeSurfaceArea() {
        return this._bladeSurfaceArea;
    }

    public int getRotorMass() {
        return this._rotorMass;
    }

    public int getCoilSize() {
        return this._coilSize;
    }

    public float getInductorDragCoefficient() {
        return this._inductorDragCoefficient;
    }

    public float getInductionEfficiency() {
        return this._inductionEfficiency;
    }

    public float getInductionEnergyExponentBonus() {
        return this._inductionEnergyExponentBonus;
    }

    public float getBladeDrag() {
        return this._bladeDrag;
    }

    public float getFrictionalDrag() {
        return this._frictionalDrag;
    }

    public int getInputFluidPerBlade() {
        return this._inputFluidPerBlade;
    }

    public double getEnergyGeneratedLastTick() {
        return this._energyGeneratedLastTick;
    }

    public int getFluidConsumedLastTick() {
        return this._fluidConsumedLastTick;
    }

    public float getRotorEfficiencyLastTick() {
        return this._rotorEfficiencyLastTick;
    }

    public void setRotorEnergy(float energy) {
        if (!Float.isNaN(energy) && !Float.isInfinite(energy)) {
            this._rotorEnergy = Math.max(0.0f, energy);
        }
    }

    public void changeRotorEnergy(float delta) {
        this.setRotorEnergy(this.getRotorEnergy() + delta);
    }

    public void setInductorEngaged(boolean engaged) {
        this._inductorEngaged = engaged;
    }

    public void setVentSetting(VentSetting status) {
        this._ventSetting = status;
    }

    public void setMaxIntakeRate(int rate) {
        this._maxIntakeRate = Math.min(this._variant.getMaxPermittedFlow(), Math.max(0, rate));
    }

    public void setMaxIntakeRatePercentage(int percentage) {
        this.setMaxIntakeRate((int)((double)(this._variant.getMaxPermittedFlow() * percentage) / 100.0));
    }

    public void setEnergyGeneratedLastTick(double energy) {
        this._energyGeneratedLastTick = energy;
    }

    void changeEnergyGeneratedLastTick(double delta) {
        this._energyGeneratedLastTick += delta;
    }

    public void setFluidConsumedLastTick(int fluid) {
        this._fluidConsumedLastTick = fluid;
    }

    public void setRotorEfficiencyLastTick(float efficiency) {
        this._rotorEfficiencyLastTick = efficiency;
    }

    public void syncDataFrom(CompoundNBT data, ISyncableEntity.SyncReason syncReason) {
        this.setVentSetting((VentSetting)NBTHelper.nbtGetEnum((CompoundNBT)data, (String)"vent", VentSetting::valueOf, (Enum)VentSetting.getDefault()));
        if (data.func_74764_b("rotorenergy")) {
            this.setRotorEnergy(data.func_74760_g("rotorenergy"));
        }
        if (data.func_74764_b("maxintake")) {
            this.setMaxIntakeRate(data.func_74762_e("maxintake"));
        }
        if (data.func_74764_b("inductorengaged")) {
            this.setInductorEngaged(data.func_74767_n("inductorengaged"));
        }
        if (data.func_74764_b("energylast")) {
            this.setEnergyGeneratedLastTick(data.func_74769_h("energylast"));
        }
        if (data.func_74764_b("fluidlast")) {
            this.setFluidConsumedLastTick(data.func_74762_e("fluidlast"));
        }
        if (data.func_74764_b("rotorlast")) {
            this.setRotorEfficiencyLastTick(data.func_74760_g("rotorlast"));
        }
    }

    public CompoundNBT syncDataTo(CompoundNBT data, ISyncableEntity.SyncReason syncReason) {
        NBTHelper.nbtSetEnum((CompoundNBT)data, (String)"vent", (Enum)this.getVentSetting());
        data.func_74776_a("rotorenergy", this.getRotorEnergy());
        data.func_74768_a("maxintake", this.getMaxIntakeRate());
        data.func_74757_a("inductorengaged", this.isInductorEngaged());
        data.func_74780_a("energylast", this.getEnergyGeneratedLastTick());
        data.func_74768_a("fluidlast", this.getFluidConsumedLastTick());
        data.func_74776_a("rotorlast", this.getRotorEfficiencyLastTick());
        return data;
    }

    public void getDebugMessages(LogicalSide side, IDebugMessages messages) {
        messages.addUnlocalized("Last Tick: EnergyGenerated:%.5f; FluidConsumed:%d; RotorEfficiency:%.5f", new Object[]{this.getEnergyGeneratedLastTick(), this.getFluidConsumedLastTick(), Float.valueOf(this.getRotorEfficiencyLastTick())});
        messages.addUnlocalized("Inductor: %s; DragCoefficient:%.5f; Efficiency:%.5f; ExponentBonus:%.5f; CoilSize:%d", new Object[]{this.isInductorEngaged() ? "on" : "off", Float.valueOf(this.getInductorDragCoefficient()), Float.valueOf(this.getInductionEfficiency()), Float.valueOf(this.getInductionEnergyExponentBonus()), this.getCoilSize()});
        messages.addUnlocalized("Rotor: Energy:%.5f; Mass:%d; DragCoefficient:%.5f; BladeSurfaceArea:%d; BladeDrag:%.5f; FrictionalDrag:%.5f", new Object[]{Float.valueOf(this.getRotorEnergy()), this.getRotorMass(), Float.valueOf(this._rotorDragCoefficient), this.getBladeSurfaceArea(), Float.valueOf(this.getBladeDrag()), Float.valueOf(this.getFrictionalDrag())});
        messages.addUnlocalized("Fluids: MaxIntakeRate:%d; FluidPerBlade:%d; VentStatus:%s", new Object[]{this.getMaxIntakeRate(), this.getInputFluidPerBlade(), this.getVentSetting()});
    }

    private static class CoilStats
    implements Consumer<CoilMaterial> {
        public float Efficiency = 0.0f;
        public float Bonus = 0.0f;
        public float DragCoefficient = 0.0f;
        public int Size = 0;

        @Override
        public void accept(CoilMaterial material) {
            this.Efficiency += material.getEfficiency();
            this.Bonus += material.getBonus();
            this.DragCoefficient += material.getEnergyExtractionRate();
            ++this.Size;
        }
    }
}

