/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part;

import it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.GenericDeviceBlock;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.MultiblockTurbine;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.TurbinePartType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.rotor.RotorBladeState;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.rotor.RotorShaftState;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.variant.IMultiblockTurbineVariant;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.block.INeighborChangeListener;
import it.zerono.mods.zerocore.lib.block.multiblock.MultiblockPartBlock;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;

public abstract class TurbineRotorComponentBlock
extends GenericDeviceBlock<MultiblockTurbine, TurbinePartType>
implements INeighborChangeListener.Notifier {
    public static final EnumProperty<RotorShaftState> ROTOR_SHAFT_STATE = EnumProperty.func_177709_a((String)"state", RotorShaftState.class);
    public static final EnumProperty<RotorBladeState> ROTOR_BLADE_STATE = EnumProperty.func_177709_a((String)"state", RotorBladeState.class);
    private ITextComponent _bladeTooltipInfo;

    public static TurbineRotorComponentBlock shaft(MultiblockPartBlock.MultiblockPartProperties<TurbinePartType> properties) {
        return new TurbineRotorComponentBlock((MultiblockPartBlock.MultiblockPartProperties)properties){

            @Override
            public boolean isShaft() {
                return true;
            }

            @Override
            public boolean isBlade() {
                return false;
            }

            protected void buildBlockState(StateContainer.Builder<Block, BlockState> builder) {
                super.buildBlockState(builder);
                builder.func_206894_a(new Property[]{ROTOR_SHAFT_STATE});
            }

            protected BlockState buildDefaultState(BlockState state) {
                return (BlockState)super.buildDefaultState(state).func_206870_a((Property)ROTOR_SHAFT_STATE, (Comparable)((Object)RotorShaftState.getDefault()));
            }
        };
    }

    public static TurbineRotorComponentBlock blade(MultiblockPartBlock.MultiblockPartProperties<TurbinePartType> properties) {
        return new TurbineRotorComponentBlock((MultiblockPartBlock.MultiblockPartProperties)properties){

            @Override
            public boolean isShaft() {
                return false;
            }

            @Override
            public boolean isBlade() {
                return true;
            }

            protected void buildBlockState(StateContainer.Builder<Block, BlockState> builder) {
                super.buildBlockState(builder);
                builder.func_206894_a(new Property[]{ROTOR_BLADE_STATE});
            }

            protected BlockState buildDefaultState(BlockState state) {
                return (BlockState)super.buildDefaultState(state).func_206870_a((Property)ROTOR_BLADE_STATE, (Comparable)((Object)RotorBladeState.getDefault()));
            }
        };
    }

    public abstract boolean isShaft();

    public abstract boolean isBlade();

    @Override
    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        return this == adjacentBlockState.func_177230_c();
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        if (this.isBlade()) {
            if (null == this._bladeTooltipInfo) {
                this._bladeTooltipInfo = this.getMultiblockVariant().filter(v -> v instanceof IMultiblockTurbineVariant).map(v -> (IMultiblockTurbineVariant)v).map(variant -> new TranslationTextComponent("gui.bigreactors.turbine.controller.rotorstatus.line3", new Object[]{String.format(TextFormatting.DARK_AQUA + "" + TextFormatting.BOLD + "%d", variant.getBaseFluidPerBlade())}).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GRAY).func_240722_b_(Boolean.valueOf(true)))).orElse(CodeHelper.TEXT_EMPTY_LINE);
            }
            tooltip.add(this._bladeTooltipInfo);
        }
    }

    protected TurbineRotorComponentBlock(MultiblockPartBlock.MultiblockPartProperties<TurbinePartType> properties) {
        super(properties);
    }
}

