/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.innovation.item;

import cofh.core.compat.curios.CuriosProxy;
import cofh.core.util.ProxyUtils;
import cofh.core.util.helpers.ChatHelper;
import cofh.lib.item.IColorableItem;
import cofh.lib.item.IMultiModeItem;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.common.ThermalConfig;
import cofh.thermal.lib.item.EnergyContainerItemAugmentable;
import cofh.thermal.lib.item.IFlexibleEnergyContainerItem;
import cofh.thermal.lib.util.ThermalEnergyHelper;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class RFCapacitorItem
extends EnergyContainerItemAugmentable
implements IColorableItem,
IDyeableArmorItem,
IMultiModeItem,
IFlexibleEnergyContainerItem {
    protected static final int EQUIPMENT = 0;
    protected static final int INVENTORY = 1;

    public RFCapacitorItem(Item.Properties builder, int maxEnergy, int maxTransfer) {
        super(builder, maxEnergy, maxTransfer);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("color"), (stack, world, entity) -> this.func_200883_f_(stack) ? 1.0f : 0.0f);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("state"), (stack, world, entity) -> (this.isActive(stack) ? 0.5f : 0.0f) + (float)this.getMode(stack) / 8.0f);
        ProxyUtils.registerColorable((Item)this);
        this.numSlots = () -> ThermalConfig.storageAugments;
        this.augValidator = ThermalAugmentRules.ENERGY_STORAGE_VALIDATOR;
    }

    protected void tooltipDelegate(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)(this.isActive(stack) ? new TranslationTextComponent("info.cofh_use_sneak_deactivate").func_240699_a_(TextFormatting.DARK_GRAY) : new TranslationTextComponent("info.cofh.use_sneak_activate").func_240699_a_(TextFormatting.DARK_GRAY)));
        tooltip.add((ITextComponent)StringHelper.getTextComponent((String)("info.thermal.capacitor.mode." + this.getMode(stack))).func_240699_a_(TextFormatting.ITALIC));
        this.addModeChangeTooltip(this, stack, worldIn, tooltip, flagIn);
        super.tooltipDelegate(stack, worldIn, tooltip, flagIn);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        return this.useDelegate(stack, playerIn) ? ActionResult.func_226248_a_((Object)stack) : ActionResult.func_226250_c_((Object)stack);
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        return this.useDelegate(stack, context.func_195999_j()) ? ActionResultType.SUCCESS : ActionResultType.PASS;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        Iterable equipment;
        if (Utils.isClientWorld((World)worldIn) || Utils.isFakePlayer((Entity)entityIn) || !this.isActive(stack)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entityIn;
        switch (this.getMode(stack)) {
            case 0: {
                equipment = player.func_184209_aF();
                break;
            }
            case 1: {
                equipment = player.field_71071_by.field_70462_a;
                break;
            }
            default: {
                equipment = Iterables.concat(Arrays.asList(player.field_71071_by.field_70462_a, player.field_71071_by.field_70460_b, player.field_71071_by.field_184439_c));
            }
        }
        int extract = this.getExtract(stack);
        for (ItemStack equip : equipment) {
            if (stack.func_190926_b() || equip.equals(stack)) continue;
            equip.getCapability(ThermalEnergyHelper.getBaseEnergySystem(), null).ifPresent(e -> this.extractEnergy(stack, e.receiveEnergy(Math.min(extract, this.getEnergyStored(stack)), false), player.field_71075_bZ.field_75098_d));
        }
        if (this.getMode(stack) != 1) {
            CuriosProxy.getAllWorn((LivingEntity)player).ifPresent(c -> {
                for (int i = 0; i < c.getSlots(); ++i) {
                    ItemStack equip = c.getStackInSlot(i);
                    if (stack.func_190926_b() || equip.equals(stack)) continue;
                    equip.getCapability(ThermalEnergyHelper.getBaseEnergySystem(), null).ifPresent(e -> this.extractEnergy(stack, e.receiveEnergy(Math.min(extract, this.getEnergyStored(stack)), false), player.field_71075_bZ.field_75098_d));
                }
            });
        }
    }

    protected boolean useDelegate(ItemStack stack, PlayerEntity player) {
        if (Utils.isFakePlayer((Entity)player)) {
            return false;
        }
        if (player.func_226563_dT_()) {
            this.setActive(stack, !this.isActive(stack));
            player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.2f, this.isActive(stack) ? 0.8f : 0.5f);
            return true;
        }
        return false;
    }

    public int getNumModes(ItemStack stack) {
        return 3;
    }

    public void onModeChange(PlayerEntity player, ItemStack stack) {
        player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187750_dc, SoundCategory.PLAYERS, 0.4f, (this.isActive(stack) ? 0.7f : 0.5f) + 0.1f * (float)this.getMode(stack));
        ChatHelper.sendIndexedChatMessageToPlayer((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("info.thermal.capacitor.mode." + this.getMode(stack)));
    }
}

