/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.widget;

import com.google.common.collect.Iterators;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.AbstractList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import me.shedaniel.clothconfig2.api.AbstractConfigEntry;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigScreen;
import me.shedaniel.clothconfig2.gui.ClothConfigScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class SearchFieldEntry
extends AbstractConfigListEntry<Object> {
    private final TextFieldWidget editBox;
    private String[] lowerCases;

    public SearchFieldEntry(ConfigScreen screen, ClothConfigScreen.ListWidget<AbstractConfigEntry<AbstractConfigEntry<?>>> listWidget) {
        super((ITextComponent)new StringTextComponent(""), false);
        this.editBox = new TextFieldWidget(Minecraft.func_71410_x().field_71466_p, 0, 0, 100, 18, (ITextComponent)new StringTextComponent(""));
        this.lowerCases = this.editBox.func_146179_b().isEmpty() ? new String[]{} : this.editBox.func_146179_b().toLowerCase(Locale.ROOT).split(" ");
        this.editBox.func_212954_a(s -> {
            this.lowerCases = s.isEmpty() ? new String[]{} : s.toLowerCase(Locale.ROOT).split(" ");
        });
        listWidget.entriesTransformer = entries -> new AbstractList<AbstractConfigEntry<AbstractConfigEntry<?>>>((List)entries, screen){
            final /* synthetic */ List val$entries;
            final /* synthetic */ ConfigScreen val$screen;
            {
                this.val$entries = list;
                this.val$screen = configScreen;
            }

            @Override
            public Iterator<AbstractConfigEntry<AbstractConfigEntry<?>>> iterator() {
                if (SearchFieldEntry.this.editBox.func_146179_b().isEmpty()) {
                    return this.val$entries.iterator();
                }
                return Iterators.filter(this.val$entries.iterator(), entry -> this.val$screen.matchesSearch(entry.getSearchTags()));
            }

            @Override
            public AbstractConfigEntry<AbstractConfigEntry<?>> get(int index) {
                return (AbstractConfigEntry)Iterators.get(this.iterator(), (int)index);
            }

            @Override
            public void add(int index, AbstractConfigEntry<AbstractConfigEntry<?>> element) {
                this.val$entries.add(index, element);
            }

            @Override
            public AbstractConfigEntry<AbstractConfigEntry<?>> remove(int index) {
                Object entry = this.get(index);
                return this.val$entries.remove(entry) ? entry : null;
            }

            @Override
            public boolean remove(Object o) {
                return this.val$entries.remove(o);
            }

            @Override
            public void clear() {
                this.val$entries.clear();
            }

            @Override
            public int size() {
                return Iterators.size(this.iterator());
            }
        };
    }

    public boolean matchesSearch(Iterator<String> tags) {
        if (this.lowerCases.length == 0) {
            return true;
        }
        if (!tags.hasNext()) {
            return true;
        }
        for (String lowerCase : this.lowerCases) {
            boolean found = false;
            for (String tag : () -> tags) {
                if (!tag.toLowerCase(Locale.ROOT).contains(lowerCase)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Override
    public void render(MatrixStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        this.editBox.func_230991_b_(MathHelper.func_76125_a((int)(entryWidth - 10), (int)0, (int)500));
        this.editBox.field_230690_l_ = x + entryWidth / 2 - this.editBox.func_230998_h_() / 2;
        this.editBox.field_230691_m_ = y + entryHeight / 2 - 9;
        this.editBox.func_230430_a_(matrices, mouseX, mouseY, delta);
        if (this.editBox.func_146179_b().isEmpty()) {
            this.editBox.func_195612_c("Search...");
        } else {
            this.editBox.func_195612_c(null);
        }
        super.render(matrices, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public Optional<Object> getDefaultValue() {
        return Optional.empty();
    }

    public List<? extends IGuiEventListener> func_231039_at__() {
        return Collections.singletonList(this.editBox);
    }
}

