/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.impl.builders;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.EnumListEntry;
import me.shedaniel.clothconfig2.impl.builders.AbstractFieldBuilder;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class EnumSelectorBuilder<T extends Enum<?>>
extends AbstractFieldBuilder<T, EnumListEntry<T>, EnumSelectorBuilder<T>> {
    private final Class<T> clazz;
    private Function<Enum, ITextComponent> enumNameProvider = EnumListEntry.DEFAULT_NAME_PROVIDER;

    public EnumSelectorBuilder(ITextComponent resetButtonKey, ITextComponent fieldNameKey, Class<T> clazz, T value) {
        super(resetButtonKey, fieldNameKey);
        Objects.requireNonNull(clazz);
        Objects.requireNonNull(value);
        this.value = value;
        this.clazz = clazz;
    }

    @Override
    public EnumSelectorBuilder<T> setErrorSupplier(Function<T, Optional<ITextComponent>> errorSupplier) {
        return (EnumSelectorBuilder)super.setErrorSupplier(errorSupplier);
    }

    @Override
    public EnumSelectorBuilder<T> requireRestart() {
        return (EnumSelectorBuilder)super.requireRestart();
    }

    @Override
    public EnumSelectorBuilder<T> setSaveConsumer(Consumer<T> saveConsumer) {
        return (EnumSelectorBuilder)super.setSaveConsumer(saveConsumer);
    }

    @Override
    public EnumSelectorBuilder<T> setDefaultValue(Supplier<T> defaultValue) {
        return (EnumSelectorBuilder)super.setDefaultValue(defaultValue);
    }

    @Override
    public EnumSelectorBuilder<T> setDefaultValue(T defaultValue) {
        Objects.requireNonNull(defaultValue);
        this.defaultValue = () -> defaultValue;
        return this;
    }

    @Override
    public EnumSelectorBuilder<T> setTooltipSupplier(Function<T, Optional<ITextComponent[]>> tooltipSupplier) {
        return (EnumSelectorBuilder)super.setTooltipSupplier(tooltipSupplier);
    }

    @Override
    public EnumSelectorBuilder<T> setTooltipSupplier(Supplier<Optional<ITextComponent[]>> tooltipSupplier) {
        return (EnumSelectorBuilder)super.setTooltipSupplier(tooltipSupplier);
    }

    @Override
    public EnumSelectorBuilder<T> setTooltip(Optional<ITextComponent[]> tooltip) {
        return (EnumSelectorBuilder)super.setTooltip(tooltip);
    }

    @Override
    public EnumSelectorBuilder<T> setTooltip(ITextComponent ... tooltip) {
        return (EnumSelectorBuilder)super.setTooltip(tooltip);
    }

    public EnumSelectorBuilder<T> setEnumNameProvider(Function<Enum, ITextComponent> enumNameProvider) {
        Objects.requireNonNull(enumNameProvider);
        this.enumNameProvider = enumNameProvider;
        return this;
    }

    @Override
    @NotNull
    public EnumListEntry<T> build() {
        EnumListEntry<Enum> entry = new EnumListEntry<Enum>(this.getFieldNameKey(), this.clazz, (Enum)this.value, this.getResetButtonKey(), this.defaultValue, this.getSaveConsumer(), this.enumNameProvider, null, this.isRequireRestart());
        entry.setTooltipSupplier(() -> this.getTooltipSupplier().apply((Enum)entry.getValue()));
        if (this.errorSupplier != null) {
            entry.setErrorSupplier(() -> (Optional)this.errorSupplier.apply((Enum)entry.getValue()));
        }
        return entry;
    }
}

