/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.extraboats.core;

import com.minecraftabnormals.extraboats.common.dispenser.DispenseChestBoatBehavior;
import com.minecraftabnormals.extraboats.common.dispenser.DispenseFurnaceBoatBehavior;
import com.minecraftabnormals.extraboats.common.dispenser.DispenseLargeBoatBehavior;
import com.minecraftabnormals.extraboats.common.item.ChestBoatItem;
import com.minecraftabnormals.extraboats.common.item.ExtraBoatsBoatItem;
import com.minecraftabnormals.extraboats.common.item.FurnaceBoatItem;
import com.minecraftabnormals.extraboats.core.other.EBDataProcessors;
import com.minecraftabnormals.extraboats.core.other.EBRecipes;
import com.minecraftabnormals.extraboats.core.registry.EBEntities;
import com.minecraftabnormals.extraboats.core.registry.EBItems;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="extraboats")
public class ExtraBoats {
    public static final String MOD_ID = "extraboats";

    public ExtraBoats() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.register((Object)this);
        EBEntities.ENTITIES.register(bus);
        EBItems.ITEMS.register(bus);
        EBRecipes.RECIPE_SERIALIZERS.register(bus);
        bus.addListener(this::commonSetup);
        bus.addListener(this::clientSetup);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            for (RegistryObject item : EBItems.ITEMS.getEntries()) {
                ExtraBoatsBoatItem boatItem = (ExtraBoatsBoatItem)item.get();
                if (boatItem instanceof ChestBoatItem) {
                    DispenserBlock.func_199774_a((IItemProvider)boatItem, (IDispenseItemBehavior)new DispenseChestBoatBehavior(boatItem.getType()));
                    continue;
                }
                if (boatItem instanceof FurnaceBoatItem) {
                    DispenserBlock.func_199774_a((IItemProvider)boatItem, (IDispenseItemBehavior)new DispenseFurnaceBoatBehavior(boatItem.getType()));
                    continue;
                }
                DispenserBlock.func_199774_a((IItemProvider)boatItem, (IDispenseItemBehavior)new DispenseLargeBoatBehavior(boatItem.getType()));
            }
            EBDataProcessors.registerTrackedData();
        });
    }

    private void clientSetup(FMLClientSetupEvent event) {
        EBEntities.registerRenderers();
    }
}

