/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.api.energy;

import flaxbeard.immersivepetroleum.common.cfg.ConfigUtils;
import flaxbeard.immersivepetroleum.common.cfg.IPServerConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FuelHandler {
    protected static final Logger log = LogManager.getLogger((String)"immersivepetroleum/FuelHandler");
    static final Map<ResourceLocation, Values> portablegen = new HashMap<ResourceLocation, Values>();
    static final Map<ResourceLocation, Integer> motorboatAmountTick = new HashMap<ResourceLocation, Integer>();

    public static void registerPortableGeneratorFuel(Fluid fuel, int fluxPerTick, int mbPerTick) {
        if (fuel != null) {
            FuelHandler.registerPortableGeneratorFuel(fuel.getRegistryName(), mbPerTick, fluxPerTick);
        }
    }

    public static void registerMotorboatFuel(Fluid fuel, int mbPerTick) {
        if (fuel != null) {
            FuelHandler.registerMotorboatFuel(fuel.getRegistryName(), mbPerTick);
        }
    }

    public static void registerPortableGeneratorFuel(ResourceLocation fuelRL, int fluxPerTick, int mbPerTick) {
        if (fuelRL != null && !fuelRL.toString().isEmpty()) {
            portablegen.put(fuelRL, new Values(fluxPerTick, mbPerTick));
            log.info("Added {} as Portable Generator Fuel. ({}RF/t {}mB/t)", (Object)fuelRL, (Object)fluxPerTick, (Object)mbPerTick);
        }
    }

    public static void registerMotorboatFuel(ResourceLocation fuelRL, int mbPerTick) {
        if (fuelRL != null && !fuelRL.toString().isEmpty()) {
            motorboatAmountTick.put(fuelRL, mbPerTick);
            log.info("Added {} as Motorboat Fuel. ({} mB/t)", (Object)fuelRL, (Object)mbPerTick);
        }
    }

    public static boolean isValidBoatFuel(Fluid fuel) {
        return fuel != null ? motorboatAmountTick.containsKey(fuel.getRegistryName()) : false;
    }

    public static boolean isValidFuel(Fluid fuel) {
        return fuel != null ? portablegen.containsKey(fuel.getRegistryName()) : false;
    }

    public static int getBoatFuelUsedPerTick(Fluid fuel) {
        if (!FuelHandler.isValidBoatFuel(fuel)) {
            return 0;
        }
        return motorboatAmountTick.get(fuel.getRegistryName());
    }

    public static int getFuelUsedPerTick(Fluid fuel) {
        if (!FuelHandler.isValidFuel(fuel)) {
            return 0;
        }
        return FuelHandler.portablegen.get((Object)fuel.getRegistryName()).mbPerTick;
    }

    public static int getFluxGeneratedPerTick(Fluid fuel) {
        if (!FuelHandler.isValidFuel(fuel)) {
            return 0;
        }
        return FuelHandler.portablegen.get((Object)fuel.getRegistryName()).fluxPerTick;
    }

    public static void onConfigReload(ModConfig.ModConfigEvent ev) {
        if (ev.getConfig().getSpec() != IPServerConfig.ALL) {
            return;
        }
        portablegen.clear();
        motorboatAmountTick.clear();
        ConfigUtils.addFuel((List)IPServerConfig.GENERATION.fuels.get());
        ConfigUtils.addBoatFuel((List)IPServerConfig.MISCELLANEOUS.boat_fuels.get());
    }

    private static class Values {
        final int fluxPerTick;
        final int mbPerTick;

        Values(int fluxPerTick, int mbPerTick) {
            this.fluxPerTick = fluxPerTick;
            this.mbPerTick = mbPerTick;
        }
    }
}

