/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.metal;

import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.common.blocks.IPBlockBase;
import flaxbeard.immersivepetroleum.common.blocks.IPBlockItemBase;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.AutoLubricatorTileEntity;
import java.util.function.Predicate;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class AutoLubricatorBlock
extends IPBlockBase {
    private static final Material material = new Material(MaterialColor.field_151668_h, false, false, true, true, false, false, PushReaction.BLOCK);
    public static final DirectionProperty FACING = DirectionProperty.func_177712_a((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final BooleanProperty SLAVE = BooleanProperty.func_177716_a((String)"slave");
    static final VoxelShape SHAPE_SLAVE = VoxelShapes.func_197873_a((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)1.0, (double)0.8125);
    static final VoxelShape SHAPE_MASTER = VoxelShapes.func_197873_a((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)1.0, (double)0.9375);

    public AutoLubricatorBlock(String name) {
        super(name, AbstractBlock.Properties.func_200945_a((Material)material).func_200948_a(5.0f, 6.0f).harvestTool(ToolType.AXE).func_200947_a(SoundType.field_185852_e).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)SLAVE, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, SLAVE});
    }

    @Override
    protected BlockItem createBlockItem() {
        return new AutoLubricatorBlockItem(this);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f());
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        AutoLubricatorTileEntity te = new AutoLubricatorTileEntity();
        te.isSlave = (Boolean)state.func_177229_b((Property)SLAVE);
        te.facing = (Direction)state.func_177229_b((Property)FACING);
        return te;
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        if (((Boolean)state.func_177229_b((Property)SLAVE)).booleanValue()) {
            worldIn.func_175655_b(pos.func_177982_a(0, -1, 0), !player.func_184812_l_());
        } else {
            worldIn.func_175655_b(pos.func_177982_a(0, 1, 0), false);
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof IEBlockInterfaces.IPlayerInteraction && ((IEBlockInterfaces.IPlayerInteraction)te).interact(hit.func_216354_b(), player, handIn, player.func_184586_b(handIn), (float)hit.func_216347_e().field_72450_a, (float)hit.func_216347_e().field_72448_b, (float)hit.func_216347_e().field_72449_c)) {
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (!worldIn.field_72995_K) {
            worldIn.func_175656_a(pos.func_177982_a(0, 1, 0), (BlockState)state.func_206870_a((Property)SLAVE, (Comparable)Boolean.valueOf(true)));
            TileEntity te = worldIn.func_175625_s(pos);
            if (te instanceof IEBlockInterfaces.IReadOnPlacement) {
                ((IEBlockInterfaces.IReadOnPlacement)te).readOnPlacement(placer, stack);
            }
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return (Boolean)state.func_177229_b((Property)SLAVE) != false ? SHAPE_SLAVE : SHAPE_MASTER;
    }

    public static class AutoLubricatorBlockItem
    extends IPBlockItemBase {
        public AutoLubricatorBlockItem(Block blockIn) {
            super(blockIn, new Item.Properties().func_200916_a(ImmersivePetroleum.creativeTab));
        }

        protected boolean func_195944_a(BlockItemUseContext con, BlockState state) {
            if (super.func_195944_a(con, state)) {
                BlockPos pos = con.func_195995_a().func_177982_a(0, 1, 0);
                BlockState otherState = con.func_195991_k().func_180495_p(pos);
                otherState.func_177230_c().isAir(otherState, (IBlockReader)con.func_195991_k(), pos);
                return otherState.func_177230_c().isAir(otherState, (IBlockReader)con.func_195991_k(), pos);
            }
            return false;
        }
    }
}

