/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.tileentities;

import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.utils.shapes.CachedShapesWithTransform;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.PoweredMultiblockTileEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IETemplateMultiblock;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import com.google.common.collect.ImmutableSet;
import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.api.crafting.CokerUnitRecipe;
import flaxbeard.immersivepetroleum.common.IPTileTypes;
import flaxbeard.immersivepetroleum.common.multiblocks.CokerUnitMultiblock;
import flaxbeard.immersivepetroleum.common.util.FluidHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public class CokerUnitTileEntity
extends PoweredMultiblockTileEntity<CokerUnitTileEntity, CokerUnitRecipe>
implements IEBlockInterfaces.IInteractionObjectIE,
IEBlockInterfaces.IBlockBounds {
    public static final int TANK_INPUT = 0;
    public static final int TANK_OUTPUT = 1;
    public static final int CHAMBER_A = 0;
    public static final int CHAMBER_B = 1;
    public static final BlockPos Chamber_A_OUT = new BlockPos(2, 2, 2);
    public static final BlockPos Chamber_B_OUT = new BlockPos(6, 2, 2);
    public static final BlockPos Fluid_IN = new BlockPos(6, 0, 0);
    public static final BlockPos Fluid_OUT = new BlockPos(3, 0, 4);
    public static final BlockPos Item_IN = new BlockPos(4, 0, 0);
    public static final Set<BlockPos> Energy_IN = ImmutableSet.of((Object)new BlockPos(1, 1, 0), (Object)new BlockPos(2, 1, 0), (Object)new BlockPos(3, 1, 0));
    public static final Set<BlockPos> Redstone_IN = ImmutableSet.of((Object)new BlockPos(6, 1, 4));
    public final NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)Inventory.values().length, (Object)ItemStack.field_190927_a);
    public final FluidTank[] bufferTanks = new FluidTank[]{new FluidTank(16000), new FluidTank(16000)};
    public final CokingChamber[] chambers = new CokingChamber[]{new CokingChamber(64, 8000), new CokingChamber(64, 8000)};
    private LazyOptional<IItemHandler> insertionHandler = this.registerConstantCap(new IEInventoryHandler(1, (IIEInventory)this, 0, new boolean[]{true}, new boolean[8]));
    int updateDelay = 0;
    int lastCompared = 0;
    private static CachedShapesWithTransform<BlockPos, Pair<Direction, Boolean>> SHAPES = CachedShapesWithTransform.createForMultiblock(CokerUnitTileEntity::getShape);
    public static boolean updateShapes = false;

    public CokerUnitTileEntity() {
        super((IETemplateMultiblock)CokerUnitMultiblock.INSTANCE, 24000, true, null);
    }

    public TileEntityType<?> func_200662_C() {
        return (TileEntityType)IPTileTypes.COKER.get();
    }

    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.bufferTanks[0].readFromNBT(nbt.func_74775_l("tank0"));
        this.bufferTanks[1].readFromNBT(nbt.func_74775_l("tank1"));
        this.chambers[0].readFromNBT(nbt.func_74775_l("chamber0"));
        this.chambers[1].readFromNBT(nbt.func_74775_l("chamber1"));
        if (!descPacket) {
            this.readInventory(nbt.func_74775_l("inventory"));
        }
    }

    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_218657_a("tank0", (INBT)this.bufferTanks[0].writeToNBT(new CompoundNBT()));
        nbt.func_218657_a("tank1", (INBT)this.bufferTanks[1].writeToNBT(new CompoundNBT()));
        nbt.func_218657_a("chamber0", (INBT)this.chambers[0].writeToNBT(new CompoundNBT()));
        nbt.func_218657_a("chamber1", (INBT)this.chambers[1].writeToNBT(new CompoundNBT()));
        if (!descPacket) {
            nbt.func_218657_a("inventory", (INBT)this.writeInventory(this.inventory));
        }
    }

    protected void readInventory(CompoundNBT nbt) {
        NonNullList list = NonNullList.func_191196_a();
        ItemStackHelper.func_191283_b((CompoundNBT)nbt, (NonNullList)list);
        for (int i = 0; i < this.inventory.size(); ++i) {
            ItemStack stack = ItemStack.field_190927_a;
            if (i < list.size()) {
                stack = (ItemStack)list.get(i);
            }
            this.inventory.set(i, (Object)stack);
        }
    }

    protected CompoundNBT writeInventory(NonNullList<ItemStack> list) {
        return ItemStackHelper.func_191282_a((CompoundNBT)new CompoundNBT(), list);
    }

    protected boolean canFillTankFrom(int iTank, Direction side, FluidStack resource) {
        CokerUnitTileEntity master;
        if (this.posInMultiblock.equals((Object)Fluid_IN) && (side == null || side == this.getFacing()) && (master = (CokerUnitTileEntity)this.master()) != null && master.bufferTanks[0].getFluidAmount() < master.bufferTanks[0].getCapacity()) {
            if (master.bufferTanks[0].isEmpty()) {
                return CokerUnitRecipe.hasRecipeWithInput(resource, true);
            }
            return resource.isFluidEqual(master.bufferTanks[0].getFluid());
        }
        return false;
    }

    protected boolean canDrainTankFrom(int iTank, Direction side) {
        if (this.posInMultiblock.equals((Object)Fluid_OUT) && (side == null || side == this.getFacing())) {
            CokerUnitTileEntity master = (CokerUnitTileEntity)this.master();
            return master != null && master.bufferTanks[1].getFluidAmount() > 0;
        }
        return false;
    }

    public void doGraphicalUpdates() {
        this.updateMasterBlock(null, true);
    }

    public CokerUnitRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    public boolean additionalCanProcessCheck(PoweredMultiblockTileEntity.MultiblockProcess<CokerUnitRecipe> process) {
        return false;
    }

    public void doProcessOutput(ItemStack output) {
    }

    public <C> LazyOptional<C> getCapability(@Nonnull Capability<C> capability, @Nullable Direction facing) {
        CokerUnitTileEntity master;
        if ((facing == null || this.posInMultiblock.equals((Object)Item_IN)) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (master = (CokerUnitTileEntity)this.master()) != null) {
            return master.insertionHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void doProcessFluidOutput(FluidStack output) {
    }

    public void onProcessFinish(PoweredMultiblockTileEntity.MultiblockProcess<CokerUnitRecipe> process) {
    }

    public void func_73660_a() {
        ItemStack container;
        this.checkForNeedlessTicking();
        if (this.isDummy()) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            boolean debug = false;
            for (int i = 0; i < this.chambers.length; ++i) {
                if (!debug && this.chambers[i].getState() != CokingState.DUMPING) continue;
                BlockPos cOutPos = this.getBlockPosForPos(i == 0 ? Chamber_A_OUT : Chamber_B_OUT);
                Vector3d origin = new Vector3d((double)cOutPos.func_177958_n() + 0.5, (double)cOutPos.func_177956_o() + 0.125, (double)cOutPos.func_177952_p() + 0.5);
                for (int j = 0; j < 10; ++j) {
                    double rX = (Math.random() - 0.5) * 0.4;
                    double rY = (Math.random() - 0.5) * 0.5;
                    double rdx = (Math.random() - 0.5) * 0.05;
                    double rdy = (Math.random() - 0.5) * 0.05;
                    this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197601_L, origin.field_72450_a + rX, origin.field_72448_b, origin.field_72449_c + rY, rdx, -(Math.random() * 0.06 + 0.11), rdy);
                }
            }
            return;
        }
        boolean update = false;
        if (!this.isRSDisabled()) {
            CokerUnitRecipe recipe;
            ItemStack inputStack = this.getInventory(Inventory.INPUT);
            FluidStack inputFluid = this.bufferTanks[0].getFluid();
            if (!inputStack.func_190926_b() && inputFluid.getAmount() > 0 && CokerUnitRecipe.hasRecipeWithInput(inputStack, inputFluid) && (recipe = CokerUnitRecipe.findRecipe(inputStack, inputFluid)) != null && inputStack.func_190916_E() >= recipe.inputItem.getCount() && inputFluid.getAmount() >= recipe.inputFluid.getAmount()) {
                for (int i = 0; i < this.chambers.length; ++i) {
                    CokingChamber chamber = this.chambers[i];
                    boolean skipNext = false;
                    switch (chamber.getState()) {
                        case STANDBY: {
                            if (!chamber.setRecipe(recipe)) break;
                            update = true;
                            skipNext = true;
                            break;
                        }
                        case PROCESSING: {
                            int acceptedStack = chamber.addStack(this.copyStack(inputStack, recipe.inputItem.getCount()), true);
                            if (acceptedStack < recipe.inputItem.getCount()) break;
                            acceptedStack = Math.min(acceptedStack, inputStack.func_190916_E());
                            chamber.addStack(this.copyStack(inputStack, acceptedStack), false);
                            inputStack.func_190918_g(acceptedStack);
                            skipNext = true;
                            update = true;
                            break;
                        }
                    }
                    if (skipNext) break;
                }
            }
            for (int i = 0; i < this.chambers.length; ++i) {
                update |= this.chambers[i].tick(this, i);
            }
        }
        if (!this.getInventory(Inventory.INPUT_FILLED).func_190926_b() && this.bufferTanks[0].getFluidAmount() < this.bufferTanks[0].getCapacity() && !(container = Utils.drainFluidContainer((IFluidHandler)this.bufferTanks[0], (ItemStack)this.getInventory(Inventory.INPUT_FILLED), (ItemStack)this.getInventory(Inventory.INPUT_EMPTY))).func_190926_b()) {
            if (!this.getInventory(Inventory.INPUT_EMPTY).func_190926_b() && ItemHandlerHelper.canItemStacksStack((ItemStack)this.getInventory(Inventory.INPUT_EMPTY), (ItemStack)container)) {
                this.getInventory(Inventory.INPUT_EMPTY).func_190917_f(container.func_190916_E());
            } else if (this.getInventory(Inventory.INPUT_EMPTY).func_190926_b()) {
                this.setInventory(Inventory.INPUT_EMPTY, container.func_77946_l());
            }
            this.getInventory(Inventory.INPUT_FILLED).func_190918_g(1);
            if (this.getInventory(Inventory.INPUT_FILLED).func_190916_E() <= 0) {
                this.setInventory(Inventory.INPUT_FILLED, ItemStack.field_190927_a);
            }
            update = true;
        }
        if (this.bufferTanks[1].getFluidAmount() > 0) {
            ItemStack filledContainer;
            if (!this.getInventory(Inventory.OUTPUT_EMPTY).func_190926_b() && !(filledContainer = Utils.fillFluidContainer((IFluidHandler)this.bufferTanks[1], (ItemStack)this.getInventory(Inventory.OUTPUT_EMPTY), (ItemStack)this.getInventory(Inventory.OUTPUT_FILLED), null)).func_190926_b()) {
                if (this.getInventory(Inventory.OUTPUT_FILLED).func_190916_E() == 1 && !Utils.isFluidContainerFull((ItemStack)filledContainer)) {
                    this.setInventory(Inventory.OUTPUT_FILLED, filledContainer.func_77946_l());
                } else {
                    if (!this.getInventory(Inventory.OUTPUT_FILLED).func_190926_b() && ItemHandlerHelper.canItemStacksStack((ItemStack)this.getInventory(Inventory.OUTPUT_FILLED), (ItemStack)filledContainer)) {
                        this.getInventory(Inventory.OUTPUT_FILLED).func_190917_f(filledContainer.func_190916_E());
                    } else if (this.getInventory(Inventory.OUTPUT_FILLED).func_190926_b()) {
                        this.setInventory(Inventory.OUTPUT_FILLED, filledContainer.func_77946_l());
                    }
                    this.getInventory(Inventory.OUTPUT_EMPTY).func_190918_g(1);
                    if (this.getInventory(Inventory.OUTPUT_EMPTY).func_190916_E() <= 0) {
                        this.setInventory(Inventory.OUTPUT_EMPTY, ItemStack.field_190927_a);
                    }
                }
                update = true;
            }
            BlockPos outPos = this.getBlockPosForPos(Fluid_OUT).func_177972_a(this.getFacing().func_176734_d());
            update |= FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)outPos, (Direction)this.getFacing()).map(out -> {
                if (this.bufferTanks[1].getFluidAmount() > 0) {
                    FluidStack fs = this.bufferTanks[1].getFluid();
                    int accepted = out.fill(fs = FluidHelper.copyFluid(fs, Math.min(fs.getAmount(), 250)), IFluidHandler.FluidAction.SIMULATE);
                    if (accepted > 0) {
                        int drained = out.fill(FluidHelper.copyFluid(fs, Math.min(fs.getAmount(), accepted)), IFluidHandler.FluidAction.EXECUTE);
                        this.bufferTanks[1].drain(FluidHelper.copyFluid(fs, drained), IFluidHandler.FluidAction.EXECUTE);
                        return true;
                    }
                }
                return false;
            }).orElse(false).booleanValue();
        }
        if (update) {
            this.updateMasterBlock(null, true);
        }
        this.updateComparatorOutput();
    }

    private void updateComparatorOutput() {
        boolean update = false;
        ItemStack stack = this.getInventory(Inventory.INPUT);
        if (!stack.func_190926_b()) {
            int compared = MathHelper.func_76125_a((int)MathHelper.func_76141_d((float)((float)stack.func_190916_E() / (float)Math.min(this.getSlotLimit(Inventory.INPUT.id()), stack.func_77976_d()) * 15.0f)), (int)0, (int)15);
            if (compared != this.lastCompared) {
                this.lastCompared = compared;
                update = true;
            }
        } else if (this.lastCompared != 0) {
            this.lastCompared = 0;
            update = true;
        }
        if (update) {
            this.getRedstonePos().forEach(pos -> {
                BlockPos p = this.getBlockPosForPos((BlockPos)pos);
                this.field_145850_b.func_195593_d(p, this.field_145850_b.func_180495_p(p).func_177230_c());
            });
        }
    }

    public int getComparatorInputOverride() {
        CokerUnitTileEntity master;
        if (this.isRedstonePos() && (master = (CokerUnitTileEntity)this.master()) != null) {
            return master.lastCompared;
        }
        return 0;
    }

    private ItemStack copyStack(ItemStack stack, int amount) {
        ItemStack copy = stack.func_77946_l();
        copy.func_190920_e(amount);
        return copy;
    }

    public ItemStack getInventory(Inventory inv) {
        return (ItemStack)this.inventory.get(inv.id());
    }

    public ItemStack setInventory(Inventory inv, ItemStack stack) {
        return (ItemStack)this.inventory.set(inv.id(), (Object)stack);
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    protected CokerUnitRecipe getRecipeForId(ResourceLocation id) {
        return CokerUnitRecipe.recipes.get(id);
    }

    public Set<BlockPos> getEnergyPos() {
        return Energy_IN;
    }

    public Set<BlockPos> getRedstonePos() {
        return Redstone_IN;
    }

    public IFluidTank[] getInternalTanks() {
        return this.bufferTanks;
    }

    public int[] getOutputSlots() {
        return new int[0];
    }

    public int[] getOutputTanks() {
        return new int[]{1};
    }

    public int getMaxProcessPerTick() {
        return 1;
    }

    public int getProcessQueueMaxLength() {
        return 2;
    }

    public float getMinProcessDistance(PoweredMultiblockTileEntity.MultiblockProcess<CokerUnitRecipe> process) {
        return 1.0f;
    }

    protected IFluidTank[] getAccessibleFluidTanks(Direction side) {
        CokerUnitTileEntity master = (CokerUnitTileEntity)this.master();
        if (master != null) {
            if (this.posInMultiblock.equals((Object)Fluid_IN) && (side == null || side == this.getFacing())) {
                return new IFluidTank[]{master.bufferTanks[0]};
            }
            if (this.posInMultiblock.equals((Object)Fluid_OUT) && (side == null || side == this.getFacing().func_176734_d())) {
                return new IFluidTank[]{master.bufferTanks[1]};
            }
        }
        return new IFluidTank[0];
    }

    public int getComparatedSize() {
        return 1;
    }

    public IEBlockInterfaces.IInteractionObjectIE getGuiMaster() {
        return (IEBlockInterfaces.IInteractionObjectIE)this.master();
    }

    public boolean canUseGui(PlayerEntity player) {
        return this.formed;
    }

    public boolean isInWorldProcessingMachine() {
        return false;
    }

    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    public boolean isLadder() {
        int bX = this.posInMultiblock.func_177958_n();
        int bY = this.posInMultiblock.func_177956_o();
        int bZ = this.posInMultiblock.func_177952_p();
        if (bX == 0 && bZ == 2 && bY >= 3 && bY <= 12) {
            return true;
        }
        return bX == 1 && bZ == 2 && bY >= 13 && bY <= 17;
    }

    public VoxelShape getBlockBounds(ISelectionContext ctx) {
        if (updateShapes) {
            updateShapes = false;
            SHAPES = CachedShapesWithTransform.createForMultiblock(CokerUnitTileEntity::getShape);
        }
        return SHAPES.get((Object)this.posInMultiblock, (Object)Pair.of((Object)this.getFacing(), (Object)this.getIsMirrored()));
    }

    private static List<AxisAlignedBB> getShape(BlockPos posInMultiblock) {
        int bX = posInMultiblock.func_177958_n();
        int bY = posInMultiblock.func_177956_o();
        int bZ = posInMultiblock.func_177952_p();
        ArrayList<AxisAlignedBB> main = new ArrayList<AxisAlignedBB>();
        if (bY >= 3 && bY <= 12) {
            if (bX == 0 && bZ == 0) {
                main.add(new AxisAlignedBB(0.125, 0.0, 0.125, 0.375, 1.0, 0.375));
            } else if (bX == 0 && bZ == 4) {
                main.add(new AxisAlignedBB(0.125, 0.0, 0.625, 0.375, 1.0, 0.875));
            } else if (bX == 8 && bZ == 0) {
                main.add(new AxisAlignedBB(0.625, 0.0, 0.125, 0.875, 1.0, 0.375));
            } else if (bX == 8 && bZ == 4) {
                main.add(new AxisAlignedBB(0.625, 0.0, 0.625, 0.875, 1.0, 0.875));
            }
            if (bX == 4 && bZ == 4) {
                main.add(new AxisAlignedBB(0.375, 0.0, 0.625, 0.625, 1.0, 0.875));
            } else if (bY >= 4 && bX == 4 && bZ == 0) {
                main.add(new AxisAlignedBB(0.375, 0.0, 0.125, 0.625, 1.0, 0.375));
            }
            if (bY == 5 || bY == 10) {
                if (bX > 0 && bX < 8) {
                    if (bZ == 0) {
                        main.add(new AxisAlignedBB(0.0, 0.125, 0.125, 1.0, 0.375, 0.375));
                    } else if (bZ == 4) {
                        main.add(new AxisAlignedBB(0.0, 0.125, 0.625, 1.0, 0.375, 0.875));
                    }
                } else {
                    if (bX == 0 && bZ == 0) {
                        main.add(new AxisAlignedBB(0.125, 0.125, 0.125, 0.375, 0.375, 1.0));
                        main.add(new AxisAlignedBB(0.125, 0.125, 0.125, 1.0, 0.375, 0.375));
                    } else if (bX == 0 && bZ == 4) {
                        main.add(new AxisAlignedBB(0.125, 0.125, 0.125, 0.375, 0.375, 0.875));
                        main.add(new AxisAlignedBB(0.125, 0.125, 0.625, 1.0, 0.375, 0.875));
                    } else if (bX == 8 && bZ == 0) {
                        main.add(new AxisAlignedBB(0.625, 0.125, 0.125, 0.875, 0.375, 1.0));
                        main.add(new AxisAlignedBB(0.125, 0.125, 0.125, 0.875, 0.375, 0.375));
                    } else if (bX == 8 && bZ == 4) {
                        main.add(new AxisAlignedBB(0.0, 0.125, 0.625, 0.875, 0.375, 0.875));
                        main.add(new AxisAlignedBB(0.625, 0.125, 0.0, 0.875, 0.375, 0.875));
                    }
                    if (bX == 0 && (bZ == 1 || bZ == 3)) {
                        main.add(new AxisAlignedBB(0.125, 0.125, 0.0, 0.375, 0.375, 1.0));
                    }
                    if (bX == 8 && bZ > 0 && bZ < 4) {
                        main.add(new AxisAlignedBB(0.625, 0.125, 0.0, 0.875, 0.375, 1.0));
                    }
                }
            }
        }
        if (bY == 0 && (bZ == 1 || bZ == 3 || (bX == 5 || bX == 7) && bZ == 0 || (bX == 1 || bX >= 5 && bX <= 7) && bZ == 4)) {
            main.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0));
        }
        if (bY == 0 && bZ == 4 && (bX == 2 || bX == 3)) {
            main.add(new AxisAlignedBB(0.0, 0.0, -0.25, 1.0, 1.0, 1.0));
        }
        if (bY == 1 && bZ == 4 && (bX == 2 || bX == 3)) {
            main.add(new AxisAlignedBB(0.0, 0.0, -0.25, 1.0, 0.625, 1.0));
        }
        if (bY == 0 && bX == 6 && bZ == 4) {
            main.add(new AxisAlignedBB(0.75, 0.5, 0.625, 0.875, 1.0, 0.875));
            main.add(new AxisAlignedBB(0.125, 0.5, 0.625, 0.25, 1.0, 0.875));
        } else if (bY == 1 && bX == 6 && bZ == 4) {
            main.add(new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 1.0, 1.0));
        }
        if (bY == 1 && bZ == 0 && bX >= 1 && bX <= 3) {
            main.add(new AxisAlignedBB(0.0, 0.0, 0.25, 1.0, 1.0, 1.25));
            main.add(new AxisAlignedBB(0.25, 0.25, 0.0, 0.75, 0.75, 0.5));
        }
        if (bY == 0 && bZ == 0 && bX >= 1 && bX <= 3) {
            main.add(new AxisAlignedBB(0.0, 0.0, 0.25, 1.0, 1.0, 1.25));
        }
        if (bY == 3) {
            if (bZ == 0) {
                if (bX == 3) {
                    main.add(new AxisAlignedBB(0.0, 0.0, 0.0625, 0.25, 0.25, 1.0));
                    main.add(new AxisAlignedBB(0.25, 0.0, 0.0625, 0.5, 0.5, 1.0));
                    main.add(new AxisAlignedBB(0.5, 0.0, 0.0625, 0.75, 0.75, 1.0));
                    main.add(new AxisAlignedBB(0.75, 0.0, 0.0625, 1.0, 1.0, 1.0));
                }
                if (bX == 4) {
                    main.add(new AxisAlignedBB(0.0, 0.0, 0.0625, 1.0, 1.0, 1.0));
                }
                if (bX == 5) {
                    main.add(new AxisAlignedBB(0.0, 0.0, 0.0625, 0.25, 1.0, 1.0));
                    main.add(new AxisAlignedBB(0.25, 0.0, 0.0625, 0.5, 0.75, 1.0));
                    main.add(new AxisAlignedBB(0.5, 0.0, 0.0625, 0.75, 0.5, 1.0));
                    main.add(new AxisAlignedBB(0.75, 0.0, 0.0625, 1.0, 0.25, 1.0));
                }
            } else if (bX == 4 && bZ == 3) {
                main.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.25));
                main.add(new AxisAlignedBB(0.0, 0.0, 0.25, 1.0, 0.75, 0.5));
                main.add(new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 0.5, 0.75));
                main.add(new AxisAlignedBB(0.0, 0.0, 0.75, 1.0, 0.25, 1.0));
            }
        }
        if (!(bY != 7 && bY != 12 || bX == 0 && bZ == 2 || bX > 0 && bX < 8 && bZ > 0 && bZ < 4 && (bX != 4 || bZ < 1 || bZ > 3))) {
            main.add(new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0));
        }
        if (bY == 17 && (bX >= 1 && bX <= 7 && (bZ == 1 || bZ == 3) || bX == 7 && bZ == 2)) {
            main.add(new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0));
        }
        if (bX == 0 && bZ == 2 && bY >= 3 && bY <= 12) {
            main.add(new AxisAlignedBB(1.005, 0.0, 0.125, 1.005, 1.0, 0.875));
            if (bY >= 5) {
                main.add(new AxisAlignedBB(0.0, 0.0, 0.0, 0.0625, 1.0, 1.0));
                if (bY != 8 && bY != 9) {
                    main.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.0625));
                    main.add(new AxisAlignedBB(0.0, 0.0, 0.9375, 1.0, 1.0, 1.0));
                }
            }
        }
        if (bX == 1 && bZ == 2 && bY >= 13 && bY <= 17) {
            main.add(new AxisAlignedBB(0.875, 0.0, 0.125, 0.9375, 1.0, 0.875));
            if (bY >= 15) {
                main.add(new AxisAlignedBB(0.0, 0.0, 0.0, 0.0625, 1.0, 1.0));
                main.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.0625));
                main.add(new AxisAlignedBB(0.0, 0.0, 0.9375, 1.0, 1.0, 1.0));
            }
        }
        if (bX == 2 && bZ == 4) {
            if (bY == 1) {
                main.add(new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75));
                main.add(new AxisAlignedBB(0.125, 0.875, 0.875, 0.875, 1.0, 0.125));
            }
            if (bY >= 3 && bY <= 6) {
                main.add(new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75));
                if (bY == 3 || bY == 5 || bY == 6) {
                    main.add(new AxisAlignedBB(0.125, 0.0, 0.875, 0.875, 0.125, 0.125));
                }
                if (bY == 4 || bY == 5 || bY == 6) {
                    main.add(new AxisAlignedBB(0.125, 0.875, 0.875, 0.875, 1.0, 0.125));
                }
            }
        }
        if (bX == 6 && bZ == 0) {
            if (bY >= 1 && bY <= 6 && bY != 2) {
                main.add(new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75));
            }
            if (bY == 1) {
                main.add(new AxisAlignedBB(0.125, 0.0, 0.875, 0.875, 0.125, 0.125));
                main.add(new AxisAlignedBB(0.125, 0.875, 0.875, 0.875, 1.0, 0.125));
            }
            if (bY == 3) {
                main.add(new AxisAlignedBB(0.125, 0.0, 0.875, 0.875, 0.125, 0.125));
            }
            if (bY == 6) {
                main.add(new AxisAlignedBB(0.125, 0.875, 0.875, 0.875, 1.0, 0.125));
            }
        }
        if (bY == 7) {
            switch (bX) {
                case 2: {
                    if (bZ != 4) break;
                    main.add(new AxisAlignedBB(0.875, 0.125, 0.875, 1.0, 0.875, 0.125));
                    main.add(new AxisAlignedBB(0.125, 0.0, 0.875, 0.875, 0.125, 0.125));
                    main.add(new AxisAlignedBB(0.25, 0.125, 0.75, 0.875, 0.875, 0.25));
                    break;
                }
                case 3: {
                    if (bZ != 4) break;
                    main.add(new AxisAlignedBB(0.0, 0.25, 0.75, 1.0, 0.75, 0.25));
                    main.add(new AxisAlignedBB(0.0, 0.125, 0.875, 0.125, 0.875, 0.125));
                    break;
                }
                case 4: {
                    if (bZ != 4) break;
                    main.add(new AxisAlignedBB(0.0, 0.25, 0.75, 1.0, 0.75, 0.25));
                    break;
                }
                case 5: {
                    if (bZ != 4) break;
                    main.add(new AxisAlignedBB(0.0, 0.25, 0.75, 1.0, 0.75, 0.25));
                    main.add(new AxisAlignedBB(0.875, 0.125, 0.875, 1.0, 0.875, 0.125));
                    break;
                }
                case 6: {
                    if (bZ == 0) {
                        main.add(new AxisAlignedBB(0.125, 0.0, 0.875, 0.875, 0.125, 0.125));
                        main.add(new AxisAlignedBB(0.875, 0.125, 0.875, 1.0, 0.875, 0.125));
                        main.add(new AxisAlignedBB(0.25, 0.125, 0.75, 0.875, 0.75, 0.25));
                        break;
                    }
                    if (bZ != 4) break;
                    main.add(new AxisAlignedBB(0.0, 0.125, 0.875, 0.125, 0.875, 0.125));
                    main.add(new AxisAlignedBB(0.125, 0.25, 0.75, 0.75, 0.75, 0.125));
                    break;
                }
                case 7: {
                    if (bZ != 0) break;
                    main.add(new AxisAlignedBB(0.0, 0.125, 0.875, 0.125, 0.875, 0.125));
                    main.add(new AxisAlignedBB(0.875, 0.125, 0.875, 1.0, 0.875, 0.125));
                    main.add(new AxisAlignedBB(0.0, 0.25, 0.75, 1.0, 0.75, 0.25));
                    break;
                }
                case 8: {
                    if (bZ == 0) {
                        main.add(new AxisAlignedBB(0.0, 0.125, 0.875, 0.125, 0.875, 0.125));
                        main.add(new AxisAlignedBB(0.125, 0.125, 0.875, 0.875, 0.875, 1.0));
                        main.add(new AxisAlignedBB(0.625, 0.0, 0.125, 0.875, 1.0, 0.375));
                        main.add(new AxisAlignedBB(0.125, 0.25, 0.875, 0.75, 0.75, 0.25));
                        break;
                    }
                    if (bZ == 1) {
                        main.add(new AxisAlignedBB(0.125, 0.125, 0.125, 0.875, 0.875, 0.0));
                        main.add(new AxisAlignedBB(0.125, 0.125, 0.875, 0.875, 0.875, 1.0));
                        main.add(new AxisAlignedBB(0.25, 0.25, 0.0, 0.75, 0.75, 1.0));
                        break;
                    }
                    if (bZ == 2) {
                        main.add(new AxisAlignedBB(0.125, 0.125, 0.125, 0.875, 0.875, 0.0));
                        main.add(new AxisAlignedBB(0.25, 0.25, 0.125, 0.75, 0.875, 0.75));
                        break;
                    }
                    if (bZ != 4) break;
                    main.add(new AxisAlignedBB(0.625, 0.0, 0.625, 0.875, 1.0, 0.875));
                }
            }
        }
        if (bX == 8 && bZ == 2) {
            if (bY >= 8 && bY <= 13) {
                main.add(new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75));
            }
            if (bY == 8) {
                main.add(new AxisAlignedBB(0.125, 0.0, 0.875, 0.875, 0.125, 0.125));
            }
            if (bY == 13) {
                main.add(new AxisAlignedBB(0.125, 0.875, 0.875, 0.875, 1.0, 0.125));
            }
        }
        if (bY == 14) {
            if (bX >= 3 && bX <= 6 && bZ == 2) {
                main.add(new AxisAlignedBB(0.0, 0.25, 0.75, 1.0, 0.75, 0.25));
                if (bX == 6) {
                    main.add(new AxisAlignedBB(0.875, 0.125, 0.875, 1.0, 0.875, 0.125));
                }
            }
            if (bX == 7 && bZ == 2) {
                main.add(new AxisAlignedBB(0.0, 0.125, 0.875, 0.125, 0.875, 0.125));
                main.add(new AxisAlignedBB(0.875, 0.125, 0.875, 1.0, 0.875, 0.125));
                main.add(new AxisAlignedBB(0.0, 0.25, 0.75, 1.0, 0.75, 0.25));
            }
            if (bX == 8 && bZ == 2) {
                main.add(new AxisAlignedBB(0.0, 0.125, 0.875, 0.125, 0.875, 0.125));
                main.add(new AxisAlignedBB(0.125, 0.0, 0.875, 0.875, 0.125, 0.125));
                main.add(new AxisAlignedBB(0.125, 0.125, 0.75, 0.75, 0.75, 0.25));
            }
        }
        if (bY >= 13 && bY <= 22) {
            if (bX == 3 && bZ == 2) {
                main.add(new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75).func_72317_d(-0.25, 0.0, 0.0));
                if (bY == 13) {
                    main.add(new AxisAlignedBB(0.125, 0.0, 0.875, 0.875, 0.125, 0.125).func_72317_d(-0.25, 0.0, 0.0));
                }
            }
            if (bX == 5 && bZ == 2) {
                main.add(new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75).func_72317_d(0.25, 0.0, 0.0));
                if (bY == 13) {
                    main.add(new AxisAlignedBB(0.125, 0.0, 0.875, 0.875, 0.125, 0.125).func_72317_d(0.25, 0.0, 0.0));
                }
            }
        }
        if (bZ == 1) {
            if (bX == 2) {
                switch (bY) {
                    case 13: {
                        main.add(new AxisAlignedBB(0.0625, 0.0, 0.25, 0.3125, 1.0, 0.5625));
                        main.add(new AxisAlignedBB(0.0625, 0.0, 0.0, 0.3125, 0.25, 1.0));
                        main.add(new AxisAlignedBB(0.0, 0.0, 0.25, 1.0, 0.25, 0.5));
                        break;
                    }
                    case 14: {
                        main.add(new AxisAlignedBB(0.0625, 0.0, 0.3125, 0.3125, 1.0, 0.625));
                        break;
                    }
                    case 15: {
                        main.add(new AxisAlignedBB(0.0625, 0.0, 0.375, 0.3125, 1.0, 0.6875));
                        main.add(new AxisAlignedBB(0.0625, 0.25, 0.375, 0.3125, 0.5, 1.0));
                        main.add(new AxisAlignedBB(0.0625, 0.25, 0.4375, 1.0, 0.5, 0.6875));
                        break;
                    }
                    case 16: {
                        main.add(new AxisAlignedBB(0.0625, 0.0, 0.4375, 0.3125, 1.0, 0.75));
                        break;
                    }
                    case 17: {
                        main.add(new AxisAlignedBB(0.0625, 0.0, 0.5, 0.3125, 1.0, 0.8125));
                    }
                }
            }
            if (bX == 4) {
                switch (bY) {
                    case 13: {
                        main.add(new AxisAlignedBB(0.375, 0.0, 0.25, 0.625, 1.0, 0.5625));
                        main.add(new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 0.25, 1.0));
                        main.add(new AxisAlignedBB(0.0, 0.0, 0.25, 1.0, 0.25, 0.5));
                        break;
                    }
                    case 14: {
                        main.add(new AxisAlignedBB(0.375, 0.0, 0.3125, 0.625, 1.0, 0.625));
                        break;
                    }
                    case 15: {
                        main.add(new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.6875));
                        main.add(new AxisAlignedBB(0.0, 0.25, 0.4375, 1.0, 0.5, 0.6875));
                        main.add(new AxisAlignedBB(0.375, 0.25, 0.5, 0.625, 0.5, 1.0));
                        break;
                    }
                    case 16: {
                        main.add(new AxisAlignedBB(0.375, 0.0, 0.4375, 0.625, 1.0, 0.75));
                        break;
                    }
                    case 17: {
                        main.add(new AxisAlignedBB(0.375, 0.0, 0.5, 0.625, 1.0, 0.8125));
                    }
                }
            }
            if (bX == 6) {
                switch (bY) {
                    case 13: {
                        main.add(new AxisAlignedBB(0.6875, 0.0, 0.25, 0.9375, 1.0, 0.5625));
                        main.add(new AxisAlignedBB(0.6875, 0.0, 0.0, 0.9375, 0.25, 1.0));
                        main.add(new AxisAlignedBB(0.0, 0.0, 0.25, 1.0, 0.25, 0.5));
                        break;
                    }
                    case 14: {
                        main.add(new AxisAlignedBB(0.6875, 0.0, 0.3125, 0.9375, 1.0, 0.625));
                        break;
                    }
                    case 15: {
                        main.add(new AxisAlignedBB(0.6875, 0.0, 0.375, 0.9375, 1.0, 0.6875));
                        main.add(new AxisAlignedBB(0.6875, 0.25, 0.375, 0.9375, 0.5, 1.0));
                        main.add(new AxisAlignedBB(0.0, 0.25, 0.4375, 0.75, 0.5, 0.6875));
                        break;
                    }
                    case 16: {
                        main.add(new AxisAlignedBB(0.6875, 0.0, 0.4375, 0.9375, 1.0, 0.75));
                        break;
                    }
                    case 17: {
                        main.add(new AxisAlignedBB(0.6875, 0.0, 0.5, 0.9375, 1.0, 0.8125));
                    }
                }
            }
        }
        if (bZ == 3) {
            if (bX == 2) {
                switch (bY) {
                    case 13: {
                        main.add(new AxisAlignedBB(0.0625, 0.0, 0.4375, 0.3125, 1.0, 0.75));
                        main.add(new AxisAlignedBB(0.0625, 0.0, 0.0, 0.3125, 0.25, 1.0));
                        main.add(new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 0.25, 0.75));
                        break;
                    }
                    case 14: {
                        main.add(new AxisAlignedBB(0.0625, 0.0, 0.375, 0.3125, 1.0, 0.6875));
                        break;
                    }
                    case 15: {
                        main.add(new AxisAlignedBB(0.0625, 0.0, 0.3125, 0.3125, 1.0, 0.625));
                        main.add(new AxisAlignedBB(0.0625, 0.25, 0.0, 0.3125, 0.5, 0.5));
                        main.add(new AxisAlignedBB(0.0625, 0.25, 0.3125, 1.0, 0.5, 0.5625));
                        break;
                    }
                    case 16: {
                        main.add(new AxisAlignedBB(0.0625, 0.0, 0.25, 0.3125, 1.0, 0.5625));
                        break;
                    }
                    case 17: {
                        main.add(new AxisAlignedBB(0.0625, 0.0, 0.1875, 0.3125, 1.0, 0.5));
                    }
                }
            }
            if (bX == 4) {
                switch (bY) {
                    case 13: {
                        main.add(new AxisAlignedBB(0.375, 0.0, 0.4375, 0.625, 1.0, 0.75));
                        main.add(new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 0.25, 1.0));
                        main.add(new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 0.25, 0.75));
                        break;
                    }
                    case 14: {
                        main.add(new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.6875));
                        break;
                    }
                    case 15: {
                        main.add(new AxisAlignedBB(0.375, 0.0, 0.3125, 0.625, 1.0, 0.625));
                        main.add(new AxisAlignedBB(0.0, 0.25, 0.3125, 1.0, 0.5, 0.5625));
                        main.add(new AxisAlignedBB(0.375, 0.25, 0.0, 0.625, 0.5, 0.5));
                        break;
                    }
                    case 16: {
                        main.add(new AxisAlignedBB(0.375, 0.0, 0.25, 0.625, 1.0, 0.5625));
                        break;
                    }
                    case 17: {
                        main.add(new AxisAlignedBB(0.375, 0.0, 0.1875, 0.625, 1.0, 0.5));
                    }
                }
            }
            if (bX == 6) {
                switch (bY) {
                    case 13: {
                        main.add(new AxisAlignedBB(0.6875, 0.0, 0.4375, 0.9375, 1.0, 0.75));
                        main.add(new AxisAlignedBB(0.6875, 0.0, 0.0, 0.9375, 0.25, 1.0));
                        main.add(new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 0.25, 0.75));
                        break;
                    }
                    case 14: {
                        main.add(new AxisAlignedBB(0.6875, 0.0, 0.375, 0.9375, 1.0, 0.6875));
                        break;
                    }
                    case 15: {
                        main.add(new AxisAlignedBB(0.6875, 0.0, 0.3125, 0.9375, 1.0, 0.625));
                        main.add(new AxisAlignedBB(0.6875, 0.25, 0.0, 0.9375, 0.5, 0.5));
                        main.add(new AxisAlignedBB(0.0, 0.25, 0.3125, 0.75, 0.5, 0.5625));
                        break;
                    }
                    case 16: {
                        main.add(new AxisAlignedBB(0.6875, 0.0, 0.25, 0.9375, 1.0, 0.5625));
                        break;
                    }
                    case 17: {
                        main.add(new AxisAlignedBB(0.6875, 0.0, 0.1875, 0.9375, 1.0, 0.5));
                    }
                }
            }
        }
        if (main.isEmpty()) {
            main.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
        }
        return main;
    }

    public static class CokingChamber {
        @Nullable
        CokerUnitRecipe recipe = null;
        CokingState state = CokingState.STANDBY;
        FluidTank tank;
        int capacity;
        int inputAmount = 0;
        int outputAmount = 0;
        int timer = 0;

        public CokingChamber(int itemCapacity, int fluidCapacity) {
            this.capacity = itemCapacity;
            this.tank = new FluidTank(fluidCapacity);
        }

        public CokingChamber readFromNBT(CompoundNBT nbt) {
            this.tank.readFromNBT(nbt.func_74775_l("tank"));
            this.timer = nbt.func_74762_e("timer");
            this.inputAmount = nbt.func_74762_e("input");
            this.outputAmount = nbt.func_74762_e("output");
            this.state = CokingState.values()[nbt.func_74762_e("state")];
            if (nbt.func_150297_b("recipe", 8)) {
                try {
                    this.recipe = CokerUnitRecipe.recipes.get(new ResourceLocation(nbt.func_74779_i("recipe")));
                }
                catch (ResourceLocationException e) {
                    ImmersivePetroleum.log.error("Tried to load a coking recipe with an invalid name", (Throwable)e);
                }
            } else {
                this.recipe = null;
            }
            return this;
        }

        public CompoundNBT writeToNBT(CompoundNBT nbt) {
            nbt.func_218657_a("tank", (INBT)this.tank.writeToNBT(new CompoundNBT()));
            nbt.func_74768_a("timer", this.timer);
            nbt.func_74768_a("input", this.inputAmount);
            nbt.func_74768_a("output", this.outputAmount);
            nbt.func_74768_a("state", this.state.id());
            if (this.recipe != null) {
                nbt.func_74778_a("recipe", this.recipe.func_199560_c().toString());
            }
            return nbt;
        }

        public boolean setRecipe(@Nullable CokerUnitRecipe recipe) {
            if (this.state == CokingState.STANDBY) {
                this.recipe = recipe;
                return true;
            }
            return false;
        }

        public int addStack(@Nonnull ItemStack stack, boolean simulate) {
            if (this.recipe != null && !stack.func_190926_b() && this.recipe.inputItem.test(stack)) {
                int capacity = this.getCapacity() * this.recipe.inputItem.getCount();
                int current = this.getTotalAmount() * this.recipe.inputItem.getCount();
                if (simulate) {
                    return Math.min(capacity - current, stack.func_190916_E());
                }
                int filled = capacity - current;
                if (stack.func_190916_E() < filled) {
                    filled = stack.func_190916_E();
                }
                ++this.inputAmount;
                return filled;
            }
            return 0;
        }

        public CokingState getState() {
            return this.state;
        }

        public int getCapacity() {
            return this.capacity;
        }

        public int getInputAmount() {
            return this.inputAmount;
        }

        public int getOutputAmount() {
            return this.outputAmount;
        }

        public int getTotalAmount() {
            return this.inputAmount + this.outputAmount;
        }

        public int getTimer() {
            return this.timer;
        }

        @Nullable
        public CokerUnitRecipe getRecipe() {
            return this.recipe;
        }

        public ItemStack getInputItem() {
            if (this.recipe == null) {
                return ItemStack.field_190927_a;
            }
            return this.recipe.inputItem.getMatchingStacks()[0];
        }

        public ItemStack getOutputItem() {
            if (this.recipe == null) {
                return ItemStack.field_190927_a;
            }
            return this.recipe.outputItem;
        }

        public FluidTank getTank() {
            return this.tank;
        }

        public boolean tick(CokerUnitTileEntity cokerunit, int chamberId) {
            switch (this.state) {
                case STANDBY: {
                    if (this.recipe == null) break;
                    this.state = CokingState.PROCESSING;
                    return true;
                }
                case PROCESSING: {
                    if (this.inputAmount <= 0 || this.getInputItem().func_190926_b() || this.tank.getCapacity() - this.tank.getFluidAmount() < this.recipe.outputFluid.getAmount() || cokerunit.energyStorage.getEnergyStored() < this.recipe.getTotalProcessEnergy()) break;
                    cokerunit.energyStorage.extractEnergy(this.recipe.getTotalProcessEnergy(), false);
                    ++this.timer;
                    if (this.timer >= this.recipe.getTotalProcessTime() * this.recipe.inputItem.getCount()) {
                        this.timer = 0;
                        this.tank.fill(Utils.copyFluidStackWithAmount((FluidStack)((FluidStack)this.recipe.outputFluid.getMatchingFluidStacks().get(0)), (int)this.recipe.outputFluid.getAmount(), (boolean)false), IFluidHandler.FluidAction.EXECUTE);
                        --this.inputAmount;
                        ++this.outputAmount;
                        if (this.inputAmount <= 0) {
                            this.state = CokingState.DRAIN_RESIDUE;
                        }
                    }
                    return true;
                }
                case DRAIN_RESIDUE: {
                    if (this.tank.getFluidAmount() > 0) {
                        FluidTank buffer = cokerunit.bufferTanks[1];
                        FluidStack drained = this.tank.drain(25, IFluidHandler.FluidAction.SIMULATE);
                        int accepted = buffer.fill(drained, IFluidHandler.FluidAction.SIMULATE);
                        if (accepted <= 0) break;
                        int amount = Math.min(drained.getAmount(), accepted);
                        this.tank.drain(amount, IFluidHandler.FluidAction.EXECUTE);
                        buffer.fill(Utils.copyFluidStackWithAmount((FluidStack)drained, (int)amount, (boolean)false), IFluidHandler.FluidAction.EXECUTE);
                        return true;
                    }
                    this.state = CokingState.FLOODING;
                    return true;
                }
                case FLOODING: {
                    ++this.timer;
                    if (this.timer < 2) break;
                    this.timer = 0;
                    int max = this.getTotalAmount() * this.recipe.inputFluid.getAmount();
                    if (this.tank.getFluidAmount() < max) {
                        FluidStack accepted = cokerunit.bufferTanks[0].drain(this.recipe.inputFluid.getAmount(), IFluidHandler.FluidAction.SIMULATE);
                        if (accepted.getAmount() < this.recipe.inputFluid.getAmount()) break;
                        cokerunit.bufferTanks[0].drain(this.recipe.inputFluid.getAmount(), IFluidHandler.FluidAction.EXECUTE);
                        this.tank.fill(accepted, IFluidHandler.FluidAction.EXECUTE);
                        break;
                    }
                    if (this.tank.getFluidAmount() < max) break;
                    this.state = CokingState.DUMPING;
                    return true;
                }
                case DUMPING: {
                    boolean update = false;
                    ++this.timer;
                    if (this.timer >= 5) {
                        this.timer = 0;
                        if (this.outputAmount > 0) {
                            World world = cokerunit.getWorldNonnull();
                            int amount = Math.min(this.outputAmount, 1);
                            ItemStack copy = this.recipe.outputItem.func_77946_l();
                            copy.func_190920_e(amount);
                            BlockPos itemOutPos = cokerunit.getBlockPosForPos(chamberId == 0 ? Chamber_A_OUT : Chamber_B_OUT);
                            Vector3d center = new Vector3d((double)itemOutPos.func_177958_n() + 0.5, (double)itemOutPos.func_177956_o() - 0.5, (double)itemOutPos.func_177952_p() + 0.5);
                            ItemEntity ent = new ItemEntity(cokerunit.getWorldNonnull(), center.field_72450_a, center.field_72448_b, center.field_72449_c, copy);
                            ent.func_213293_j(0.0, 0.0, 0.0);
                            world.func_217376_c((Entity)ent);
                            this.outputAmount -= amount;
                            update = true;
                        }
                    }
                    if (this.tank.getFluidAmount() > 0) {
                        this.tank.drain(25, IFluidHandler.FluidAction.EXECUTE);
                        update = true;
                    }
                    if (this.outputAmount <= 0 && this.tank.isEmpty()) {
                        this.recipe = null;
                        this.state = CokingState.STANDBY;
                        update = true;
                    }
                    if (!update) break;
                    return true;
                }
            }
            return false;
        }
    }

    public static enum CokingState {
        STANDBY,
        PROCESSING,
        DRAIN_RESIDUE,
        FLOODING,
        DUMPING;


        public int id() {
            return this.ordinal();
        }
    }

    public class CokingProcess
    extends PoweredMultiblockTileEntity.MultiblockProcessInMachine<CokerUnitRecipe> {
        public CokingProcess(CokerUnitRecipe recipe) {
            super((MultiblockRecipe)recipe, new int[]{Inventory.INPUT.id()});
            this.setInputTanks(new int[]{0});
        }

        public boolean canProcess(PoweredMultiblockTileEntity<?, CokerUnitRecipe> multiblock) {
            return super.canProcess(multiblock);
        }

        public void doProcessTick(PoweredMultiblockTileEntity<?, CokerUnitRecipe> multiblock) {
            super.doProcessTick(multiblock);
        }
    }

    public static enum Inventory {
        INPUT,
        INPUT_FILLED,
        INPUT_EMPTY,
        OUTPUT_EMPTY,
        OUTPUT_FILLED;


        public int id() {
            return this.ordinal();
        }
    }
}

