/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.items;

import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import flaxbeard.immersivepetroleum.api.crafting.LubricantHandler;
import flaxbeard.immersivepetroleum.api.crafting.LubricatedHandler;
import flaxbeard.immersivepetroleum.common.items.IPItemBase;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;

public class OilCanItem
extends IPItemBase {
    public OilCanItem(String name) {
        super(name, new Item.Properties().func_200917_a(1));
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        if (!stack.func_190926_b()) {
            return new FluidHandlerItemStack(stack, 8000);
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY == null) {
            return;
        }
        FluidUtil.getFluidContained((ItemStack)stack).ifPresent(fluid -> {
            if (fluid != null && fluid.getAmount() > 0) {
                FluidAttributes att = fluid.getFluid().getAttributes();
                TextFormatting rarity = att.getRarity() == Rarity.COMMON ? TextFormatting.GRAY : att.getRarity().field_77937_e;
                IFormattableTextComponent out = ((IFormattableTextComponent)fluid.getDisplayName()).func_240699_a_(rarity).func_230529_a_((ITextComponent)new StringTextComponent(": " + fluid.getAmount() + "/8000mB").func_240699_a_(TextFormatting.GRAY));
                tooltip.add((ITextComponent)out);
            } else {
                tooltip.add((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"desc.immersiveengineering.flavour.drill.empty", (Object[])new Object[0])));
            }
        });
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        TileEntity tileEntity;
        ItemStack stack = context.func_195996_i();
        PlayerEntity player = context.func_195999_j();
        Hand hand = context.func_221531_n();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        if (!world.field_72995_K && (tileEntity = world.func_175625_s(pos)) != null) {
            IFluidHandler cap = (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).orElse(null);
            if (cap != null && FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, (IFluidHandler)cap)) {
                return ActionResultType.SUCCESS;
            }
            ActionResultType ret = FluidUtil.getFluidHandler((ItemStack)stack).map(handler -> {
                FluidHandlerItemStack can;
                FluidStack fs;
                if (handler instanceof FluidHandlerItemStack && (fs = (can = (FluidHandlerItemStack)handler).getFluid()) != null && LubricantHandler.isValidLube(fs)) {
                    int amountNeeded = LubricantHandler.getLubeAmount(fs) * 5 * 20;
                    if (fs.getAmount() >= amountNeeded && LubricatedHandler.lubricateTile(world.func_175625_s(pos), fs.getFluid(), 600)) {
                        player.func_184185_a(SoundEvents.field_187624_K, 1.0f, 1.0f);
                        if (!player.func_184812_l_()) {
                            can.drain(amountNeeded, IFluidHandler.FluidAction.EXECUTE);
                        }
                        return ActionResultType.SUCCESS;
                    }
                }
                return ActionResultType.PASS;
            }).orElse(ActionResultType.PASS);
            return ret;
        }
        return ActionResultType.PASS;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        this.func_111207_a(stack, null, target, Hand.MAIN_HAND);
        return true;
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity target, Hand hand) {
        if (target instanceof IronGolemEntity) {
            IronGolemEntity golem = (IronGolemEntity)target;
            FluidUtil.getFluidHandler((ItemStack)stack).ifPresent(con -> {
                FluidHandlerItemStack handler;
                if (con instanceof FluidHandlerItemStack && (handler = (FluidHandlerItemStack)con).getFluid() != null && LubricantHandler.isValidLube(handler.getFluid().getFluid())) {
                    int amountNeeded = LubricantHandler.getLubeAmount(handler.getFluid().getFluid()) * 5 * 20;
                    if (handler.getFluid().getAmount() >= amountNeeded) {
                        player.func_184185_a(SoundEvents.field_187624_K, 1.0f, 1.0f);
                        golem.func_70606_j(Math.max(golem.func_110143_aJ() + 2.0f, golem.func_110138_aP()));
                        golem.func_195064_c(new EffectInstance(Effects.field_76424_c, 1200, 1));
                        golem.func_195064_c(new EffectInstance(Effects.field_76420_g, 1200, 1));
                        if (!player.func_184812_l_()) {
                            handler.drain(amountNeeded, IFluidHandler.FluidAction.EXECUTE);
                        }
                    }
                }
            });
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return ItemNBTHelper.hasKey((ItemStack)stack, (String)"jerrycanDrain") || FluidUtil.getFluidContained((ItemStack)stack).isPresent();
    }

    public ItemStack getContainerItem(ItemStack stack) {
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"jerrycanDrain")) {
            ItemStack ret = stack.func_77946_l();
            FluidUtil.getFluidHandler((ItemStack)ret).ifPresent(handler -> {
                handler.drain(ItemNBTHelper.getInt((ItemStack)ret, (String)"jerrycanDrain"), IFluidHandler.FluidAction.EXECUTE);
                ItemNBTHelper.remove((ItemStack)ret, (String)"jerrycanDrain");
            });
            return ret;
        }
        if (FluidUtil.getFluidContained((ItemStack)stack) != null) {
            ItemStack ret = stack.func_77946_l();
            FluidUtil.getFluidHandler((ItemStack)ret).ifPresent(handler -> handler.drain(1000, IFluidHandler.FluidAction.EXECUTE));
            return ret;
        }
        return stack;
    }
}

