/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.network;

import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.network.INetMessage;
import flaxbeard.immersivepetroleum.common.network.IPPacketHandler;
import flaxbeard.immersivepetroleum.common.util.projector.Settings;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageProjectorSync
implements INetMessage {
    boolean forServer;
    CompoundNBT nbt;
    Hand hand;

    public static void sendToServer(Settings settings, Hand hand) {
        IPPacketHandler.sendToServer(new MessageProjectorSync(settings, hand, true));
    }

    public static void sendToClient(PlayerEntity player, Settings settings, Hand hand) {
        IPPacketHandler.sendToPlayer(player, new MessageProjectorSync(settings, hand, false));
    }

    public MessageProjectorSync(Settings settings, Hand hand, boolean toServer) {
        this(settings.toNbt(), hand, toServer);
    }

    public MessageProjectorSync(CompoundNBT nbt, Hand hand, boolean toServer) {
        this.nbt = nbt;
        this.forServer = toServer;
        this.hand = hand;
    }

    public MessageProjectorSync(PacketBuffer buf) {
        this.nbt = buf.func_150793_b();
        this.forServer = buf.readBoolean();
        this.hand = Hand.values()[buf.readByte()];
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.func_150786_a(this.nbt);
        buf.writeBoolean(this.forServer);
        buf.writeByte(this.hand.ordinal());
    }

    @Override
    public void process(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayerEntity player;
            ItemStack held;
            NetworkEvent.Context con = (NetworkEvent.Context)context.get();
            if (con.getDirection().getReceptionSide() == this.getSide() && con.getSender() != null && !(held = (player = con.getSender()).func_184586_b(this.hand)).func_190926_b() && held.func_77973_b() == IPContent.Items.projector) {
                Settings settings = new Settings(this.nbt);
                settings.applyTo(held);
            }
        });
    }

    LogicalSide getSide() {
        return this.forServer ? LogicalSide.SERVER : LogicalSide.CLIENT;
    }
}

