/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.item;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.ToolItem;
import net.minecraft.util.IItemProvider;
import org.cyclops.integratedtunnels.RegistryEntries;

public class ItemDummyPickAxe
extends ToolItem {
    private static final Map<EnchantmentData, ItemStack> ITEMSTACKS = Maps.newHashMap();

    public ItemDummyPickAxe(Item.Properties properties) {
        super(1000.0f, 1000.0f, (IItemTier)ItemTier.DIAMOND, Collections.emptySet(), properties);
    }

    public boolean func_150897_b(BlockState blockIn) {
        return true;
    }

    public boolean canHarvestBlock(ItemStack stack, BlockState state) {
        return true;
    }

    public static ItemStack getItemStack(boolean silkTouch, int fortune) {
        EnchantmentData data = new EnchantmentData(silkTouch, fortune);
        return ITEMSTACKS.computeIfAbsent(data, key -> {
            ItemStack itemStack = new ItemStack((IItemProvider)RegistryEntries.ITEM_DUMMY_PICKAXE, 1);
            if (silkTouch) {
                itemStack.func_77966_a(Enchantments.field_185306_r, 1);
            }
            if (fortune > 0) {
                itemStack.func_77966_a(Enchantments.field_185308_t, fortune);
            }
            return itemStack;
        });
    }

    public static class EnchantmentData {
        private final boolean silkTouch;
        private final int fortune;

        public EnchantmentData(boolean silkTouch, int fortune) {
            this.silkTouch = silkTouch;
            this.fortune = fortune;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof EnchantmentData)) {
                return false;
            }
            EnchantmentData that = (EnchantmentData)o;
            return this.silkTouch == that.silkTouch && this.fortune == that.fortune;
        }

        public int hashCode() {
            return Objects.hash(this.silkTouch, this.fortune);
        }
    }
}

