/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.emojiful.api;

import com.hrznstudio.emojiful.Emojiful;
import com.hrznstudio.emojiful.EmojifulConfig;
import com.hrznstudio.emojiful.util.EmojiUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.Pair;

public class Emoji
implements Predicate<String> {
    public static final ResourceLocation loading_texture = new ResourceLocation("emojiful", "textures/26a0.png");
    public static final ResourceLocation noSignal_texture = new ResourceLocation("emojiful", "textures/26d4.png");
    public static final ResourceLocation error_texture = new ResourceLocation("emojiful", "textures/26d4.png");
    public static final AtomicInteger threadDownloadCounter = new AtomicInteger(0);
    public static final AtomicInteger threadFileLoaderCounter = new AtomicInteger(0);
    public String name;
    public List<String> strings = new ArrayList<String>();
    public List<String> texts = new ArrayList<String>();
    public String location;
    public int version = 1;
    public int sort = 0;
    public boolean worldBased = false;
    private String shortString;
    private String regex;
    private Pattern regexPattern;
    private String textRegex;
    public boolean deleteOldTexture;
    public List<DownloadImageData> img = new ArrayList<DownloadImageData>();
    public List<ResourceLocation> frames = new ArrayList<ResourceLocation>();
    public boolean finishedLoading = false;
    public boolean loadedTextures = false;
    private Thread imageThread;
    private Thread gifLoaderThread;

    public void checkLoad() {
        if (this.imageThread == null && !this.finishedLoading) {
            this.loadImage();
        } else if (!this.loadedTextures) {
            this.loadedTextures = true;
        }
    }

    public ResourceLocation getResourceLocationForBinding() {
        this.checkLoad();
        if (this.deleteOldTexture) {
            this.img.forEach(Texture::func_147631_c);
            this.deleteOldTexture = false;
        }
        return this.finishedLoading && this.frames.size() > 0 ? this.frames.get((int)((double)System.currentTimeMillis() / 10.0 % (double)this.frames.size())) : loading_texture;
    }

    @Override
    public boolean test(String s) {
        for (String text : this.strings) {
            if (!s.equalsIgnoreCase(text)) continue;
            return true;
        }
        return false;
    }

    public String getShorterString() {
        if (this.shortString != null) {
            return this.shortString;
        }
        this.shortString = this.strings.get(0);
        for (String string : this.strings) {
            if (string.length() >= this.shortString.length()) continue;
            this.shortString = string;
        }
        return this.shortString;
    }

    public Pattern getRegex() {
        if (this.regexPattern != null) {
            return this.regexPattern;
        }
        this.regexPattern = Pattern.compile(this.getRegexString());
        return this.regexPattern;
    }

    public String getRegexString() {
        if (this.regex != null) {
            return this.regex;
        }
        ArrayList<String> processed = new ArrayList<String>();
        for (String string : this.strings) {
            char first;
            char last = string.toLowerCase().charAt(string.length() - 1);
            String s = string;
            if (last >= 'a' && last <= 'z') {
                s = string + "\\b";
            }
            if ((first = string.toLowerCase().charAt(0)) >= 'a' && first <= 'z') {
                s = "\\b" + s;
            }
            processed.add(EmojiUtil.cleanStringForRegex(s));
        }
        this.regex = String.join((CharSequence)"|", processed);
        return this.regex;
    }

    public String getTextRegex() {
        if (this.textRegex != null) {
            return this.textRegex;
        }
        ArrayList<String> processed = new ArrayList<String>();
        for (String string : this.texts) {
            char first;
            char last = string.toLowerCase().charAt(string.length() - 1);
            String s = string;
            if (last >= 'a' && last <= 'z') {
                s = string + "\\b";
            }
            if ((first = string.toLowerCase().charAt(0)) >= 'a' && first <= 'z') {
                s = "\\b" + s;
            }
            processed.add(EmojiUtil.cleanStringForRegex(s));
        }
        this.textRegex = String.join((CharSequence)"|", processed);
        return this.textRegex;
    }

    private void loadImage() {
        final File cache = this.getCache();
        if (cache.exists()) {
            if (this.getUrl().endsWith(".gif") && ((Boolean)EmojifulConfig.getInstance().loadGifEmojis.get()).booleanValue()) {
                if (this.gifLoaderThread == null) {
                    this.gifLoaderThread = new Thread("Emojiful Texture Downloader #" + threadDownloadCounter.incrementAndGet()){

                        @Override
                        public void run() {
                            try {
                                Emoji.this.loadTextureFrames(EmojiUtil.splitGif(cache));
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    };
                    this.gifLoaderThread.setDaemon(true);
                    this.gifLoaderThread.start();
                }
            } else {
                try {
                    DownloadImageData imageData = new DownloadImageData(ImageIO.read(cache), loading_texture);
                    ResourceLocation resourceLocation = new ResourceLocation("emojiful", "texures/emoji/" + this.name.toLowerCase().replaceAll("[^a-z0-9/._-]", "") + "_" + this.version);
                    Minecraft.func_71410_x().func_110434_K().func_229263_a_(resourceLocation, (Texture)imageData);
                    this.img.add(imageData);
                    this.frames.add(resourceLocation);
                    this.finishedLoading = true;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else if (this.imageThread == null) {
            this.loadTextureFromServer();
        }
    }

    public String getUrl() {
        return "https://raw.githubusercontent.com/InnovativeOnlineIndustries/emojiful-assets/master/" + this.location;
    }

    public File getCache() {
        return new File("emojiful/cache/" + this.name + "-" + this.version);
    }

    public void loadTextureFrames(List<Pair<BufferedImage, Integer>> framesPair) {
        Minecraft.func_71410_x().func_213167_f(() -> {
            int i = 0;
            for (Pair bufferedImage : framesPair) {
                DownloadImageData imageData = new DownloadImageData((BufferedImage)bufferedImage.getKey(), loading_texture);
                ResourceLocation resourceLocation = new ResourceLocation("emojiful", "texures/emoji/" + this.name.toLowerCase().replaceAll("[^a-z0-9/._-]", "") + "_" + this.version + "_frame" + i);
                Minecraft.func_71410_x().func_110434_K().func_229263_a_(resourceLocation, (Texture)imageData);
                this.img.add(imageData);
                Integer integer = 0;
                while (integer < (Integer)bufferedImage.getValue()) {
                    this.frames.add(resourceLocation);
                    Integer n = integer;
                    Integer n2 = integer = Integer.valueOf(integer + 1);
                }
                ++i;
            }
            this.finishedLoading = true;
        });
    }

    protected void loadTextureFromServer() {
        this.imageThread = new Thread("Emojiful Texture Downloader #" + threadDownloadCounter.incrementAndGet()){

            @Override
            public void run() {
                HttpURLConnection httpurlconnection = null;
                try {
                    httpurlconnection = (HttpURLConnection)new URL(Emoji.this.getUrl()).openConnection(Minecraft.func_71410_x().func_110437_J());
                    httpurlconnection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
                    httpurlconnection.setDoInput(true);
                    httpurlconnection.setDoOutput(false);
                    httpurlconnection.connect();
                    if (httpurlconnection.getResponseCode() / 100 == 2) {
                        if (Emoji.this.getCache() != null) {
                            FileUtils.copyInputStreamToFile((InputStream)httpurlconnection.getInputStream(), (File)Emoji.this.getCache());
                        }
                        Emoji.this.finishedLoading = true;
                        Emoji.this.loadImage();
                    } else {
                        Emoji.this.frames = new ArrayList<ResourceLocation>();
                        Emoji.this.frames.add(noSignal_texture);
                        Emoji.this.deleteOldTexture = true;
                        Emoji.this.finishedLoading = true;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Emoji.this.frames = new ArrayList<ResourceLocation>();
                    Emoji.this.frames.add(error_texture);
                    Emoji.this.deleteOldTexture = true;
                    Emoji.this.finishedLoading = true;
                }
                finally {
                    if (httpurlconnection != null) {
                        httpurlconnection.disconnect();
                    }
                }
            }
        };
        this.imageThread.setDaemon(true);
        this.imageThread.start();
    }

    public class DownloadImageData
    extends SimpleTexture {
        private final BufferedImage cacheFile;
        private NativeImage nativeImage;
        public boolean textureUploaded;

        public DownloadImageData(BufferedImage cacheFileIn, ResourceLocation textureResourceLocation) {
            super(textureResourceLocation);
            this.cacheFile = cacheFileIn;
        }

        private void checkTextureUploaded() {
            if (!this.textureUploaded && this.nativeImage != null) {
                if (this.field_110568_b != null) {
                    this.func_147631_c();
                }
                TextureUtil.func_225680_a_((int)super.func_110552_b(), (int)this.nativeImage.func_195702_a(), (int)this.nativeImage.func_195714_b());
                this.nativeImage.func_195697_a(0, 0, 0, true);
                this.textureUploaded = true;
            }
        }

        private void setImage(NativeImage nativeImageIn) {
            Minecraft.func_71410_x().execute(() -> {
                this.textureUploaded = true;
                if (!RenderSystem.isOnRenderThread()) {
                    RenderSystem.recordRenderCall(() -> this.upload(nativeImageIn));
                } else {
                    this.upload(nativeImageIn);
                }
            });
        }

        private void upload(NativeImage imageIn) {
            TextureUtil.func_225680_a_((int)this.func_110552_b(), (int)imageIn.func_195702_a(), (int)imageIn.func_195714_b());
            imageIn.func_195697_a(0, 0, 0, true);
        }

        @Nullable
        private NativeImage loadTexture(InputStream inputStreamIn) {
            NativeImage nativeimage = null;
            try {
                nativeimage = NativeImage.func_195713_a((InputStream)inputStreamIn);
            }
            catch (IOException ioexception) {
                Emojiful.LOGGER.warn("Error while loading the skin texture", (Throwable)ioexception);
            }
            return nativeimage;
        }

        public void func_195413_a(IResourceManager resourceManager) throws IOException {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)this.cacheFile, "png", os);
            ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
            this.setImage(this.loadTexture(is));
        }
    }
}

