/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.client.gui;

import cofh.core.client.gui.CoreTextures;
import cofh.core.client.gui.element.ElementConditionalLayered;
import cofh.core.client.gui.element.ElementScaled;
import cofh.core.client.gui.element.ElementScaledFluid;
import cofh.core.client.gui.element.panel.ResourcePanel;
import cofh.core.util.helpers.GuiHelper;
import cofh.core.util.helpers.RenderHelper;
import cofh.lib.client.gui.IGuiAccess;
import cofh.lib.util.constants.Constants;
import cofh.lib.util.control.IReconfigurable;
import cofh.lib.util.helpers.BlockHelper;
import cofh.thermal.core.client.ThermalTextures;
import cofh.thermal.lib.tileentity.CellTileBase;
import cofh.thermal.lib.tileentity.ReconfigurableTile4Way;
import cofh.thermal.lib.tileentity.ThermalTileAugmentable;
import net.minecraft.util.Direction;
import net.minecraftforge.fluids.FluidStack;

public class ThermalGuiHelper {
    private ThermalGuiHelper() {
    }

    public static ElementConditionalLayered createDefaultMachineConfigTop(IGuiAccess gui, String machine, ReconfigurableTile4Way tile) {
        String specificTexture = "thermal:block/machines/machine_" + machine + "_top";
        return (ElementConditionalLayered)new ElementConditionalLayered(gui).addSprite(RenderHelper.textureExists((String)specificTexture) ? specificTexture : "thermal:block/machines/machine_top", Constants.TRUE).addSprite(ThermalTextures.MACHINE_CONFIG_INPUT, () -> tile.reconfigControl().getSideConfig(Direction.UP) == IReconfigurable.SideConfig.SIDE_INPUT).addSprite(ThermalTextures.MACHINE_CONFIG_OUTPUT, () -> tile.reconfigControl().getSideConfig(Direction.UP) == IReconfigurable.SideConfig.SIDE_OUTPUT).addSprite(ThermalTextures.MACHINE_CONFIG_BOTH, () -> tile.reconfigControl().getSideConfig(Direction.UP) == IReconfigurable.SideConfig.SIDE_BOTH).addSprite(ThermalTextures.MACHINE_CONFIG_ACCESSIBLE, () -> tile.reconfigControl().getSideConfig(Direction.UP) == IReconfigurable.SideConfig.SIDE_ACCESSIBLE).setSize(16, 16);
    }

    public static ElementConditionalLayered createDefaultMachineConfigBottom(IGuiAccess gui, String machine, ReconfigurableTile4Way tile) {
        String specificTexture = "thermal:block/machines/machine_" + machine + "_bottom";
        return (ElementConditionalLayered)new ElementConditionalLayered(gui).addSprite(RenderHelper.textureExists((String)specificTexture) ? specificTexture : "thermal:block/machines/machine_bottom", Constants.TRUE).addSprite(ThermalTextures.MACHINE_CONFIG_INPUT, () -> tile.reconfigControl().getSideConfig(Direction.DOWN) == IReconfigurable.SideConfig.SIDE_INPUT).addSprite(ThermalTextures.MACHINE_CONFIG_OUTPUT, () -> tile.reconfigControl().getSideConfig(Direction.DOWN) == IReconfigurable.SideConfig.SIDE_OUTPUT).addSprite(ThermalTextures.MACHINE_CONFIG_BOTH, () -> tile.reconfigControl().getSideConfig(Direction.DOWN) == IReconfigurable.SideConfig.SIDE_BOTH).addSprite(ThermalTextures.MACHINE_CONFIG_ACCESSIBLE, () -> tile.reconfigControl().getSideConfig(Direction.DOWN) == IReconfigurable.SideConfig.SIDE_ACCESSIBLE).setSize(16, 16);
    }

    public static ElementConditionalLayered createDefaultMachineConfigLeft(IGuiAccess gui, String machine, ReconfigurableTile4Way tile) {
        String specificTexture = "thermal:block/machines/machine_" + machine + "_side";
        return (ElementConditionalLayered)new ElementConditionalLayered(gui).addSprite(RenderHelper.textureExists((String)specificTexture) ? specificTexture : "thermal:block/machines/machine_side", Constants.TRUE).addSprite(ThermalTextures.MACHINE_CONFIG_INPUT, () -> tile.reconfigControl().getSideConfig(BlockHelper.left((Direction)tile.getFacing())) == IReconfigurable.SideConfig.SIDE_INPUT).addSprite(ThermalTextures.MACHINE_CONFIG_OUTPUT, () -> tile.reconfigControl().getSideConfig(BlockHelper.left((Direction)tile.getFacing())) == IReconfigurable.SideConfig.SIDE_OUTPUT).addSprite(ThermalTextures.MACHINE_CONFIG_BOTH, () -> tile.reconfigControl().getSideConfig(BlockHelper.left((Direction)tile.getFacing())) == IReconfigurable.SideConfig.SIDE_BOTH).addSprite(ThermalTextures.MACHINE_CONFIG_ACCESSIBLE, () -> tile.reconfigControl().getSideConfig(BlockHelper.left((Direction)tile.getFacing())) == IReconfigurable.SideConfig.SIDE_ACCESSIBLE).setSize(16, 16);
    }

    public static ElementConditionalLayered createDefaultMachineConfigRight(IGuiAccess gui, String machine, ReconfigurableTile4Way tile) {
        String specificTexture = "thermal:block/machines/machine_" + machine + "_side";
        return (ElementConditionalLayered)new ElementConditionalLayered(gui).addSprite(RenderHelper.textureExists((String)specificTexture) ? specificTexture : "thermal:block/machines/machine_side", Constants.TRUE).addSprite(ThermalTextures.MACHINE_CONFIG_INPUT, () -> tile.reconfigControl().getSideConfig(BlockHelper.right((Direction)tile.getFacing())) == IReconfigurable.SideConfig.SIDE_INPUT).addSprite(ThermalTextures.MACHINE_CONFIG_OUTPUT, () -> tile.reconfigControl().getSideConfig(BlockHelper.right((Direction)tile.getFacing())) == IReconfigurable.SideConfig.SIDE_OUTPUT).addSprite(ThermalTextures.MACHINE_CONFIG_BOTH, () -> tile.reconfigControl().getSideConfig(BlockHelper.right((Direction)tile.getFacing())) == IReconfigurable.SideConfig.SIDE_BOTH).addSprite(ThermalTextures.MACHINE_CONFIG_ACCESSIBLE, () -> tile.reconfigControl().getSideConfig(BlockHelper.right((Direction)tile.getFacing())) == IReconfigurable.SideConfig.SIDE_ACCESSIBLE).setSize(16, 16);
    }

    public static ElementConditionalLayered createDefaultMachineConfigFace(IGuiAccess gui, String machine, ReconfigurableTile4Way tile) {
        String texture = "thermal:block/machines/machine_" + machine;
        String activeTexture = "thermal:block/machines/machine_" + machine + "_active";
        return (ElementConditionalLayered)new ElementConditionalLayered(gui).addSprite(() -> RenderHelper.getFluidTexture((FluidStack)tile.getRenderFluid()), () -> RenderHelper.getFluidColor((FluidStack)tile.getRenderFluid()), () -> !tile.getRenderFluid().isEmpty()).addSprite(RenderHelper.textureExists((String)texture) ? texture : "thermal:block/machines/machine_side", () -> !tile.isActive).addSprite(RenderHelper.textureExists((String)activeTexture) ? activeTexture : "thermal:block/machines/machine_side", () -> tile.isActive).setSize(16, 16);
    }

    public static ElementConditionalLayered createDefaultMachineConfigBack(IGuiAccess gui, String machine, ReconfigurableTile4Way tile) {
        String specificTexture = "thermal:block/machines/machine_" + machine + "_side";
        return (ElementConditionalLayered)new ElementConditionalLayered(gui).addSprite(RenderHelper.textureExists((String)specificTexture) ? specificTexture : "thermal:block/machines/machine_side", Constants.TRUE).addSprite(ThermalTextures.MACHINE_CONFIG_INPUT, () -> tile.reconfigControl().getSideConfig(BlockHelper.opposite((Direction)tile.getFacing())) == IReconfigurable.SideConfig.SIDE_INPUT).addSprite(ThermalTextures.MACHINE_CONFIG_OUTPUT, () -> tile.reconfigControl().getSideConfig(BlockHelper.opposite((Direction)tile.getFacing())) == IReconfigurable.SideConfig.SIDE_OUTPUT).addSprite(ThermalTextures.MACHINE_CONFIG_BOTH, () -> tile.reconfigControl().getSideConfig(BlockHelper.opposite((Direction)tile.getFacing())) == IReconfigurable.SideConfig.SIDE_BOTH).addSprite(ThermalTextures.MACHINE_CONFIG_ACCESSIBLE, () -> tile.reconfigControl().getSideConfig(BlockHelper.opposite((Direction)tile.getFacing())) == IReconfigurable.SideConfig.SIDE_ACCESSIBLE).setSize(16, 16);
    }

    public static ElementConditionalLayered[] createDefaultMachineConfigs(IGuiAccess gui, String machine, ReconfigurableTile4Way tile) {
        return new ElementConditionalLayered[]{ThermalGuiHelper.createDefaultMachineConfigTop(gui, machine, tile), ThermalGuiHelper.createDefaultMachineConfigLeft(gui, machine, tile), ThermalGuiHelper.createDefaultMachineConfigFace(gui, machine, tile), ThermalGuiHelper.createDefaultMachineConfigRight(gui, machine, tile), ThermalGuiHelper.createDefaultMachineConfigBottom(gui, machine, tile), ThermalGuiHelper.createDefaultMachineConfigBack(gui, machine, tile)};
    }

    public static ElementConditionalLayered createDefaultCellConfigTop(IGuiAccess gui, String cell, CellTileBase tile) {
        String specificTexture = "thermal:block/cells/" + cell + "_top";
        String centerTexture = "thermal:block/cells/" + cell + "_center";
        return (ElementConditionalLayered)new ElementConditionalLayered(gui).addSprite(() -> RenderHelper.getFluidTexture((FluidStack)tile.getRenderFluid()), () -> RenderHelper.getFluidColor((FluidStack)tile.getRenderFluid()), () -> !tile.getRenderFluid().isEmpty()).addSprite(RenderHelper.textureExists((String)centerTexture) ? centerTexture : null, Constants.TRUE).addSprite(RenderHelper.textureExists((String)specificTexture) ? specificTexture : "thermal:block/cells/cell_top", Constants.TRUE).addSprite(ThermalTextures.CELL_CONFIG_INPUT, () -> tile.reconfigControl().getSideConfig(Direction.UP) == IReconfigurable.SideConfig.SIDE_INPUT).addSprite(ThermalTextures.CELL_CONFIG_OUTPUT, () -> tile.reconfigControl().getSideConfig(Direction.UP) == IReconfigurable.SideConfig.SIDE_OUTPUT).addSprite(ThermalTextures.CELL_CONFIG_BOTH, () -> tile.reconfigControl().getSideConfig(Direction.UP) == IReconfigurable.SideConfig.SIDE_BOTH).setSize(16, 16);
    }

    public static ElementConditionalLayered createDefaultCellConfigBottom(IGuiAccess gui, String cell, CellTileBase tile) {
        String specificTexture = "thermal:block/cells/" + cell + "_bottom";
        String centerTexture = "thermal:block/cells/" + cell + "_center";
        return (ElementConditionalLayered)new ElementConditionalLayered(gui).addSprite(() -> RenderHelper.getFluidTexture((FluidStack)tile.getRenderFluid()), () -> RenderHelper.getFluidColor((FluidStack)tile.getRenderFluid()), () -> !tile.getRenderFluid().isEmpty()).addSprite(RenderHelper.textureExists((String)centerTexture) ? centerTexture : null, Constants.TRUE).addSprite(RenderHelper.textureExists((String)specificTexture) ? specificTexture : "thermal:block/cells/cell_bottom", Constants.TRUE).addSprite(ThermalTextures.CELL_CONFIG_INPUT, () -> tile.reconfigControl().getSideConfig(Direction.DOWN) == IReconfigurable.SideConfig.SIDE_INPUT).addSprite(ThermalTextures.CELL_CONFIG_OUTPUT, () -> tile.reconfigControl().getSideConfig(Direction.DOWN) == IReconfigurable.SideConfig.SIDE_OUTPUT).addSprite(ThermalTextures.CELL_CONFIG_BOTH, () -> tile.reconfigControl().getSideConfig(Direction.DOWN) == IReconfigurable.SideConfig.SIDE_BOTH).setSize(16, 16);
    }

    public static ElementConditionalLayered createDefaultCellConfigLeft(IGuiAccess gui, String cell, CellTileBase tile) {
        String specificTexture = "thermal:block/cells/" + cell + "_side";
        String centerTexture = "thermal:block/cells/" + cell + "_center";
        return (ElementConditionalLayered)new ElementConditionalLayered(gui).addSprite(() -> RenderHelper.getFluidTexture((FluidStack)tile.getRenderFluid()), () -> RenderHelper.getFluidColor((FluidStack)tile.getRenderFluid()), () -> !tile.getRenderFluid().isEmpty()).addSprite(RenderHelper.textureExists((String)centerTexture) ? centerTexture : null, Constants.TRUE).addSprite(RenderHelper.textureExists((String)specificTexture) ? specificTexture : "thermal:block/cells/cell_side", Constants.TRUE).addSprite(ThermalTextures.CELL_CONFIG_INPUT, () -> tile.reconfigControl().getSideConfig(BlockHelper.left((Direction)tile.getFacing())) == IReconfigurable.SideConfig.SIDE_INPUT).addSprite(ThermalTextures.CELL_CONFIG_OUTPUT, () -> tile.reconfigControl().getSideConfig(BlockHelper.left((Direction)tile.getFacing())) == IReconfigurable.SideConfig.SIDE_OUTPUT).addSprite(ThermalTextures.CELL_CONFIG_BOTH, () -> tile.reconfigControl().getSideConfig(BlockHelper.left((Direction)tile.getFacing())) == IReconfigurable.SideConfig.SIDE_BOTH).setSize(16, 16);
    }

    public static ElementConditionalLayered createDefaultCellConfigRight(IGuiAccess gui, String cell, CellTileBase tile) {
        String specificTexture = "thermal:block/cells/" + cell + "_side";
        String centerTexture = "thermal:block/cells/" + cell + "_center";
        return (ElementConditionalLayered)new ElementConditionalLayered(gui).addSprite(() -> RenderHelper.getFluidTexture((FluidStack)tile.getRenderFluid()), () -> RenderHelper.getFluidColor((FluidStack)tile.getRenderFluid()), () -> !tile.getRenderFluid().isEmpty()).addSprite(RenderHelper.textureExists((String)centerTexture) ? centerTexture : null, Constants.TRUE).addSprite(RenderHelper.textureExists((String)specificTexture) ? specificTexture : "thermal:block/cells/cell_side", Constants.TRUE).addSprite(ThermalTextures.CELL_CONFIG_INPUT, () -> tile.reconfigControl().getSideConfig(BlockHelper.right((Direction)tile.getFacing())) == IReconfigurable.SideConfig.SIDE_INPUT).addSprite(ThermalTextures.CELL_CONFIG_OUTPUT, () -> tile.reconfigControl().getSideConfig(BlockHelper.right((Direction)tile.getFacing())) == IReconfigurable.SideConfig.SIDE_OUTPUT).addSprite(ThermalTextures.CELL_CONFIG_BOTH, () -> tile.reconfigControl().getSideConfig(BlockHelper.right((Direction)tile.getFacing())) == IReconfigurable.SideConfig.SIDE_BOTH).setSize(16, 16);
    }

    public static ElementConditionalLayered createDefaultCellConfigFace(IGuiAccess gui, String cell, CellTileBase tile) {
        String specificTexture = "thermal:block/cells/" + cell + "_side";
        String centerTexture = "thermal:block/cells/" + cell + "_center";
        String levelTexture = "thermal:block/cells/" + cell + "_level_";
        ElementConditionalLayered ret = (ElementConditionalLayered)new ElementConditionalLayered(gui).addSprite(() -> RenderHelper.getFluidTexture((FluidStack)tile.getRenderFluid()), () -> RenderHelper.getFluidColor((FluidStack)tile.getRenderFluid()), () -> !tile.getRenderFluid().isEmpty()).addSprite(RenderHelper.textureExists((String)centerTexture) ? centerTexture : null, Constants.TRUE).addSprite(RenderHelper.textureExists((String)specificTexture) ? specificTexture : "thermal:block/cells/cell_side", Constants.TRUE).addSprite(ThermalTextures.CELL_CONFIG_INPUT, () -> tile.reconfigControl().getSideConfig(tile.getFacing()) == IReconfigurable.SideConfig.SIDE_INPUT).addSprite(ThermalTextures.CELL_CONFIG_OUTPUT, () -> tile.reconfigControl().getSideConfig(tile.getFacing()) == IReconfigurable.SideConfig.SIDE_OUTPUT).addSprite(ThermalTextures.CELL_CONFIG_BOTH, () -> tile.reconfigControl().getSideConfig(tile.getFacing()) == IReconfigurable.SideConfig.SIDE_BOTH).setSize(16, 16);
        for (int i = 0; i < 9; ++i) {
            int level = i;
            String levelTex = levelTexture + level;
            ret.addSprite(RenderHelper.textureExists((String)levelTex) ? levelTex : null, () -> tile.getLevelTracker() == level);
        }
        String creativeTex = levelTexture + "8c";
        ret.addSprite(RenderHelper.textureExists((String)creativeTex) ? creativeTex : null, () -> tile.getLevelTracker() == 9);
        creativeTex = levelTexture + "0c";
        ret.addSprite(RenderHelper.textureExists((String)creativeTex) ? creativeTex : null, () -> tile.getLevelTracker() >= 10);
        return ret;
    }

    public static ElementConditionalLayered createDefaultCellConfigBack(IGuiAccess gui, String cell, CellTileBase tile) {
        String specificTexture = "thermal:block/cells/" + cell + "_side";
        String centerTexture = "thermal:block/cells/" + cell + "_center";
        return (ElementConditionalLayered)new ElementConditionalLayered(gui).addSprite(() -> RenderHelper.getFluidTexture((FluidStack)tile.getRenderFluid()), () -> RenderHelper.getFluidColor((FluidStack)tile.getRenderFluid()), () -> !tile.getRenderFluid().isEmpty()).addSprite(RenderHelper.textureExists((String)centerTexture) ? centerTexture : null, Constants.TRUE).addSprite(RenderHelper.textureExists((String)specificTexture) ? specificTexture : "thermal:block/cells/cell_side", Constants.TRUE).addSprite(ThermalTextures.CELL_CONFIG_INPUT, () -> tile.reconfigControl().getSideConfig(BlockHelper.opposite((Direction)tile.getFacing())) == IReconfigurable.SideConfig.SIDE_INPUT).addSprite(ThermalTextures.CELL_CONFIG_OUTPUT, () -> tile.reconfigControl().getSideConfig(BlockHelper.opposite((Direction)tile.getFacing())) == IReconfigurable.SideConfig.SIDE_OUTPUT).addSprite(ThermalTextures.CELL_CONFIG_BOTH, () -> tile.reconfigControl().getSideConfig(BlockHelper.opposite((Direction)tile.getFacing())) == IReconfigurable.SideConfig.SIDE_BOTH).setSize(16, 16);
    }

    public static ElementConditionalLayered[] createDefaultCellConfigs(IGuiAccess gui, String cell, CellTileBase tile) {
        return new ElementConditionalLayered[]{ThermalGuiHelper.createDefaultCellConfigTop(gui, cell, tile), ThermalGuiHelper.createDefaultCellConfigLeft(gui, cell, tile), ThermalGuiHelper.createDefaultCellConfigFace(gui, cell, tile), ThermalGuiHelper.createDefaultCellConfigRight(gui, cell, tile), ThermalGuiHelper.createDefaultCellConfigBottom(gui, cell, tile), ThermalGuiHelper.createDefaultCellConfigBack(gui, cell, tile)};
    }

    public static ElementScaled createDefaultProgress(IGuiAccess gui, int posX, int posY, String texture, ThermalTileAugmentable tile) {
        return GuiHelper.createDefaultProgress((IGuiAccess)gui, (int)posX, (int)posY, (String)texture, tile::getScaledProgress, () -> tile.getRenderFluid().isEmpty());
    }

    public static ElementScaledFluid createDefaultFluidProgress(IGuiAccess gui, int posX, int posY, String texture, ThermalTileAugmentable tile) {
        return GuiHelper.createDefaultFluidProgress((IGuiAccess)gui, (int)posX, (int)posY, (String)texture, tile::getScaledProgress, tile::getRenderFluid, () -> !tile.getRenderFluid().isEmpty());
    }

    public static ElementScaled createDefaultSpeed(IGuiAccess gui, int posX, int posY, String texture, ThermalTileAugmentable tile) {
        return GuiHelper.createDefaultSpeed((IGuiAccess)gui, (int)posX, (int)posY, (String)texture, tile::getScaledSpeed);
    }

    public static ElementScaled createDefaultDuration(IGuiAccess gui, int posX, int posY, String texture, ThermalTileAugmentable tile) {
        return GuiHelper.createDefaultDuration((IGuiAccess)gui, (int)posX, (int)posY, (String)texture, tile::getScaledDuration);
    }

    public static ResourcePanel createDefaultEnergyUserPanel(IGuiAccess gui, ThermalTileAugmentable tile) {
        return new ResourcePanel(gui).setResource(CoreTextures.ICON_ENERGY, "info.cofh.energy", false).setCurrent(tile::getCurSpeed, "info.cofh.energy_use", "RF/t").setMax(tile::getMaxSpeed, "info.cofh.energy_max_use", "RF/t").setEfficiency(tile::getEfficiency);
    }

    public static ResourcePanel createDefaultEnergyProducerPanel(IGuiAccess gui, ThermalTileAugmentable tile) {
        return new ResourcePanel(gui).setResource(CoreTextures.ICON_ENERGY, "info.cofh.energy", true).setCurrent(tile::getCurSpeed, "info.cofh.energy_prod", "RF/t").setMax(tile::getMaxSpeed, "info.cofh.energy_max_prod", "RF/t").setEfficiency(tile::getEfficiency);
    }
}

