/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.client.renderer.entity.model;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BlitzModel<T extends LivingEntity>
extends SegmentedModel<T> {
    private final ModelRenderer head;
    private final ModelRenderer[] body;
    private final ModelRenderer cyclone;
    private final ImmutableList<ModelRenderer> partsList;

    public BlitzModel() {
        this.field_78090_t = 128;
        this.field_78089_u = 64;
        this.head = new ModelRenderer((Model)this);
        this.head.func_78793_a(0.0f, 0.0f, 0.0f);
        this.head.func_78784_a(0, 39).func_228303_a_(-6.0f, -7.0f, -4.0f, 12.0f, 8.0f, 8.0f, 0.0f, false);
        this.body = new ModelRenderer[3];
        this.body[0] = new ModelRenderer((Model)this);
        this.body[0].func_78793_a(0.0f, 0.0f, 0.0f);
        this.body[0].func_78784_a(0, 0).func_228303_a_(-8.0f, 2.0f, -8.0f, 16.0f, 6.0f, 16.0f, 0.0f, false);
        this.body[1] = new ModelRenderer((Model)this);
        this.body[1].func_78793_a(0.0f, 0.0f, 0.0f);
        this.body[1].func_78784_a(0, 23).func_228303_a_(-5.0f, 9.0f, -5.0f, 10.0f, 6.0f, 10.0f, 0.0f, false);
        this.body[2] = new ModelRenderer((Model)this);
        this.body[2].func_78793_a(0.0f, 0.0f, 0.0f);
        this.body[2].func_78784_a(40, 27).func_228303_a_(-3.0f, 16.0f, -3.0f, 6.0f, 6.0f, 6.0f, 0.0f, false);
        this.cyclone = new ModelRenderer((Model)this);
        this.cyclone.func_78793_a(0.0f, 0.0f, 0.0f);
        this.cyclone.func_78784_a(15, 39).func_228303_a_(-12.5f, 23.0f, -12.5f, 25.0f, 0.0f, 25.0f, 0.0f, false);
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)this.head);
        builder.addAll(Arrays.asList(this.body));
        builder.add((Object)this.cyclone);
        this.partsList = builder.build();
    }

    public Iterable<ModelRenderer> func_225601_a_() {
        return this.partsList;
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float partialTicks = ageInTicks - (float)((LivingEntity)entityIn).field_70173_aa;
        for (int i = 0; i < this.body.length; ++i) {
            this.body[i].field_78796_g = (ageInTicks * (float)(i + 1) * 10.0f - MathHelper.func_219799_g((float)partialTicks, (float)((LivingEntity)entityIn).field_70760_ar, (float)((LivingEntity)entityIn).field_70761_aq)) * (float)Math.PI / 180.0f;
        }
        this.cyclone.field_78796_g = (ageInTicks * 20.0f - MathHelper.func_219799_g((float)partialTicks, (float)((LivingEntity)entityIn).field_70760_ar, (float)((LivingEntity)entityIn).field_70761_aq)) * (float)Math.PI / 180.0f;
        this.head.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
        this.head.field_78795_f = headPitch * ((float)Math.PI / 180);
    }
}

