/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.event;

import cofh.thermal.core.world.biome.ThermalBiomeFeatures;
import cofh.thermal.lib.common.ThermalRecipeManagers;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLModIdMappingEvent;

@Mod.EventBusSubscriber(modid="thermal")
public class TCoreCommonSetupEvents {
    private TCoreCommonSetupEvents() {
    }

    @SubscribeEvent
    public static void addReloadListener(final AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)new ReloadListener<Void>(){

            protected Void prepare(IResourceManager resourceManagerIn, IProfiler profilerIn) {
                ThermalRecipeManagers.instance().setServerRecipeManager(event.getDataPackRegistries().func_240967_e_());
                return null;
            }

            protected void apply(Void nothing, IResourceManager resourceManagerIn, IProfiler profilerIn) {
            }
        });
    }

    @SubscribeEvent
    public static void tagsUpdated(TagsUpdatedEvent.CustomTagTypes event) {
        ThermalRecipeManagers.instance().refreshServer();
    }

    @SubscribeEvent
    public static void idRemap(FMLModIdMappingEvent event) {
        ThermalRecipeManagers.instance().refreshServer();
    }

    @SubscribeEvent
    public static void recipesUpdated(RecipesUpdatedEvent event) {
        ThermalRecipeManagers.instance().refreshClient(event.getRecipeManager());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void biomeLoadingAdd(BiomeLoadingEvent event) {
        ThermalBiomeFeatures.addOreGeneration(event);
        ThermalBiomeFeatures.addOilGeneration(event);
        ThermalBiomeFeatures.addHostileSpawns(event);
    }
}

