/*
 * Decompiled with CFR 0.152.
 */
package com.cscot.basicnetherores.util.handler;

import com.cscot.basicnetherores.BasicNetherOres;
import com.cscot.basicnetherores.config.OreGenerationConfig;
import com.cscot.basicnetherores.config.OreProtectionConfig;
import com.cscot.basicnetherores.util.helpers.BlockListHelper;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;

@Mod.EventBusSubscriber
public class ConfigHandler {
    public static final ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
    public static ForgeConfigSpec COMMON_CONFIG;

    public static void loadConfig(ForgeConfigSpec spec, Path file) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)file).sync().autosave().autoreload().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
    }

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading configEvent) {
        BasicNetherOres.logger.debug("Loaded {} config file {}", (Object)"bno", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onChange(ModConfig.Reloading event) {
        if (event.getConfig().getModId().equals("bno")) {
            BasicNetherOres.logger.fatal(Logging.CORE, "{} config just got changed on the file system!", (Object)"bno");
            BlockListHelper.initProtectedBlocks();
        }
    }

    static {
        OreGenerationConfig.Init(COMMON_BUILDER);
        OreProtectionConfig.Init(COMMON_BUILDER);
        COMMON_CONFIG = COMMON_BUILDER.build();
    }
}

