/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import de.srendi.advancedperipherals.common.addons.computercraft.operations.SphereOperation;
import de.srendi.advancedperipherals.common.addons.computercraft.operations.SphereOperationContext;
import de.srendi.advancedperipherals.common.blocks.base.PeripheralTileEntity;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.util.LuaConverter;
import de.srendi.advancedperipherals.lib.peripherals.BasePeripheral;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralPlugin;
import de.srendi.advancedperipherals.lib.peripherals.owner.IPeripheralOwner;
import de.srendi.advancedperipherals.lib.peripherals.owner.PocketPeripheralOwner;
import de.srendi.advancedperipherals.lib.peripherals.owner.TileEntityPeripheralOwner;
import de.srendi.advancedperipherals.lib.peripherals.owner.TurtlePeripheralOwner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class EnvironmentDetectorPeripheral
extends BasePeripheral<IPeripheralOwner> {
    public static final String TYPE = "environmentDetector";
    private static final List<Function<IPeripheralOwner, IPeripheralPlugin>> PLUGINS = new LinkedList<Function<IPeripheralOwner, IPeripheralPlugin>>();

    protected EnvironmentDetectorPeripheral(IPeripheralOwner owner) {
        super(TYPE, owner);
        owner.attachOperation(SphereOperation.SCAN_ENTITIES);
        for (Function<IPeripheralOwner, IPeripheralPlugin> plugin : PLUGINS) {
            this.addPlugin(plugin.apply(owner));
        }
    }

    public EnvironmentDetectorPeripheral(PeripheralTileEntity<?> tileEntity) {
        this(new TileEntityPeripheralOwner(tileEntity).attachFuel());
    }

    public EnvironmentDetectorPeripheral(ITurtleAccess turtle, TurtleSide side) {
        this(new TurtlePeripheralOwner(turtle, side).attachFuel(1));
    }

    public EnvironmentDetectorPeripheral(IPocketAccess pocket) {
        this(new PocketPeripheralOwner(pocket));
    }

    private static int estimateCost(int radius) {
        if (radius <= SphereOperation.SCAN_ENTITIES.getMaxFreeRadius()) {
            return 0;
        }
        if (radius > SphereOperation.SCAN_ENTITIES.getMaxCostRadius()) {
            return -1;
        }
        return SphereOperation.SCAN_ENTITIES.getCost(SphereOperationContext.of(radius));
    }

    public static void addIntegrationPlugin(Function<IPeripheralOwner, IPeripheralPlugin> plugin) {
        PLUGINS.add(plugin);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)APConfig.PERIPHERALS_CONFIG.ENABLE_ENERGY_DETECTOR.get();
    }

    @LuaFunction(mainThread=true)
    public final String getBiome() {
        String biomeName = this.getWorld().func_226691_t_(this.getPos()).getRegistryName().toString();
        String[] biome = biomeName.split(":");
        return biome[1];
    }

    @LuaFunction(mainThread=true)
    public final int getSkyLightLevel() {
        return this.getWorld().func_226658_a_(LightType.SKY, this.getPos().func_177982_a(0, 1, 0));
    }

    @LuaFunction(mainThread=true)
    public final int getBlockLightLevel() {
        return this.getWorld().func_226658_a_(LightType.BLOCK, this.getPos().func_177982_a(0, 1, 0));
    }

    @LuaFunction(mainThread=true)
    public final int getDayLightLevel() {
        World world = this.getWorld();
        int i = world.func_226658_a_(LightType.SKY, this.getPos().func_177982_a(0, 1, 0)) - world.func_175657_ab();
        float f = world.func_72929_e(1.0f);
        if (i > 0) {
            float f1 = f < (float)Math.PI ? 0.0f : (float)Math.PI * 2;
            f += (f1 - f) * 0.2f;
            i = Math.round((float)i * MathHelper.func_76134_b((float)f));
        }
        i = MathHelper.func_76125_a((int)i, (int)0, (int)15);
        return i;
    }

    @LuaFunction(mainThread=true)
    public final long getTime() {
        return this.getWorld().func_72820_D();
    }

    @LuaFunction(mainThread=true)
    public final boolean isSlimeChunk() {
        ChunkPos chunkPos = new ChunkPos(this.getPos());
        return SharedSeedRandom.func_205190_a((int)chunkPos.field_77276_a, (int)chunkPos.field_77275_b, (long)((ISeedReader)this.getWorld()).func_72905_C(), (long)987234911L).nextInt(10) == 0;
    }

    @LuaFunction(mainThread=true)
    public final String getDimensionProvider() {
        return this.getWorld().func_234923_W_().getRegistryName().func_110624_b();
    }

    @LuaFunction(mainThread=true)
    public final String getDimensionName() {
        return this.getWorld().func_234923_W_().getRegistryName().func_110623_a();
    }

    @LuaFunction(mainThread=true)
    public final String getDimensionPaN() {
        return this.getWorld().func_234923_W_().getRegistryName().toString();
    }

    @LuaFunction(mainThread=true)
    public final boolean isDimension(String dimension) {
        return this.getWorld().func_234923_W_().getRegistryName().func_110623_a().equals(dimension);
    }

    @LuaFunction(mainThread=true)
    public final Set<String> listDimensions() {
        HashSet<String> dimensions = new HashSet<String>();
        ServerLifecycleHooks.getCurrentServer().func_212370_w().forEach(serverWorld -> dimensions.add(serverWorld.func_234923_W_().getRegistryName().func_110623_a()));
        return dimensions;
    }

    @LuaFunction(mainThread=true)
    public final int getMoonId() {
        return this.getCurrentMoonPhase().keySet().toArray(new Integer[0])[0];
    }

    @LuaFunction(mainThread=true)
    public final String getMoonName() {
        String[] name = this.getCurrentMoonPhase().values().toArray(new String[0]);
        return name[0];
    }

    private Map<Integer, String> getCurrentMoonPhase() {
        HashMap<Integer, String> moon = new HashMap<Integer, String>();
        if (this.getWorld().func_234923_W_().getRegistryName().func_110623_a().equals("overworld")) {
            switch (this.getWorld().func_242414_af()) {
                case 0: {
                    moon.put(0, "Full moon");
                    break;
                }
                case 1: {
                    moon.put(1, "Waning gibbous");
                    break;
                }
                case 2: {
                    moon.put(2, "Third quarter");
                    break;
                }
                case 3: {
                    moon.put(3, "Wanning crescent");
                    break;
                }
                case 4: {
                    moon.put(4, "New moon");
                    break;
                }
                case 5: {
                    moon.put(5, "Waxing crescent");
                    break;
                }
                case 6: {
                    moon.put(6, "First quarter");
                    break;
                }
                case 7: {
                    moon.put(7, "Waxing gibbous");
                    break;
                }
                default: {
                    moon.put(0, "What is a moon");
                    break;
                }
            }
        } else {
            moon.put(0, "Moon.exe not found...");
        }
        return moon;
    }

    @LuaFunction(mainThread=true)
    public final boolean isRaining() {
        return this.getWorld().func_72867_j(0.0f) > 0.0f;
    }

    @LuaFunction(mainThread=true)
    public final boolean isThunder() {
        return this.getWorld().func_72867_j(0.0f) > 0.0f;
    }

    @LuaFunction(mainThread=true)
    public final boolean isSunny() {
        return this.getWorld().func_72819_i(0.0f) < 1.0f && this.getWorld().func_72867_j(0.0f) < 1.0f;
    }

    @LuaFunction(mainThread=true)
    public final MethodResult scanEntities(@Nonnull IComputerAccess access, @Nonnull IArguments arguments) throws LuaException {
        int radius = arguments.getInt(0);
        return this.withOperation(SphereOperation.SCAN_ENTITIES, new SphereOperationContext(radius), context -> {
            if (radius > SphereOperation.SCAN_ENTITIES.getMaxCostRadius()) {
                return MethodResult.of((Object[])new Object[]{null, "Radius is exceed max value"});
            }
            return null;
        }, context -> {
            BlockPos pos = this.owner.getPos();
            AxisAlignedBB box = new AxisAlignedBB(pos);
            ArrayList entities = new ArrayList();
            this.getWorld().func_175674_a((Entity)null, box.func_186662_g((double)radius), entity -> entity instanceof LivingEntity).forEach(entity -> entities.add(LuaConverter.completeEntityWithPositionToLua(entity, ItemStack.field_190927_a, pos)));
            return MethodResult.of(entities);
        }, null);
    }

    @LuaFunction
    public final MethodResult scanCost(int radius) {
        int estimatedCost = EnvironmentDetectorPeripheral.estimateCost(radius);
        if (estimatedCost < 0) {
            return MethodResult.of((Object[])new Object[]{null, "Radius is exceed max value"});
        }
        return MethodResult.of((Object)estimatedCost);
    }
}

