/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.turtles;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.turtle.blocks.TileTurtle;
import de.srendi.advancedperipherals.common.addons.computercraft.peripheral.ChatBoxPeripheral;
import de.srendi.advancedperipherals.common.events.Events;
import de.srendi.advancedperipherals.common.setup.Blocks;
import de.srendi.advancedperipherals.lib.turtle.PeripheralTurtleUpgrade;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class TurtleChatBoxUpgrade
extends PeripheralTurtleUpgrade<ChatBoxPeripheral> {
    public static final ResourceLocation ID = new ResourceLocation("advancedperipherals", "chat_box_turtle");
    private static final ModelResourceLocation leftModel = new ModelResourceLocation("advancedperipherals:turtle_chat_box_upgrade_left", "inventory");
    private static final ModelResourceLocation rightModel = new ModelResourceLocation("advancedperipherals:turtle_chat_box_upgrade_right", "inventory");

    public TurtleChatBoxUpgrade() {
        super(ID, new ItemStack((IItemProvider)Blocks.CHAT_BOX.get()));
    }

    @Override
    protected ModelResourceLocation getLeftModel() {
        return leftModel;
    }

    @Override
    protected ModelResourceLocation getRightModel() {
        return rightModel;
    }

    @Override
    protected ChatBoxPeripheral buildPeripheral(@NotNull ITurtleAccess turtle, @NotNull TurtleSide side) {
        return new ChatBoxPeripheral(turtle, side);
    }

    public void update(@NotNull ITurtleAccess turtle, @NotNull TurtleSide side) {
        TileEntity tile;
        super.update(turtle, side);
        if (turtle.getWorld().field_72995_K) {
            return;
        }
        if (turtle.getUpgrade(side) instanceof TurtleChatBoxUpgrade && (tile = turtle.getWorld().func_175625_s(turtle.getPosition())) instanceof TileTurtle) {
            TileTurtle tileTurtle = (TileTurtle)tile;
            ServerComputer computer = tileTurtle.getServerComputer();
            this.setLastConsumedMessage(turtle, side, Events.traverseChatMessages(this.getLastConsumedMessage(turtle, side), message -> computer.queueEvent("chat", new Object[]{message.username, message.message, message.uuid, message.isHidden})));
        }
    }

    private long getLastConsumedMessage(ITurtleAccess turtle, TurtleSide side) {
        if (turtle.getUpgradeNBTData(side).func_74764_b("lastConsumedMessage")) {
            return turtle.getUpgradeNBTData(side).func_74763_f("lastConsumedMessage");
        }
        return -1L;
    }

    private void setLastConsumedMessage(ITurtleAccess turtle, TurtleSide side, long message) {
        turtle.getUpgradeNBTData(side).func_74772_a("lastConsumedMessage", message);
        turtle.updateUpgradeNBTData(side);
    }
}

