/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.lib;

import net.minecraftforge.common.ForgeConfigSpec;

public class LibConfig {
    public static boolean isInitialCooldownEnabled = true;
    public static int initialCooldownSensetiveLevel = 6000;
    private static boolean testMode = false;
    private static ForgeConfigSpec.BooleanValue IS_INITIAL_COOLDOWN_ENABLED;
    private static ForgeConfigSpec.IntValue INITIAL_COOLDOWN_SENSENTIVE_LEVEL;

    public static void setTestMode(boolean mode) {
        testMode = mode;
        if (mode) {
            isInitialCooldownEnabled = false;
        } else if (IS_INITIAL_COOLDOWN_ENABLED != null) {
            LibConfig.reloadConfig();
        } else {
            isInitialCooldownEnabled = true;
        }
    }

    public static void build(ForgeConfigSpec.Builder builder) {
        IS_INITIAL_COOLDOWN_ENABLED = builder.comment("Enables initial cooldown on peripheral initialization").define("isInitialCooldownEnabled", true);
        INITIAL_COOLDOWN_SENSENTIVE_LEVEL = builder.comment("Determinates initial cooldown sensentive level, values lower then this value will not trigger initial cooldown").defineInRange("initialCooldownSensetiveLevel", 6000, 0, Integer.MAX_VALUE);
    }

    public static void reloadConfig() {
        if (!testMode) {
            isInitialCooldownEnabled = (Boolean)IS_INITIAL_COOLDOWN_ENABLED.get();
            initialCooldownSensetiveLevel = (Integer)INITIAL_COOLDOWN_SENSENTIVE_LEVEL.get();
        }
    }
}

