/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.lib.turtle;

import com.mojang.blaze3d.matrix.MatrixStack;
import dan200.computercraft.api.client.TransformedModel;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import de.srendi.advancedperipherals.common.util.DataStorageUtil;
import de.srendi.advancedperipherals.lib.peripherals.IBasePeripheral;
import de.srendi.advancedperipherals.lib.turtle.PeripheralTurtleUpgrade;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3f;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ClockwiseAnimatedTurtleUpgrade<T extends IBasePeripheral<?>>
extends PeripheralTurtleUpgrade<T> {
    public ClockwiseAnimatedTurtleUpgrade(ResourceLocation id, String adjective, ItemStack item) {
        super(id, adjective, item);
    }

    public ClockwiseAnimatedTurtleUpgrade(ResourceLocation id, ItemStack item) {
        super(id, item);
    }

    @Override
    @NotNull
    public TransformedModel getModel(@Nullable ITurtleAccess turtle, @NotNull TurtleSide side) {
        if (this.getLeftModel() == null) {
            MatrixStack stack = new MatrixStack();
            stack.func_227860_a_();
            stack.func_227861_a_(0.0, 0.5, 0.5);
            if (turtle != null) {
                int rotationStep = DataStorageUtil.RotationCharge.get(turtle, side);
                stack.func_227863_a_(Vector3f.field_229178_a_.func_229187_a_((float)(-10 * rotationStep)));
            }
            stack.func_227861_a_(0.0, -0.5, -0.5);
            stack.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(90.0f));
            if (side == TurtleSide.LEFT) {
                stack.func_227861_a_(0.0, 0.0, -0.6);
            } else {
                stack.func_227861_a_(0.0, 0.0, -1.4);
            }
            return TransformedModel.of((ItemStack)this.getCraftingItem(), (TransformationMatrix)new TransformationMatrix(stack.func_227866_c_().func_227870_a_()));
        }
        return TransformedModel.of((ModelResourceLocation)(side == TurtleSide.LEFT ? this.getLeftModel() : this.getRightModel()));
    }

    public void chargeConsumingCallback() {
    }

    public void update(@NotNull ITurtleAccess turtle, @NotNull TurtleSide side) {
        super.update(turtle, side);
        if (this.tick % 2 == 0 && DataStorageUtil.RotationCharge.consume(turtle, side)) {
            this.chargeConsumingCallback();
        }
    }
}

