/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.world.carver;

import com.yungnickyoung.minecraft.bettercaves.BetterCaves;
import com.yungnickyoung.minecraft.bettercaves.config.Configuration;
import com.yungnickyoung.minecraft.bettercaves.world.carver.CarvingContext;
import com.yungnickyoung.minecraft.bettercaves.world.carver.controller.MasterController;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.carver.EmptyCarverConfig;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.server.ServerWorld;

public class BetterCavesCarver
extends WorldCarver<EmptyCarverConfig> {
    public BetterCavesCarver() {
        super(EmptyCarverConfig.field_236237_b_, 256);
    }

    @ParametersAreNonnullByDefault
    public boolean carveRegion(IChunk chunkIn, Function<BlockPos, Biome> biomePos, Random rand, int seaLevel, int chunkXOffset, int chunkZOffset, int chunkX, int chunkZ, BitSet carvingMask, EmptyCarverConfig config) {
        CarvingContext context = CarvingContext.peek();
        if (context == null) {
            return false;
        }
        ServerWorld world = context.getWorld();
        if (world == null) {
            BetterCaves.LOGGER.error("ERROR: Unable to retrieve world from CarvingContext!");
            return false;
        }
        BitSet airCarvingMask = context.getMask(GenerationStage.Carving.AIR);
        BitSet liquidCarvingMask = context.getMask(GenerationStage.Carving.LIQUID);
        String dimensionName = null;
        try {
            dimensionName = Objects.requireNonNull(world.func_234923_W_().func_240901_a_()).toString();
        }
        catch (NullPointerException e) {
            BetterCaves.LOGGER.error("ERROR: Unable to get dimension name! Using default cave gen...");
        }
        if (dimensionName == null || !this.isDimensionWhitelisted(dimensionName)) {
            return this.useDefaultCarvers(world, chunkIn, biomePos, rand, seaLevel, chunkXOffset, chunkZOffset, chunkX, chunkZ, airCarvingMask, liquidCarvingMask);
        }
        CarvingContext.pop();
        if (BetterCaves.activeCarversMap.get(dimensionName) == null || BetterCaves.activeCarversMap.get(dimensionName).getSeed() != world.func_72905_C()) {
            MasterController newCarver = new MasterController();
            BetterCaves.activeCarversMap.put(dimensionName, newCarver);
            BetterCaves.LOGGER.info(String.format("CREATING AND INIT'ING CARVER W DIMENSION %s...", dimensionName));
            newCarver.initialize((ISeedReader)world);
        }
        MasterController masterController = BetterCaves.activeCarversMap.get(dimensionName);
        masterController.setWorld((ISeedReader)world);
        return masterController.carveRegion(chunkIn, biomePos, chunkIn.func_76632_l().field_77276_a, chunkIn.func_76632_l().field_77275_b, airCarvingMask, liquidCarvingMask);
    }

    @ParametersAreNonnullByDefault
    public boolean shouldCarve(Random rand, int chunkX, int chunkZ, EmptyCarverConfig config) {
        return true;
    }

    protected boolean func_222708_a(double p_222708_1_, double p_222708_3_, double p_222708_5_, int p_222708_7_) {
        return true;
    }

    private boolean useDefaultCarvers(ServerWorld world, IChunk chunkIn, Function<BlockPos, Biome> biomePos, Random rand, int seaLevel, int chunkXOffset, int chunkZOffset, int chunkX, int chunkZ, BitSet airCarvingMask, BitSet liquidCarvingMask) {
        ConfiguredCarver<?> carver;
        String biomeName = biomePos.apply(new BlockPos(chunkIn.func_76632_l().field_77276_a << 4, 0, chunkIn.func_76632_l().field_77275_b << 4)).getRegistryName().toString();
        List<Supplier<ConfiguredCarver<?>>> defaultAirCarvers = BetterCaves.defaultBiomeAirCarvers.get(biomeName);
        List<Supplier<ConfiguredCarver<?>>> defaultLiquidCarvers = BetterCaves.defaultBiomeLiquidCarvers.get(biomeName);
        if (defaultAirCarvers == null || defaultLiquidCarvers == null) {
            return false;
        }
        for (Supplier<ConfiguredCarver<?>> carverSupplier : defaultAirCarvers) {
            carver = carverSupplier.get();
            if (!carver.func_222730_a(rand, chunkX, chunkZ)) continue;
            carver.func_227207_a_(chunkIn, biomePos, rand, seaLevel, chunkXOffset, chunkZOffset, chunkX, chunkZ, airCarvingMask);
        }
        for (Supplier<ConfiguredCarver<?>> carverSupplier : defaultLiquidCarvers) {
            carver = carverSupplier.get();
            if (!carver.func_222730_a(rand, chunkX, chunkZ)) continue;
            carver.func_227207_a_(chunkIn, biomePos, rand, seaLevel, chunkXOffset, chunkZOffset, chunkX, chunkZ, liquidCarvingMask);
        }
        return true;
    }

    private boolean isDimensionWhitelisted(String dimensionName) {
        return (Boolean)Configuration.enableGlobalWhitelist.get() != false || BetterCaves.whitelistedDimensions.contains(dimensionName);
    }
}

