/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.world.carver.controller;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.bettercaves.config.util.ConfigHolder;
import com.yungnickyoung.minecraft.bettercaves.world.carver.ravine.RavineCarver;
import java.util.BitSet;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.carver.ICarverConfig;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.ProbabilityConfig;

public class RavineCarverController {
    private ISeedReader world;
    private SharedSeedRandom random = new SharedSeedRandom();
    private boolean isRavinesEnabled;
    private boolean isDebugViewEnabled;
    private ConfiguredCarver<ProbabilityConfig> configuredCarver;
    private RavineCarver ravineCarver;

    public RavineCarverController(ISeedReader worldIn, ConfigHolder config) {
        this.world = worldIn;
        this.isRavinesEnabled = config.enableVanillaRavines.get();
        this.isDebugViewEnabled = config.debugVisualizer.get();
        this.ravineCarver = new RavineCarver(this.world, config, (Codec<ProbabilityConfig>)ProbabilityConfig.field_236576_b_);
        this.configuredCarver = new ConfiguredCarver((WorldCarver)this.ravineCarver, (ICarverConfig)new ProbabilityConfig(0.02f));
    }

    public void carveChunk(IChunk chunkIn, int chunkX, int chunkZ, BlockState[][] liquidBlocks, Function<BlockPos, Biome> biomePos, BitSet airCarvingMask, BitSet liquidCarvingMask) {
        if (this.isDebugViewEnabled || !this.isRavinesEnabled) {
            return;
        }
        for (int currChunkX = chunkX - 8; currChunkX <= chunkX + 8; ++currChunkX) {
            for (int currChunkZ = chunkZ - 8; currChunkZ <= chunkZ + 8; ++currChunkZ) {
                this.random.func_202425_c(this.world.func_72905_C(), currChunkX, currChunkZ);
                if (!this.configuredCarver.func_222730_a((Random)this.random, chunkX, chunkZ)) continue;
                this.ravineCarver.carve(chunkIn, (Random)this.random, this.world.func_181545_F(), currChunkX, currChunkZ, chunkX, chunkZ, liquidBlocks, biomePos, airCarvingMask, liquidCarvingMask);
            }
        }
    }

    public void setWorld(ISeedReader worldIn) {
        this.world = worldIn;
        this.ravineCarver.setWorld(worldIn);
    }
}

