/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.common.entity;

import dev.itsmeow.betteranimalsplus.common.entity.EntityPheasant;
import dev.itsmeow.betteranimalsplus.common.entity.ai.EntityAIEatBerries;
import dev.itsmeow.betteranimalsplus.common.entity.util.EntityUtil;
import dev.itsmeow.betteranimalsplus.common.entity.util.IDropHead;
import dev.itsmeow.betteranimalsplus.common.entity.util.abstracts.EntityAnimalWithSelectiveTypes;
import dev.itsmeow.betteranimalsplus.common.entity.util.abstracts.EntityAnimalWithTypes;
import dev.itsmeow.betteranimalsplus.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.BiomeTypes;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.variant.IVariant;
import dev.itsmeow.betteranimalsplus.init.ModEntities;
import dev.itsmeow.betteranimalsplus.util.ModPlatformEvents;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CropsBlock;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.monster.HoglinEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.ZombifiedPiglinEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;

public class EntityBoar
extends EntityAnimalWithSelectiveTypes
implements IMob,
IDropHead<EntityAnimalWithTypes> {
    public EntityBoar(EntityType<? extends EntityBoar> entityType, World worldIn) {
        super((EntityType<? extends EntityAnimalWithSelectiveTypes>)entityType, worldIn);
        this.func_184644_a(PathNodeType.DANGER_OTHER, 0.0f);
        this.func_184644_a(PathNodeType.DAMAGE_OTHER, 0.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.2, false){

            public boolean func_75250_a() {
                return !EntityBoar.this.func_70631_g_() && super.func_75250_a();
            }

            public boolean func_75253_b() {
                return !EntityBoar.this.func_70631_g_() && super.func_75253_b();
            }
        });
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        if (this.getContainer().getCustomConfiguration().getBoolean("nerf_options/eat_crops")) {
            this.field_70714_bg.func_75776_a(4, (Goal)new BoarAIEatCrops(this));
            this.field_70714_bg.func_75776_a(5, (Goal)new EntityAIEatBerries((CreatureEntity)this, 1.0, 12, 2){

                @Override
                protected void eatBerry() {
                    super.eatBerry();
                    if (EntityBoar.this.getContainer().getCustomConfiguration().getBoolean("nerf_options/breed_from_crops")) {
                        EntityBoar.this.func_146082_f(null);
                    }
                }
            });
        }
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70715_bh.func_75776_a(0, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]){

            public boolean func_75250_a() {
                return !EntityBoar.this.func_70631_g_() && !EntityBoar.this.isPeaceful() && super.func_75250_a();
            }

            public boolean func_75253_b() {
                return !EntityBoar.this.func_70631_g_() && !EntityBoar.this.isPeaceful() && super.func_75253_b();
            }
        }.func_220794_a(new Class[]{EntityBoar.class}));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal<AnimalEntity>((MobEntity)this, AnimalEntity.class, 90, true, true, in -> in instanceof ChickenEntity || in instanceof EntityPheasant || in instanceof AnimalEntity && in.func_70631_g_() && !(in instanceof EntityBoar) && !(in instanceof PigEntity) && !(in instanceof HoglinEntity)){

            public boolean func_75250_a() {
                return EntityBoar.this.shouldAttack() && EntityBoar.this.attackChance() && super.func_75250_a();
            }

            public boolean func_75253_b() {
                return EntityBoar.this.shouldAttack() && super.func_75253_b();
            }
        });
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal<LivingEntity>((MobEntity)this, LivingEntity.class, 50, true, true, in -> in instanceof AnimalEntity && !(in instanceof EntityBoar) && !(in instanceof PigEntity) && !(in instanceof HoglinEntity) || in instanceof PlayerEntity){

            public boolean func_75250_a() {
                return EntityBoar.this.shouldAttack() && EntityBoar.this.attackChance() && super.func_75250_a();
            }

            public boolean func_75253_b() {
                return EntityBoar.this.shouldAttack() && super.func_75253_b();
            }
        });
    }

    public boolean shouldAttack() {
        return !this.func_70631_g_() && !this.isPeaceful();
    }

    public boolean attackChance() {
        return (double)this.getContainer().getCustomConfiguration().getInt("nerf_options/target_chance") / 100.0 > Math.random();
    }

    public boolean isPeaceful() {
        return this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187697_dL;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187703_dN;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187700_dM;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187709_dP, 0.15f, 1.0f);
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        this.doHeadDrop();
    }

    protected ResourceLocation func_184647_J() {
        return EntityType.field_200784_X.func_220348_g();
    }

    public boolean func_70652_k(Entity entityIn) {
        Vector3d pos = this.func_213303_ch();
        Vector3d targetPos = entityIn.func_213303_ch();
        ((LivingEntity)entityIn).func_233627_a_(0.8f, pos.field_72450_a - targetPos.field_72450_a, pos.field_72449_c - targetPos.field_72449_c);
        return super.func_70652_k(entityIn);
    }

    public void func_241841_a(ServerWorld p_241841_1_, LightningBoltEntity p_241841_2_) {
        if (!this.field_70170_p.field_72995_K && !this.field_70729_aU) {
            ZombifiedPiglinEntity entitypigzombie = (ZombifiedPiglinEntity)EntityType.field_233592_ba_.func_200721_a(this.field_70170_p);
            entitypigzombie.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151010_B));
            entitypigzombie.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
            entitypigzombie.func_94061_f(this.func_175446_cd());
            if (this.func_145818_k_()) {
                entitypigzombie.func_200203_b(this.func_200201_e());
                entitypigzombie.func_174805_g(true);
            }
            this.field_70170_p.func_217376_c((Entity)entitypigzombie);
            this.func_70106_y();
        }
    }

    @Override
    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity ageable) {
        if (this.getVariant().isPresent()) {
            if (ageable instanceof EntityBoar) {
                EntityBoar boar = (EntityBoar)this.getContainer().getEntityType().func_200721_a((World)world);
                boar.setType((IVariant)this.getVariant().get());
                return boar;
            }
            if (ageable instanceof PigEntity) {
                PigEntity pig = new PigEntity(EntityType.field_200784_X, this.field_70170_p);
                EntityBoar boar = (EntityBoar)this.getContainer().getEntityType().func_200721_a((World)world);
                boar.setType((IVariant)this.getVariant().get());
                return this.field_70146_Z.nextBoolean() ? pig : boar;
            }
        }
        return null;
    }

    public boolean func_70878_b(AnimalEntity otherAnimal) {
        if (otherAnimal != this && (otherAnimal instanceof EntityBoar || otherAnimal instanceof PigEntity)) {
            return otherAnimal.func_70880_s() && this.func_70880_s();
        }
        return false;
    }

    public boolean func_180431_b(DamageSource source) {
        return super.func_180431_b(source) || source == DamageSource.field_220302_v;
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151172_bF || stack.func_77973_b() == Items.field_151150_bK;
    }

    @Override
    public String[] getTypesFor(RegistryKey<Biome> biomeKey, Biome biome, Set<BiomeTypes.Type> types, SpawnReason reason) {
        if (types.contains(BiomeTypes.CONIFEROUS) && types.contains(BiomeTypes.SNOWY)) {
            return new String[]{"dark_brown", "gray"};
        }
        if (types.contains(BiomeTypes.SNOWY) && !types.contains(BiomeTypes.CONIFEROUS) && !types.contains(BiomeTypes.FOREST)) {
            return new String[]{"gray"};
        }
        return new String[]{"dark_brown", "light_brown", "gray"};
    }

    @Override
    public EntityTypeContainer<EntityBoar> getContainer() {
        return ModEntities.BOAR;
    }

    @Override
    protected EntityAnimalWithTypes getBaseChild() {
        return (EntityAnimalWithTypes)this.getContainer().getEntityType().func_200721_a(this.field_70170_p);
    }

    @Override
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason reason, ILivingEntityData livingdata, CompoundNBT compound) {
        return EntityUtil.childChance((AgeableEntity)this, reason, super.func_213386_a(world, difficulty, reason, livingdata, compound), 0.25f);
    }

    public static class BoarAIEatCrops
    extends MoveToBlockGoal {
        private final EntityBoar boar;

        public BoarAIEatCrops(EntityBoar boarIn) {
            super((CreatureEntity)boarIn, 0.7, 16);
            this.boar = boarIn;
        }

        public boolean func_75250_a() {
            if (this.field_179496_a <= 0 && !ModPlatformEvents.mobGrief(this.boar.field_70170_p, (MobEntity)this.boar)) {
                return false;
            }
            return !this.boar.func_70880_s() && super.func_75250_a();
        }

        public boolean func_75253_b() {
            return !this.boar.func_70880_s() && super.func_75253_b();
        }

        public void func_75246_d() {
            if (!this.field_179494_b.func_218137_a((IPosition)this.field_179495_c.func_213303_ch(), this.func_203110_f())) {
                this.boar.func_70605_aq().func_75642_a((double)this.field_179494_b.func_177958_n() + 0.5, (double)this.field_179494_b.func_177956_o(), (double)this.field_179494_b.func_177952_p() + 0.5, this.field_179492_d);
            } else {
                World world = this.boar.field_70170_p;
                BlockPos pos = this.field_179494_b;
                BlockState state = world.func_180495_p(pos);
                Block block = state.func_177230_c();
                if (!this.boar.func_70880_s() && block instanceof CropsBlock && ((CropsBlock)block).func_185525_y(state)) {
                    world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                    world.func_175655_b(pos, true);
                    if (this.boar.getContainer().getCustomConfiguration().getBoolean("nerf_options/breed_from_crops")) {
                        this.boar.func_146082_f(null);
                    }
                }
            }
            this.boar.func_70671_ap().func_75650_a((double)this.field_179494_b.func_177958_n() + 0.5, (double)this.field_179494_b.func_177956_o() + 0.5, (double)this.field_179494_b.func_177952_p() + 0.5, 10.0f, (float)this.boar.func_70646_bf());
        }

        protected boolean func_179488_a(IWorldReader worldIn, BlockPos pos) {
            BlockState state = worldIn.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (!this.boar.func_70880_s() && block instanceof CropsBlock && ((CropsBlock)block).func_185525_y(state)) {
                return worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150458_ak;
            }
            return false;
        }
    }
}

