/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.common.item;

import dev.itsmeow.betteranimalsplus.BetterAnimalsPlusMod;
import dev.itsmeow.betteranimalsplus.common.item.ItemModeledArmor;
import java.util.List;
import net.minecraft.block.DispenserBlock;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class ItemCape
extends ItemModeledArmor {
    public static CanEquipFunction can_equip = (s, a, e) -> true;
    public final Item repairItem;
    public static final IDispenseItemBehavior DISPENSE_ITEM_BEHAVIOR = new DefaultDispenseItemBehavior(){

        protected ItemStack func_82487_b(IBlockSource blockSource, ItemStack itemStack) {
            return ItemCape.dispenseArmor(blockSource, itemStack) ? itemStack : super.func_82487_b(blockSource, itemStack);
        }
    };

    public static boolean dispenseArmor(IBlockSource blockSource, ItemStack stack) {
        BlockPos blockPos = blockSource.func_180699_d().func_177972_a((Direction)blockSource.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a));
        List list = blockSource.func_197524_h().func_175647_a(LivingEntity.class, new AxisAlignedBB(blockPos), EntityPredicates.field_180132_d.and(new EntityPredicates.ArmoredMob(stack)));
        if (list.isEmpty()) {
            return false;
        }
        LivingEntity entity = (LivingEntity)list.get(0);
        EquipmentSlotType slot = MobEntity.func_184640_d((ItemStack)stack);
        if (!can_equip.canEquip(stack, slot, (Entity)entity)) {
            return false;
        }
        ItemStack itemStack2 = stack.func_77979_a(1);
        entity.func_184201_a(slot, itemStack2);
        if (entity instanceof MobEntity) {
            ((MobEntity)entity).func_184642_a(slot, 2.0f);
            ((MobEntity)entity).func_110163_bv();
        }
        return true;
    }

    public ItemCape(Item repairItem, IArmorMaterial material) {
        super(material, EquipmentSlotType.CHEST, new Item.Properties().func_200916_a(BetterAnimalsPlusMod.TAB));
        this.repairItem = repairItem;
        DispenserBlock.func_199774_a((IItemProvider)this, (IDispenseItemBehavior)DISPENSE_ITEM_BEHAVIOR);
    }

    public boolean canEquip(ItemStack stack, EquipmentSlotType armorType, Entity entity) {
        return armorType == EquipmentSlotType.CHEST && can_equip.canEquip(stack, armorType, entity);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return repair.func_77973_b() == this.repairItem;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected <A extends BipedModel<?>> A displays(A armorModel, EquipmentSlotType slot) {
        armorModel.field_78116_c.field_78806_j = false;
        armorModel.field_178720_f.field_78806_j = false;
        armorModel.field_78115_e.field_78806_j = true;
        armorModel.field_178723_h.field_78806_j = false;
        armorModel.field_178724_i.field_78806_j = false;
        armorModel.field_178721_j.field_78806_j = false;
        armorModel.field_178722_k.field_78806_j = false;
        return armorModel;
    }

    public ActionResult<ItemStack> func_77659_a(World level, PlayerEntity player, Hand interactionHand) {
        EquipmentSlotType slot;
        ItemStack stack = player.func_184586_b(interactionHand);
        if (!can_equip.canEquip(stack, slot = MobEntity.func_184640_d((ItemStack)stack), (Entity)player)) {
            return ActionResult.func_226251_d_((Object)stack);
        }
        ItemStack inSlot = player.func_184582_a(slot);
        if (inSlot.func_190926_b()) {
            player.func_184201_a(slot, stack.func_77946_l());
            stack.func_190920_e(0);
            return ActionResult.func_233538_a_((Object)stack, (boolean)level.func_201670_d());
        }
        return ActionResult.func_226251_d_((Object)stack);
    }

    @FunctionalInterface
    public static interface CanEquipFunction {
        public boolean canEquip(ItemStack var1, EquipmentSlotType var2, Entity var3);
    }
}

