/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.compat.curios;

import dev.itsmeow.betteranimalsplus.common.item.ItemBearCape;
import dev.itsmeow.betteranimalsplus.common.item.ItemCape;
import dev.itsmeow.betteranimalsplus.common.item.ItemWolfCape;
import dev.itsmeow.betteranimalsplus.compat.curios.CurioCape;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class CuriosModCompat {
    public static void subscribe(IEventBus modBus) {
        modBus.addListener(CuriosModCompat::interModEnqueue);
        MinecraftForge.EVENT_BUS.register(CuriosModCompat.class);
        ItemCape.can_equip = (stack, armorType, entity) -> !CuriosApi.getCuriosHelper().findEquippedCurio(s -> s.func_77973_b() instanceof ItemCape, (LivingEntity)((PlayerEntity)entity)).isPresent();
    }

    public static void interModEnqueue(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BACK.getMessageBuilder().build());
    }

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        final ItemStack stack = (ItemStack)event.getObject();
        final Item item = stack.func_77973_b();
        if (item instanceof ItemWolfCape || item instanceof ItemBearCape) {
            event.addCapability(CuriosCapability.ID_ITEM, new ICapabilityProvider(){
                final LazyOptional<ICurio> curio = LazyOptional.of(() -> new CurioCape(item instanceof ItemWolfCape ? "wolf" : "bear", stack));

                public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction direction) {
                    return CuriosCapability.ITEM.orEmpty(cap, this.curio);
                }
            });
        }
    }
}

