/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.imdlib.item;

import dev.itsmeow.betteranimalsplus.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.betteranimalsplus.imdlib.entity.interfaces.IContainable;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.EntityTypeContainerContainable;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.variant.IVariant;
import dev.itsmeow.betteranimalsplus.imdlib.mixin.ItemPropertiesInvoker;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public interface IContainerItem<T extends MobEntity> {
    public static final ITooltipFunction VARIANT_TOOLTIP = (container, stack, world, tooltip) -> {
        String id;
        Optional<IVariant> variant;
        CompoundNBT compoundnbt = stack.func_77978_p();
        if (compoundnbt != null && compoundnbt.func_150297_b("BucketVariantTag", 8) && (variant = container.getVariantForName(id = compoundnbt.func_74779_i("BucketVariantTag"))).isPresent()) {
            tooltip.add(new TranslationTextComponent("entity." + container.getModId() + "." + container.getEntityName().toLowerCase() + ".type." + variant.get().getName()).func_240701_a_(new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.GRAY}));
        }
    };

    public static String getVariantIfPresent(ItemStack stack) {
        CompoundNBT compoundnbt = stack.func_77978_p();
        if (compoundnbt != null && compoundnbt.func_150297_b("BucketVariantTag", 8)) {
            return compoundnbt.func_74779_i("BucketVariantTag");
        }
        return "";
    }

    @OnlyIn(value=Dist.CLIENT)
    default public <A extends Item> void addPropertyOverrides(A item) {
        ItemPropertiesInvoker.invokeRegister(item, new ResourceLocation(((IContainerItem)item).getContainer().getModId(), "variant"), (stack, world, entity) -> {
            String variant = IContainerItem.getVariantIfPresent(stack);
            if (!variant.isEmpty()) {
                Optional<IVariant> variantO = ((IContainerItem)item).getContainer().getVariantForName(variant);
                return variantO.isPresent() ? (float)(((IContainerItem)item).getContainer().getVariantIndex(variantO.get()) + 1) : 0.0f;
            }
            return 0.0f;
        });
    }

    public EntityTypeContainer<T> getContainer();

    default public EntityType<T> getEntityType() {
        return this.getContainer().getEntityType();
    }

    default public void placeEntity(ServerWorld worldIn, ItemStack stack, BlockPos pos) {
        MobEntity entity = (MobEntity)this.getEntityType().func_220342_a(worldIn, stack.func_77978_p(), stack.func_82837_s() ? stack.func_151000_E() : null, null, pos, SpawnReason.BUCKET, true, false);
        if (entity != null) {
            ((IContainable)entity).setFromContainer(true);
            ((IContainable)entity).readFromContainer(stack);
            if (stack.func_77978_p() != null) {
                ((IContainable)entity).readFromContainerTag(stack.func_77978_p());
            }
        }
    }

    @FunctionalInterface
    public static interface ITooltipFunction {
        public void addInformation(EntityTypeContainerContainable<? extends MobEntity, ?> var1, ItemStack var2, @Nullable World var3, List<ITextComponent> var4);
    }
}

