/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.skins.impl;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import lain.mods.skins.api.interfaces.ISkin;

public class SkinData
implements ISkin {
    private final Collection<Consumer<ISkin>> listeners = new CopyOnWriteArrayList<Consumer<ISkin>>();
    private final Collection<Function<ByteBuffer, ByteBuffer>> filters = new CopyOnWriteArrayList<Function<ByteBuffer, ByteBuffer>>();
    private ByteBuffer data;
    private String type;

    public static ByteBuffer toBuffer(byte[] data) {
        ByteBuffer buf = ByteBuffer.allocateDirect(data.length).order(ByteOrder.nativeOrder());
        buf.put(data);
        buf.rewind();
        return buf;
    }

    @Override
    public ByteBuffer getData() {
        return this.data;
    }

    @Override
    public String getSkinType() {
        return this.type;
    }

    @Override
    public boolean isDataReady() {
        return this.data != null;
    }

    @Override
    public synchronized void onRemoval() {
        for (Consumer<ISkin> listener : this.listeners) {
            listener.accept(this);
        }
        this.data = null;
        this.type = null;
    }

    public synchronized void put(byte[] data, String type) {
        ByteBuffer buf = null;
        if (data != null) {
            Function<ByteBuffer, ByteBuffer> filter;
            buf = SkinData.toBuffer(data);
            Iterator<Function<ByteBuffer, ByteBuffer>> iterator = this.filters.iterator();
            while (iterator.hasNext() && (buf = (filter = iterator.next()).apply(buf)) != null) {
            }
        }
        this.data = buf;
        this.type = type;
    }

    @Override
    public boolean setRemovalListener(Consumer<ISkin> listener) {
        if (listener == null || this.listeners.contains(listener)) {
            return false;
        }
        return this.listeners.add(listener);
    }

    @Override
    public boolean setSkinFilter(Function<ByteBuffer, ByteBuffer> filter) {
        if (filter == null || this.filters.contains(filter)) {
            return false;
        }
        return this.filters.add(filter);
    }
}

