/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.config.gui;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.common.config.gui.GuiConfigControl;
import team.creative.creativecore.common.config.holder.ConfigKey;
import team.creative.creativecore.common.config.holder.ICreativeConfigHolder;
import team.creative.creativecore.common.config.sync.ConfigurationChangePacket;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.controls.GuiButton;
import team.creative.creativecore.common.gui.controls.GuiButtonFixed;
import team.creative.creativecore.common.gui.controls.GuiLabel;
import team.creative.creativecore.common.gui.controls.GuiScrollBox;
import team.creative.creativecore.common.gui.controls.layout.GuiLeftRightBox;
import team.creative.creativecore.common.gui.dialog.DialogGuiLayer;
import team.creative.creativecore.common.gui.dialog.GuiDialogHandler;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.handler.GuiContainerHandler;
import team.creative.creativecore.common.util.mc.JsonUtils;
import team.creative.creativecore.common.util.text.TextBuilder;

public class ConfigGuiLayer
extends GuiLayer {
    public JsonObject ROOT = new JsonObject();
    public Dist side;
    public final ICreativeConfigHolder rootHolder;
    public ICreativeConfigHolder holder;
    public boolean changed = false;
    public int nextAction;
    public boolean force;

    public ConfigGuiLayer(ICreativeConfigHolder holder, Dist side) {
        super("config", 420, 234);
        this.rootHolder = holder;
        this.holder = holder;
        this.side = side;
        this.registerEvent(GuiControlChangedEvent.class, x -> {
            GuiConfigControl config = ConfigGuiLayer.getConfigControl(x.control);
            if (config != null) {
                this.changed = true;
                config.changed();
            }
        });
    }

    @Override
    public void create() {
        this.loadHolder(this.holder);
    }

    public void savePage() {
        GuiScrollBox box = (GuiScrollBox)this.get("box");
        JsonObject parent = null;
        for (GuiControl control : box) {
            JsonElement element;
            if (!(control instanceof GuiConfigControl) || (element = ((GuiConfigControl)control).save()) == null) continue;
            if (parent == null) {
                parent = JsonUtils.get(this.ROOT, this.holder.path());
            }
            parent.add(((GuiConfigControl)control).field.name, element);
        }
    }

    public void loadHolder(ICreativeConfigHolder holder) {
        if (!this.isEmpty()) {
            this.savePage();
            this.clear();
        }
        GuiLeftRightBox upperBox = new GuiLeftRightBox("upperbox", 0, 0);
        upperBox.add(new GuiLabel("path", 0, 2).setTitle((ITextComponent)new StringTextComponent("/" + String.join((CharSequence)"/", holder.path()))));
        if (holder != this.rootHolder) {
            upperBox.addRight(new GuiButton("back", 0, 0, x -> this.loadHolder(holder.parent())).setTitle((ITextComponent)new TranslationTextComponent("gui.back")));
        }
        this.holder = holder;
        this.add(upperBox);
        GuiScrollBox box = new GuiScrollBox("box", 0, 17, 406, 186);
        this.add(box);
        JsonObject json = JsonUtils.tryGet(this.ROOT, holder.path());
        int offsetX = 1;
        int offsetY = 1;
        for (ConfigKey configKey : holder.fields()) {
            if (configKey.requiresRestart) continue;
            Object value = configKey.get();
            String caption = ConfigGuiLayer.translateOrDefault("config." + String.join((CharSequence)".", holder.path()) + "." + configKey.name + ".name", configKey.name);
            String comment = "config." + String.join((CharSequence)".", holder.path()) + "." + configKey.name + ".comment";
            if (value instanceof ICreativeConfigHolder) {
                if (((ICreativeConfigHolder)value).isEmpty(this.side)) continue;
                box.add(new GuiButtonFixed(caption, offsetX, offsetY, 100, 20, x -> this.loadHolder((ICreativeConfigHolder)value)).setTitle((ITextComponent)new StringTextComponent(caption)).setTooltip(new TextBuilder().translateIfCan(comment).build()));
                offsetY += 21;
                continue;
            }
            if (!configKey.is(this.side)) continue;
            GuiLabel label = new GuiLabel(caption + ":", offsetX, offsetY + 2).setTitle((ITextComponent)new StringTextComponent(caption + ":"));
            GuiConfigControl config = new GuiConfigControl((ConfigKey.ConfigKeyField)configKey, 0, offsetY, 100, 16, this.side);
            GuiButton resetButton = (GuiButton)new GuiButtonFixed("r", offsetX + 370, offsetY, 14, 14, x -> {
                config.reset();
                this.changed = true;
            }).setTitle((ITextComponent)new StringTextComponent("r"));
            int labelWidth = 110;
            config.setX(label.getX() + labelWidth + 2);
            config.setWidth(380 - config.getX());
            config.init(json != null ? json.get(configKey.name) : null);
            box.add(label.setTooltip(new TextBuilder().translateIfCan(comment).build()));
            box.add(config);
            box.add(resetButton.setTooltip(new TextBuilder().text("reset to default").build()));
            config.setResetButton(resetButton);
            offsetY += config.getHeight() + 1;
        }
        GuiLeftRightBox lowerBox = new GuiLeftRightBox("lowerBox", 0, 205);
        lowerBox.add(new GuiButton("cancel", 0, 205, x -> {
            this.nextAction = 0;
            this.closeTopLayer();
        }).setTitle((ITextComponent)new TranslationTextComponent("gui.cancel")));
        if (this.side == Dist.DEDICATED_SERVER) {
            lowerBox.add(new GuiButton("client-config", 40, 205, x -> {
                this.nextAction = 1;
                this.closeTopLayer();
            }).setTitle((ITextComponent)new TranslationTextComponent("gui.client-config")));
        }
        lowerBox.addRight(new GuiButton("save", 370, 205, x -> {
            this.nextAction = 0;
            this.savePage();
            this.sendUpdate();
            this.force = true;
            this.closeTopLayer();
        }).setTitle((ITextComponent)new TranslationTextComponent("gui.save")));
        this.add(lowerBox);
        this.reinit();
    }

    public void sendUpdate() {
        if (this.side == Dist.DEDICATED_SERVER) {
            CreativeCore.NETWORK.sendToServer(new ConfigurationChangePacket(this.rootHolder, this.ROOT));
        } else {
            this.rootHolder.load(false, true, JsonUtils.get(this.ROOT, this.rootHolder.path()), Dist.CLIENT);
            CreativeCore.CONFIG_HANDLER.save(Dist.CLIENT);
        }
    }

    @Override
    public void closeTopLayer() {
        if (this.force || !this.changed) {
            if (this.nextAction == 0) {
                super.closeTopLayer();
            } else if (this.nextAction == 1) {
                GuiContainerHandler.openGui(this.getPlayer(), "clientconfig");
            }
        } else {
            GuiDialogHandler.openDialog(this.getParent(), "savechanges", (x, y) -> {
                if (y == DialogGuiLayer.DialogButton.YES) {
                    this.savePage();
                    this.sendUpdate();
                }
                if (y != DialogGuiLayer.DialogButton.CANCEL) {
                    this.force = true;
                    this.closeTopLayer();
                }
            }, DialogGuiLayer.DialogButton.YES, DialogGuiLayer.DialogButton.NO, DialogGuiLayer.DialogButton.CANCEL);
        }
    }

    private static GuiConfigControl getConfigControl(GuiControl control) {
        if (control instanceof GuiConfigControl) {
            return (GuiConfigControl)control;
        }
        if (control.getParent() != null) {
            return ConfigGuiLayer.getConfigControl((GuiControl)((Object)control.getParent()));
        }
        return null;
    }
}

