/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.ArrayUtils;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.gui.controls.layout.GuiLayoutControl;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.event.GuiControlClickEvent;
import team.creative.creativecore.common.gui.event.GuiEvent;
import team.creative.creativecore.common.gui.event.GuiEventManager;
import team.creative.creativecore.common.gui.event.GuiTooltipEvent;
import team.creative.creativecore.common.gui.sync.LayerOpenPacket;
import team.creative.creativecore.common.util.math.geo.Rect;

public abstract class GuiParent
extends GuiControl
implements IGuiParent,
Iterable<GuiControl> {
    private GuiEventManager eventManager;
    private List<GuiControl> controls = new ArrayList<GuiControl>();
    @OnlyIn(value=Dist.CLIENT)
    protected int lastRenderedHeight;

    public GuiParent(String name, int x, int y, int width, int height) {
        super(name, x, y, width, height);
    }

    @Override
    public boolean isClient() {
        return this.getParent().isClient();
    }

    public float getScaleFactor() {
        return 1.0f;
    }

    public double getOffsetY() {
        return 0.0;
    }

    public double getOffsetX() {
        return 0.0;
    }

    @Override
    public Iterator<GuiControl> iterator() {
        return this.controls.iterator();
    }

    public GuiControl get(String name) {
        for (int i = 0; i < this.controls.size(); ++i) {
            GuiControl result;
            if (this.controls.get((int)i).name.equalsIgnoreCase(name)) {
                return this.controls.get(i);
            }
            if (!(this.controls.get(i) instanceof GuiLayoutControl) || (result = ((GuiLayoutControl)this.controls.get(i)).get(name)) == null) continue;
            return result;
        }
        return null;
    }

    public boolean has(String name) {
        for (int i = 0; i < this.controls.size(); ++i) {
            if (!this.controls.get((int)i).name.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public void add(GuiControl control) {
        control.setParent(this);
        this.controls.add(control);
    }

    public void remove(GuiControl control) {
        this.controls.remove(control);
    }

    public void remove(String ... include) {
        this.controls.removeIf(x -> ArrayUtils.contains((Object[])include, (Object)x.name));
    }

    public void removeExclude(String ... exclude) {
        this.controls.removeIf(x -> !ArrayUtils.contains((Object[])exclude, (Object)x.name));
    }

    public boolean isEmpty() {
        return this.controls.isEmpty();
    }

    public void clear() {
        this.controls.clear();
    }

    public int size() {
        return this.controls.size();
    }

    @Override
    public void moveBehind(GuiControl toMove, GuiControl reference) {
        this.controls.remove(toMove);
        int index = this.controls.indexOf(reference);
        if (index != -1 && index < this.controls.size() - 1) {
            this.controls.add(index + 1, toMove);
        } else {
            this.moveBottom(toMove);
        }
    }

    @Override
    public void moveInFront(GuiControl toMove, GuiControl reference) {
        this.controls.remove(toMove);
        int index = this.controls.indexOf(reference);
        if (index != -1) {
            this.controls.add(index, toMove);
        } else {
            this.moveTop(toMove);
        }
    }

    @Override
    public void moveTop(GuiControl toMove) {
        this.controls.remove(toMove);
        this.controls.add(0, toMove);
    }

    @Override
    public void moveBottom(GuiControl toMove) {
        this.controls.remove(toMove);
        this.controls.add(toMove);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void renderContent(MatrixStack matrix, Rect contentRect, Rect realContentRect, int mouseX, int mouseY) {
        if (realContentRect == null) {
            return;
        }
        float scale = this.getScaleFactor();
        double xOffset = this.getOffsetX();
        double yOffset = this.getOffsetY();
        this.lastRenderedHeight = 0;
        for (int i = this.controls.size() - 1; i >= 0; --i) {
            GuiControl control = this.controls.get(i);
            if (!control.visible) continue;
            Rect controlRect = contentRect.child(((double)control.getX() + xOffset) * (double)scale, ((double)control.getY() + yOffset) * (double)scale, (float)control.getWidth() * scale, (float)control.getHeight() * scale);
            Rect realRect = realContentRect.intersection(controlRect);
            if (realRect != null || control.canOverlap()) {
                if (control.canOverlap()) {
                    RenderSystem.disableScissor();
                } else {
                    realRect.scissor();
                }
                matrix.func_227860_a_();
                matrix.func_227861_a_(((double)control.getX() + xOffset) * (double)scale, ((double)control.getY() + yOffset) * (double)scale, 10.0);
                control.render(matrix, controlRect, realRect, mouseX, mouseY);
                matrix.func_227865_b_();
            }
            this.lastRenderedHeight = (int)Math.max((float)this.lastRenderedHeight, (float)(control.getY() + control.getHeight()) * scale);
        }
        super.renderContent(matrix, contentRect, realContentRect, mouseX, mouseY);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void renderContent(MatrixStack matrix, Rect rect, int mouseX, int mouseY) {
    }

    @Override
    public boolean isContainer() {
        return this.getParent().isContainer();
    }

    @Override
    public void init() {
        for (int i = 0; i < this.controls.size(); ++i) {
            this.controls.get(i).init();
        }
    }

    @Override
    public void closed() {
        for (int i = 0; i < this.controls.size(); ++i) {
            this.controls.get(i).closed();
        }
    }

    @Override
    public void tick() {
        for (int i = 0; i < this.controls.size(); ++i) {
            this.controls.get(i).tick();
        }
    }

    @Override
    public void closeTopLayer() {
        this.getParent().closeTopLayer();
    }

    @Override
    public GuiLayer openLayer(LayerOpenPacket packet) {
        return this.getParent().openLayer(packet);
    }

    @Override
    public GuiTooltipEvent getTooltipEvent(double x, double y) {
        GuiTooltipEvent event = super.getTooltipEvent(x, y);
        if (event != null) {
            return event;
        }
        x *= (double)this.getScaleFactor();
        y *= (double)this.getScaleFactor();
        int offset = this.getContentOffset();
        x += -this.getOffsetX() - (double)offset;
        y += -this.getOffsetY() - (double)offset;
        for (int i = 0; i < this.controls.size(); ++i) {
            GuiControl control = this.controls.get(i);
            if (!control.isInteractable() || !control.isMouseOver(x, y) || (event = control.getTooltipEvent(x - (double)control.getX(), y - (double)control.getY())) == null) continue;
            return event;
        }
        return null;
    }

    @Override
    public boolean testForDoubleClick(double x, double y) {
        x *= (double)this.getScaleFactor();
        y *= (double)this.getScaleFactor();
        int offset = this.getContentOffset();
        x += -this.getOffsetX() - (double)offset;
        y += -this.getOffsetY() - (double)offset;
        for (int i = 0; i < this.controls.size(); ++i) {
            GuiControl control = this.controls.get(i);
            if (!control.isInteractable() || !control.testForDoubleClick(x, y)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void mouseMoved(double x, double y) {
        x *= (double)this.getScaleFactor();
        y *= (double)this.getScaleFactor();
        int offset = this.getContentOffset();
        x += -this.getOffsetX() - (double)offset;
        y += -this.getOffsetY() - (double)offset;
        for (int i = 0; i < this.controls.size(); ++i) {
            GuiControl control = this.controls.get(i);
            if (!control.isInteractable()) continue;
            control.mouseMoved(x - (double)control.getX(), y - (double)control.getY());
        }
    }

    @Override
    public boolean mouseClicked(double x, double y, int button) {
        x *= (double)this.getScaleFactor();
        y *= (double)this.getScaleFactor();
        int offset = this.getContentOffset();
        x += -this.getOffsetX() - (double)offset;
        y += -this.getOffsetY() - (double)offset;
        boolean result = false;
        for (int i = 0; i < this.controls.size(); ++i) {
            GuiControl control = this.controls.get(i);
            if (!result && control.isInteractable() && control.isMouseOver(x, y) && control.mouseClicked(x - (double)control.getX(), y - (double)control.getY(), button)) {
                this.raiseEvent(new GuiControlClickEvent(control, button, false));
                result = true;
                continue;
            }
            control.looseFocus();
        }
        return result;
    }

    @Override
    public boolean mouseDoubleClicked(double x, double y, int button) {
        x *= (double)this.getScaleFactor();
        y *= (double)this.getScaleFactor();
        int offset = this.getContentOffset();
        x += -this.getOffsetX() - (double)offset;
        y += -this.getOffsetY() - (double)offset;
        boolean result = false;
        for (int i = 0; i < this.controls.size(); ++i) {
            GuiControl control = this.controls.get(i);
            if (!result && control.isInteractable() && control.isMouseOver(x, y) && control.mouseDoubleClicked(x - (double)control.getX(), y - (double)control.getY(), button)) {
                this.raiseEvent(new GuiControlClickEvent(control, button, false));
                result = true;
                continue;
            }
            control.looseFocus();
        }
        return result;
    }

    @Override
    public void mouseReleased(double x, double y, int button) {
        x *= (double)this.getScaleFactor();
        y *= (double)this.getScaleFactor();
        int offset = this.getContentOffset();
        x += -this.getOffsetX() - (double)offset;
        y += -this.getOffsetY() - (double)offset;
        for (int i = 0; i < this.controls.size(); ++i) {
            GuiControl control = this.controls.get(i);
            if (!control.isInteractable()) continue;
            control.mouseReleased(x - (double)control.getX(), y - (double)control.getY(), button);
        }
    }

    @Override
    public void mouseDragged(double x, double y, int button, double dragX, double dragY, double time) {
        x *= (double)this.getScaleFactor();
        y *= (double)this.getScaleFactor();
        int offset = this.getContentOffset();
        x += -this.getOffsetX() - (double)offset;
        y += -this.getOffsetY() - (double)offset;
        for (int i = 0; i < this.controls.size(); ++i) {
            GuiControl control = this.controls.get(i);
            if (!control.isInteractable()) continue;
            control.mouseDragged(x - (double)control.getX(), y - (double)control.getY(), button, dragX, dragY, time);
        }
    }

    @Override
    public boolean mouseScrolled(double x, double y, double delta) {
        x *= (double)this.getScaleFactor();
        y *= (double)this.getScaleFactor();
        int offset = this.getContentOffset();
        x += -this.getOffsetX() - (double)offset;
        y += -this.getOffsetY() - (double)offset;
        for (int i = 0; i < this.controls.size(); ++i) {
            GuiControl control = this.controls.get(i);
            if (!control.isInteractable() || !control.isMouseOver(x, y) || !control.mouseScrolled(x - (double)control.getX(), y - (double)control.getY(), delta)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        for (int i = 0; i < this.controls.size(); ++i) {
            GuiControl control = this.controls.get(i);
            if (!control.isInteractable() || !control.keyPressed(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        for (int i = 0; i < this.controls.size(); ++i) {
            GuiControl control = this.controls.get(i);
            if (!control.isInteractable() || !control.keyReleased(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean charTyped(char codePoint, int modifiers) {
        for (int i = 0; i < this.controls.size(); ++i) {
            GuiControl control = this.controls.get(i);
            if (!control.isInteractable() || !control.charTyped(codePoint, modifiers)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void looseFocus() {
        for (int i = 0; i < this.controls.size(); ++i) {
            this.controls.get(i).looseFocus();
        }
    }

    @Override
    public void raiseEvent(GuiEvent event) {
        if (this.getParent() == null) {
            return;
        }
        if (this.eventManager != null) {
            this.eventManager.raiseEvent(event);
        }
        if (!event.isCanceled()) {
            this.getParent().raiseEvent(event);
        }
    }

    public void registerEventClick(Consumer<GuiControlClickEvent> consumer) {
        this.registerEvent(GuiControlClickEvent.class, consumer);
    }

    public void registerEventChanged(Consumer<GuiControlChangedEvent> consumer) {
        this.registerEvent(GuiControlChangedEvent.class, consumer);
    }

    public <T extends GuiEvent> void registerEvent(Class<T> clazz, Consumer<T> action) {
        if (this.eventManager == null) {
            this.eventManager = new GuiEventManager();
        }
        this.eventManager.registerEvent(clazz, action);
    }

    @Override
    public void updateLayout() {
        super.updateLayout();
        for (int i = 0; i < this.controls.size(); ++i) {
            this.controls.get(i).updateLayout();
        }
    }
}

