/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.world;

import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.IChunkLightProvider;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import team.creative.creativecore.common.world.CreativeWorld;

public class ChunkProviderFake
extends AbstractChunkProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Chunk emptyChunk;
    private final WorldLightManager lightEngine;
    private volatile ChunkArray storage;
    public final CreativeWorld world;

    public ChunkProviderFake(CreativeWorld world, int radius) {
        this.world = world;
        this.emptyChunk = new EmptyChunk((World)world, new ChunkPos(0, 0));
        this.lightEngine = new WorldLightManager((IChunkLightProvider)this, true, world.func_230315_m_().func_218272_d());
        this.storage = new ChunkArray(ChunkProviderFake.calculateStorageRange(radius));
    }

    private static boolean isValidChunk(@Nullable Chunk p_217249_0_, int p_217249_1_, int p_217249_2_) {
        if (p_217249_0_ == null) {
            return false;
        }
        ChunkPos chunkpos = p_217249_0_.func_76632_l();
        return chunkpos.field_77276_a == p_217249_1_ && chunkpos.field_77275_b == p_217249_2_;
    }

    public void drop(int p_73234_1_, int p_73234_2_) {
        int i;
        Chunk chunk;
        if (this.storage.inRange(p_73234_1_, p_73234_2_) && ChunkProviderFake.isValidChunk(chunk = this.storage.getChunk(i = this.storage.getIndex(p_73234_1_, p_73234_2_)), p_73234_1_, p_73234_2_)) {
            MinecraftForge.EVENT_BUS.post((Event)new ChunkEvent.Unload((IChunk)chunk));
            this.storage.replace(i, chunk, null);
        }
    }

    @Nullable
    public Chunk getChunk(int p_212849_1_, int p_212849_2_, ChunkStatus p_212849_3_, boolean p_212849_4_) {
        Chunk chunk;
        if (this.storage.inRange(p_212849_1_, p_212849_2_) && ChunkProviderFake.isValidChunk(chunk = this.storage.getChunk(this.storage.getIndex(p_212849_1_, p_212849_2_)), p_212849_1_, p_212849_2_)) {
            return chunk;
        }
        return p_212849_4_ ? this.emptyChunk : null;
    }

    public IBlockReader func_212864_k_() {
        return this.world;
    }

    @Nullable
    public Chunk replaceWithPacketData(int p_228313_1_, int p_228313_2_, @Nullable BiomeContainer p_228313_3_, PacketBuffer p_228313_4_, CompoundNBT p_228313_5_, int p_228313_6_, boolean p_228313_7_) {
        if (!this.storage.inRange(p_228313_1_, p_228313_2_)) {
            LOGGER.warn("Ignoring chunk since it's not in the view range: {}, {}", (Object)p_228313_1_, (Object)p_228313_2_);
            return null;
        }
        int i = this.storage.getIndex(p_228313_1_, p_228313_2_);
        Chunk chunk = (Chunk)this.storage.chunks.get(i);
        if (!p_228313_7_ && ChunkProviderFake.isValidChunk(chunk, p_228313_1_, p_228313_2_)) {
            chunk.func_227073_a_(p_228313_3_, p_228313_4_, p_228313_5_, p_228313_6_);
        } else {
            if (p_228313_3_ == null) {
                LOGGER.warn("Ignoring chunk since we don't have complete data: {}, {}", (Object)p_228313_1_, (Object)p_228313_2_);
                return null;
            }
            chunk = new Chunk((World)this.world, new ChunkPos(p_228313_1_, p_228313_2_), p_228313_3_);
            chunk.func_227073_a_(p_228313_3_, p_228313_4_, p_228313_5_, p_228313_6_);
            this.storage.replace(i, chunk);
        }
        ChunkSection[] achunksection = chunk.func_76587_i();
        WorldLightManager worldlightmanager = this.func_212863_j_();
        worldlightmanager.func_215571_a(new ChunkPos(p_228313_1_, p_228313_2_), true);
        for (int j = 0; j < achunksection.length; ++j) {
            ChunkSection chunksection = achunksection[j];
            worldlightmanager.func_215566_a(SectionPos.func_218154_a((int)p_228313_1_, (int)j, (int)p_228313_2_), ChunkSection.func_222628_a((ChunkSection)chunksection));
        }
        this.world.onChunkLoaded(p_228313_1_, p_228313_2_);
        MinecraftForge.EVENT_BUS.post((Event)new ChunkEvent.Load((IChunk)chunk));
        return chunk;
    }

    public void func_217207_a(BooleanSupplier p_217207_1_) {
    }

    public void updateViewCenter(int p_217251_1_, int p_217251_2_) {
        this.storage.viewCenterX = p_217251_1_;
        this.storage.viewCenterZ = p_217251_2_;
    }

    public void updateViewRadius(int p_217248_1_) {
        int j;
        int i = this.storage.chunkRadius;
        if (i != (j = ChunkProviderFake.calculateStorageRange(p_217248_1_))) {
            ChunkArray clientchunkprovider$chunkarray = new ChunkArray(j);
            clientchunkprovider$chunkarray.viewCenterX = this.storage.viewCenterX;
            clientchunkprovider$chunkarray.viewCenterZ = this.storage.viewCenterZ;
            for (int k = 0; k < this.storage.chunks.length(); ++k) {
                Chunk chunk = (Chunk)this.storage.chunks.get(k);
                if (chunk == null) continue;
                ChunkPos chunkpos = chunk.func_76632_l();
                if (!clientchunkprovider$chunkarray.inRange(chunkpos.field_77276_a, chunkpos.field_77275_b)) continue;
                clientchunkprovider$chunkarray.replace(clientchunkprovider$chunkarray.getIndex(chunkpos.field_77276_a, chunkpos.field_77275_b), chunk);
            }
            this.storage = clientchunkprovider$chunkarray;
        }
    }

    private static int calculateStorageRange(int p_217254_0_) {
        return Math.max(2, p_217254_0_) + 3;
    }

    public String func_73148_d() {
        return "Client Chunk Cache: " + this.storage.chunks.length() + ", " + this.getLoadedChunksCount();
    }

    public int getLoadedChunksCount() {
        return this.storage.chunkCount;
    }

    public void func_217201_a(LightType p_217201_1_, SectionPos p_217201_2_) {
        Minecraft.func_71410_x().field_71438_f.func_215328_b(p_217201_2_.func_218149_a(), p_217201_2_.func_218163_b(), p_217201_2_.func_218148_c());
    }

    public boolean func_222866_a(BlockPos p_222866_1_) {
        return this.func_73149_a(p_222866_1_.func_177958_n() >> 4, p_222866_1_.func_177952_p() >> 4);
    }

    public boolean func_222865_a(ChunkPos p_222865_1_) {
        return this.func_73149_a(p_222865_1_.field_77276_a, p_222865_1_.field_77275_b);
    }

    public boolean func_217204_a(Entity p_217204_1_) {
        return this.func_73149_a(MathHelper.func_76128_c((double)p_217204_1_.func_226277_ct_()) >> 4, MathHelper.func_76128_c((double)p_217204_1_.func_226281_cx_()) >> 4);
    }

    public WorldLightManager func_212863_j_() {
        return this.lightEngine;
    }

    @OnlyIn(value=Dist.CLIENT)
    final class ChunkArray {
        private final AtomicReferenceArray<Chunk> chunks;
        private final int chunkRadius;
        private final int viewRange;
        private volatile int viewCenterX;
        private volatile int viewCenterZ;
        private int chunkCount;

        private ChunkArray(int p_i50568_2_) {
            this.chunkRadius = p_i50568_2_;
            this.viewRange = p_i50568_2_ * 2 + 1;
            this.chunks = new AtomicReferenceArray(this.viewRange * this.viewRange);
        }

        private int getIndex(int p_217191_1_, int p_217191_2_) {
            return Math.floorMod(p_217191_2_, this.viewRange) * this.viewRange + Math.floorMod(p_217191_1_, this.viewRange);
        }

        protected void replace(int p_217181_1_, @Nullable Chunk p_217181_2_) {
            Chunk chunk = this.chunks.getAndSet(p_217181_1_, p_217181_2_);
            if (chunk != null) {
                --this.chunkCount;
                ChunkProviderFake.this.world.unload(chunk);
            }
            if (p_217181_2_ != null) {
                ++this.chunkCount;
            }
        }

        protected Chunk replace(int p_217190_1_, Chunk p_217190_2_, @Nullable Chunk p_217190_3_) {
            if (this.chunks.compareAndSet(p_217190_1_, p_217190_2_, p_217190_3_) && p_217190_3_ == null) {
                --this.chunkCount;
            }
            ChunkProviderFake.this.world.unload(p_217190_2_);
            return p_217190_2_;
        }

        private boolean inRange(int p_217183_1_, int p_217183_2_) {
            return Math.abs(p_217183_1_ - this.viewCenterX) <= this.chunkRadius && Math.abs(p_217183_2_ - this.viewCenterZ) <= this.chunkRadius;
        }

        @Nullable
        protected Chunk getChunk(int p_217192_1_) {
            return this.chunks.get(p_217192_1_);
        }
    }
}

