/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.turtle;

import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.common.util.NonNullSupplier;

public abstract class AbstractTurtleUpgrade
implements ITurtleUpgrade {
    private final ResourceLocation id;
    private final TurtleUpgradeType type;
    private final String adjective;
    private final NonNullSupplier<ItemStack> stack;

    protected AbstractTurtleUpgrade(ResourceLocation id, TurtleUpgradeType type, String adjective, NonNullSupplier<ItemStack> stack) {
        this.id = id;
        this.type = type;
        this.adjective = adjective;
        this.stack = stack;
    }

    protected AbstractTurtleUpgrade(ResourceLocation id, TurtleUpgradeType type, NonNullSupplier<ItemStack> stack) {
        this(id, type, Util.func_200697_a((String)"upgrade", (ResourceLocation)id) + ".adjective", stack);
    }

    protected AbstractTurtleUpgrade(ResourceLocation id, TurtleUpgradeType type, String adjective, ItemStack stack) {
        this(id, type, adjective, (NonNullSupplier<ItemStack>)((NonNullSupplier)() -> stack));
    }

    protected AbstractTurtleUpgrade(ResourceLocation id, TurtleUpgradeType type, ItemStack stack) {
        this(id, type, (NonNullSupplier<ItemStack>)((NonNullSupplier)() -> stack));
    }

    protected AbstractTurtleUpgrade(ResourceLocation id, TurtleUpgradeType type, String adjective, IItemProvider item) {
        this(id, type, adjective, new CachedStack(() -> item));
    }

    protected AbstractTurtleUpgrade(ResourceLocation id, TurtleUpgradeType type, IItemProvider item) {
        this(id, type, new CachedStack(() -> item));
    }

    protected AbstractTurtleUpgrade(ResourceLocation id, TurtleUpgradeType type, String adjective, Supplier<? extends IItemProvider> item) {
        this(id, type, adjective, new CachedStack(item));
    }

    protected AbstractTurtleUpgrade(ResourceLocation id, TurtleUpgradeType type, Supplier<? extends IItemProvider> item) {
        this(id, type, new CachedStack(item));
    }

    @Override
    @Nonnull
    public final ResourceLocation getUpgradeID() {
        return this.id;
    }

    @Override
    @Nonnull
    public final String getUnlocalisedAdjective() {
        return this.adjective;
    }

    @Override
    @Nonnull
    public final TurtleUpgradeType getType() {
        return this.type;
    }

    @Override
    @Nonnull
    public final ItemStack getCraftingItem() {
        return (ItemStack)this.stack.get();
    }

    private static final class CachedStack
    implements NonNullSupplier<ItemStack> {
        private final Supplier<? extends IItemProvider> provider;
        private Item item;
        private ItemStack stack;

        CachedStack(Supplier<? extends IItemProvider> provider) {
            this.provider = provider;
        }

        @Nonnull
        public ItemStack get() {
            Item item = this.provider.get().func_199767_j();
            if (item == this.item && this.stack != null) {
                return this.stack;
            }
            this.item = item;
            this.stack = new ItemStack((IItemProvider)this.item);
            return this.stack;
        }
    }
}

