/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.data;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

final class RecipeWrapper
implements Consumer<IFinishedRecipe> {
    private final Consumer<IFinishedRecipe> add;
    private final IRecipeSerializer<?> serializer;
    private final List<Consumer<JsonObject>> extend = new ArrayList<Consumer<JsonObject>>(0);

    RecipeWrapper(Consumer<IFinishedRecipe> add, IRecipeSerializer<?> serializer) {
        this.add = add;
        this.serializer = serializer;
    }

    public static RecipeWrapper wrap(IRecipeSerializer<?> serializer, Consumer<IFinishedRecipe> original) {
        return new RecipeWrapper(original, serializer);
    }

    public RecipeWrapper withExtraData(Consumer<JsonObject> extra) {
        this.extend.add(extra);
        return this;
    }

    public RecipeWrapper withResultTag(@Nullable CompoundNBT resultTag) {
        if (resultTag == null) {
            return this;
        }
        this.extend.add(json -> {
            JsonObject object = JSONUtils.func_152754_s((JsonObject)json, (String)"result");
            object.addProperty("nbt", resultTag.toString());
        });
        return this;
    }

    public RecipeWrapper withResultTag(Consumer<CompoundNBT> resultTag) {
        CompoundNBT tag = new CompoundNBT();
        resultTag.accept(tag);
        return this.withResultTag(tag);
    }

    @Override
    public void accept(IFinishedRecipe finishedRecipe) {
        this.add.accept(new RecipeImpl(finishedRecipe, this.serializer, this.extend));
    }

    private static final class RecipeImpl
    implements IFinishedRecipe {
        private final IFinishedRecipe recipe;
        private final IRecipeSerializer<?> serializer;
        private final List<Consumer<JsonObject>> extend;

        private RecipeImpl(IFinishedRecipe recipe, IRecipeSerializer<?> serializer, List<Consumer<JsonObject>> extend) {
            this.recipe = recipe;
            this.serializer = serializer;
            this.extend = extend;
        }

        public void func_218610_a(@Nonnull JsonObject jsonObject) {
            this.recipe.func_218610_a(jsonObject);
            for (Consumer<JsonObject> extender : this.extend) {
                extender.accept(jsonObject);
            }
        }

        @Nonnull
        public ResourceLocation func_200442_b() {
            return this.recipe.func_200442_b();
        }

        @Nonnull
        public IRecipeSerializer<?> func_218609_c() {
            return this.serializer;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return this.recipe.func_200440_c();
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return this.recipe.func_200443_d();
        }
    }
}

