/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.items;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.shared.computer.blocks.BlockComputerBase;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.items.IComputerItem;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public abstract class ItemComputerBase
extends BlockItem
implements IComputerItem,
IMedia {
    private final ComputerFamily family;

    public ItemComputerBase(BlockComputerBase<?> block, Item.Properties settings) {
        super(block, settings);
        this.family = block.getFamily();
    }

    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<ITextComponent> list, @Nonnull ITooltipFlag options) {
        int id;
        if ((options.func_194127_a() || this.getLabel(stack) == null) && (id = this.getComputerID(stack)) >= 0) {
            list.add((ITextComponent)new TranslationTextComponent("gui.computercraft.tooltip.computer_id", new Object[]{id}).func_240699_a_(TextFormatting.GRAY));
        }
    }

    @Override
    public String getLabel(@Nonnull ItemStack stack) {
        return IComputerItem.super.getLabel(stack);
    }

    @Override
    public final ComputerFamily getFamily() {
        return this.family;
    }

    @Override
    public boolean setLabel(@Nonnull ItemStack stack, String label) {
        if (label != null) {
            stack.func_200302_a((ITextComponent)new StringTextComponent(label));
        } else {
            stack.func_135074_t();
        }
        return true;
    }

    @Override
    public IMount createDataMount(@Nonnull ItemStack stack, @Nonnull World world) {
        int id;
        ComputerFamily family = this.getFamily();
        if (family != ComputerFamily.COMMAND && (id = this.getComputerID(stack)) >= 0) {
            return ComputerCraftAPI.createSaveDirMount(world, "computer/" + id, ComputerCraft.computerSpaceLimit);
        }
        return null;
    }
}

