/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.recipe;

import com.google.gson.JsonObject;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.recipe.ComputerConvertRecipe;
import dan200.computercraft.shared.util.BasicRecipeSerializer;
import dan200.computercraft.shared.util.RecipeUtil;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public abstract class ComputerFamilyRecipe
extends ComputerConvertRecipe {
    private final ComputerFamily family;

    public ComputerFamilyRecipe(ResourceLocation identifier, String group, int width, int height, NonNullList<Ingredient> ingredients, ItemStack result, ComputerFamily family) {
        super(identifier, group, width, height, ingredients, result);
        this.family = family;
    }

    public ComputerFamily getFamily() {
        return this.family;
    }

    public static abstract class Serializer<T extends ComputerFamilyRecipe>
    extends BasicRecipeSerializer<T> {
        protected abstract T create(ResourceLocation var1, String var2, int var3, int var4, NonNullList<Ingredient> var5, ItemStack var6, ComputerFamily var7);

        @Nonnull
        public T fromJson(@Nonnull ResourceLocation identifier, @Nonnull JsonObject json) {
            String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            ComputerFamily family = RecipeUtil.getFamily(json, "family");
            RecipeUtil.ShapedTemplate template = RecipeUtil.getTemplate(json);
            ItemStack result = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            return this.create(identifier, group, template.width, template.height, template.ingredients, result, family);
        }

        @Nonnull
        public T fromNetwork(@Nonnull ResourceLocation identifier, @Nonnull PacketBuffer buf) {
            int width = buf.func_150792_a();
            int height = buf.func_150792_a();
            String group = buf.func_150789_c(Short.MAX_VALUE);
            NonNullList ingredients = NonNullList.func_191197_a((int)(width * height), (Object)Ingredient.field_193370_a);
            for (int i = 0; i < ingredients.size(); ++i) {
                ingredients.set(i, (Object)Ingredient.func_199566_b((PacketBuffer)buf));
            }
            ItemStack result = buf.func_150791_c();
            ComputerFamily family = (ComputerFamily)buf.func_179257_a(ComputerFamily.class);
            return this.create(identifier, group, width, height, (NonNullList<Ingredient>)ingredients, result, family);
        }

        public void toNetwork(@Nonnull PacketBuffer buf, @Nonnull T recipe) {
            buf.func_150787_b(recipe.func_192403_f());
            buf.func_150787_b(recipe.func_192404_g());
            buf.func_180714_a(((ComputerConvertRecipe)((Object)recipe)).func_193358_e());
            for (Ingredient ingredient : recipe.func_192400_c()) {
                ingredient.func_199564_a(buf);
            }
            buf.func_150788_a(recipe.func_77571_b());
            buf.func_179249_a((Enum)((ComputerFamilyRecipe)((Object)recipe)).getFamily());
        }
    }
}

