/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.integration;

import dan200.computercraft.shared.PocketUpgrades;
import dan200.computercraft.shared.TurtleUpgrades;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.pocket.items.PocketComputerItemFactory;
import dan200.computercraft.shared.turtle.items.TurtleItemFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public final class RecipeModHelpers {
    static final List<ComputerFamily> MAIN_FAMILIES = Arrays.asList(ComputerFamily.NORMAL, ComputerFamily.ADVANCED);

    private RecipeModHelpers() {
    }

    public static boolean shouldRemoveRecipe(ResourceLocation id) {
        if (!id.func_110624_b().equals("computercraft")) {
            return false;
        }
        String path = id.func_110623_a();
        return path.startsWith("turtle_normal/") || path.startsWith("turtle_advanced/") || path.startsWith("pocket_normal/") || path.startsWith("pocket_advanced/");
    }

    public static List<ItemStack> getExtraStacks() {
        ArrayList<ItemStack> upgradeItems = new ArrayList<ItemStack>();
        for (ComputerFamily family : MAIN_FAMILIES) {
            TurtleUpgrades.getUpgrades().forEach(upgrade -> upgradeItems.add(TurtleItemFactory.create(-1, null, -1, family, null, upgrade, 0, null)));
            PocketUpgrades.getUpgrades().forEach(upgrade -> upgradeItems.add(PocketComputerItemFactory.create(-1, null, -1, family, upgrade)));
        }
        return upgradeItems;
    }
}

