/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.generic.methods;

import dan200.computercraft.api.lua.LuaException;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

final class ArgumentHelpers {
    private ArgumentHelpers() {
    }

    public static void assertBetween(double value, double min, double max, String message) throws LuaException {
        if (value < min || value > max || Double.isNaN(value)) {
            throw new LuaException(String.format(message, "between " + min + " and " + max));
        }
    }

    public static void assertBetween(int value, int min, int max, String message) throws LuaException {
        if (value < min || value > max) {
            throw new LuaException(String.format(message, "between " + min + " and " + max));
        }
    }

    @Nonnull
    public static <T extends IForgeRegistryEntry<T>> T getRegistryEntry(String name, String typeName, IForgeRegistry<T> registry) throws LuaException {
        IForgeRegistryEntry value;
        ResourceLocation id;
        try {
            id = new ResourceLocation(name);
        }
        catch (ResourceLocationException e) {
            id = null;
        }
        if (id == null || !registry.containsKey(id) || (value = registry.getValue(id)) == null) {
            throw new LuaException(String.format("Unknown %s '%s'", typeName, name));
        }
        return (T)value;
    }
}

