/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wired;

import com.google.common.collect.ImmutableMap;
import dan200.computercraft.shared.peripheral.modem.ModemShapes;
import dan200.computercraft.shared.peripheral.modem.wired.BlockCable;
import dan200.computercraft.shared.peripheral.modem.wired.CableModemVariant;
import dan200.computercraft.shared.util.DirectionUtil;
import java.util.EnumMap;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;

public final class CableShapes {
    private static final double MIN = 0.375;
    private static final double MAX = 0.625;
    private static final VoxelShape SHAPE_CABLE_CORE = VoxelShapes.func_197873_a((double)0.375, (double)0.375, (double)0.375, (double)0.625, (double)0.625, (double)0.625);
    private static final EnumMap<Direction, VoxelShape> SHAPE_CABLE_ARM = new EnumMap(new ImmutableMap.Builder().put((Object)Direction.DOWN, (Object)VoxelShapes.func_197873_a((double)0.375, (double)0.0, (double)0.375, (double)0.625, (double)0.375, (double)0.625)).put((Object)Direction.UP, (Object)VoxelShapes.func_197873_a((double)0.375, (double)0.625, (double)0.375, (double)0.625, (double)1.0, (double)0.625)).put((Object)Direction.NORTH, (Object)VoxelShapes.func_197873_a((double)0.375, (double)0.375, (double)0.0, (double)0.625, (double)0.625, (double)0.375)).put((Object)Direction.SOUTH, (Object)VoxelShapes.func_197873_a((double)0.375, (double)0.375, (double)0.625, (double)0.625, (double)0.625, (double)1.0)).put((Object)Direction.WEST, (Object)VoxelShapes.func_197873_a((double)0.0, (double)0.375, (double)0.375, (double)0.375, (double)0.625, (double)0.625)).put((Object)Direction.EAST, (Object)VoxelShapes.func_197873_a((double)0.625, (double)0.375, (double)0.375, (double)1.0, (double)0.625, (double)0.625)).build());
    private static final VoxelShape[] SHAPES = new VoxelShape[448];
    private static final VoxelShape[] CABLE_SHAPES = new VoxelShape[64];

    private CableShapes() {
    }

    private static int getCableIndex(BlockState state) {
        int index = 0;
        for (Direction facing : DirectionUtil.FACINGS) {
            if (!((Boolean)state.func_177229_b((Property)BlockCable.CONNECTIONS.get(facing))).booleanValue()) continue;
            index |= 1 << facing.ordinal();
        }
        return index;
    }

    private static VoxelShape getCableShape(int index) {
        VoxelShape shape = CABLE_SHAPES[index];
        if (shape != null) {
            return shape;
        }
        shape = SHAPE_CABLE_CORE;
        for (Direction facing : DirectionUtil.FACINGS) {
            if ((index & 1 << facing.ordinal()) == 0) continue;
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)SHAPE_CABLE_ARM.get(facing));
        }
        CableShapes.CABLE_SHAPES[index] = shape;
        return CableShapes.CABLE_SHAPES[index];
    }

    public static VoxelShape getCableShape(BlockState state) {
        if (!((Boolean)state.func_177229_b((Property)BlockCable.CABLE)).booleanValue()) {
            return VoxelShapes.func_197880_a();
        }
        return CableShapes.getCableShape(CableShapes.getCableIndex(state));
    }

    public static VoxelShape getModemShape(BlockState state) {
        Direction facing = ((CableModemVariant)((Object)state.func_177229_b(BlockCable.MODEM))).getFacing();
        return facing == null ? VoxelShapes.func_197880_a() : ModemShapes.getBounds(facing);
    }

    public static VoxelShape getShape(BlockState state) {
        Direction facing = ((CableModemVariant)((Object)state.func_177229_b(BlockCable.MODEM))).getFacing();
        if (!((Boolean)state.func_177229_b((Property)BlockCable.CABLE)).booleanValue()) {
            return CableShapes.getModemShape(state);
        }
        int cableIndex = CableShapes.getCableIndex(state);
        int index = cableIndex + ((facing == null ? 0 : facing.ordinal() + 1) << 6);
        VoxelShape shape = SHAPES[index];
        if (shape != null) {
            return shape;
        }
        shape = CableShapes.getCableShape(cableIndex);
        if (facing != null) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)ModemShapes.getBounds(facing));
        }
        CableShapes.SHAPES[index] = shape;
        return CableShapes.SHAPES[index];
    }
}

