/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.core;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.common.IColouredItem;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.network.NetworkHandler;
import dan200.computercraft.shared.network.client.PocketComputerDataMessage;
import dan200.computercraft.shared.network.client.PocketComputerDeletedClientMessage;
import dan200.computercraft.shared.pocket.items.ItemPocketComputer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;

public class PocketServerComputer
extends ServerComputer
implements IPocketAccess {
    private IPocketUpgrade upgrade;
    private Entity entity;
    private ItemStack stack;
    private int lightColour = -1;
    private boolean lightChanged = false;
    private final Set<ServerPlayerEntity> tracking = new HashSet<ServerPlayerEntity>();

    public PocketServerComputer(ServerWorld world, int computerID, String label, ComputerFamily family) {
        super(world, computerID, label, family, ComputerCraft.pocketTermWidth, ComputerCraft.pocketTermHeight);
    }

    @Override
    @Nullable
    public Entity getEntity() {
        Entity entity = this.entity;
        if (entity == null || this.stack == null || !entity.func_70089_S()) {
            return null;
        }
        if (entity instanceof PlayerEntity) {
            PlayerInventory inventory = ((PlayerEntity)entity).field_71071_by;
            return inventory.field_70462_a.contains((Object)this.stack) || inventory.field_184439_c.contains((Object)this.stack) ? entity : null;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            return living.func_184614_ca() == this.stack || living.func_184592_cb() == this.stack ? entity : null;
        }
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            return itemEntity.func_92059_d() == this.stack ? entity : null;
        }
        return null;
    }

    @Override
    public int getColour() {
        return IColouredItem.getColourBasic(this.stack);
    }

    @Override
    public void setColour(int colour) {
        IColouredItem.setColourBasic(this.stack, colour);
        this.updateUpgradeNBTData();
    }

    @Override
    public int getLight() {
        return this.lightColour;
    }

    @Override
    public void setLight(int colour) {
        if (colour < 0 || colour > 0xFFFFFF) {
            colour = -1;
        }
        if (this.lightColour == colour) {
            return;
        }
        this.lightColour = colour;
        this.lightChanged = true;
    }

    @Override
    @Nonnull
    public CompoundNBT getUpgradeNBTData() {
        return ItemPocketComputer.getUpgradeInfo(this.stack);
    }

    @Override
    public void updateUpgradeNBTData() {
        if (this.entity instanceof PlayerEntity) {
            ((PlayerEntity)this.entity).field_71071_by.func_70296_d();
        }
    }

    @Override
    public void invalidatePeripheral() {
        IPeripheral peripheral = this.upgrade == null ? null : this.upgrade.createPeripheral(this);
        this.setPeripheral(ComputerSide.BACK, peripheral);
    }

    @Override
    @Nonnull
    public Map<ResourceLocation, IPeripheral> getUpgrades() {
        return this.upgrade == null ? Collections.emptyMap() : Collections.singletonMap(this.upgrade.getUpgradeID(), this.getPeripheral(ComputerSide.BACK));
    }

    public IPocketUpgrade getUpgrade() {
        return this.upgrade;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUpgrade(IPocketUpgrade upgrade) {
        if (this.upgrade == upgrade) {
            return;
        }
        PocketServerComputer pocketServerComputer = this;
        synchronized (pocketServerComputer) {
            ItemPocketComputer.setUpgrade(this.stack, upgrade);
            this.updateUpgradeNBTData();
            this.upgrade = upgrade;
            this.invalidatePeripheral();
        }
    }

    public synchronized void updateValues(Entity entity, @Nonnull ItemStack stack, IPocketUpgrade upgrade) {
        if (entity != null) {
            this.setWorld((ServerWorld)entity.func_130014_f_());
            this.setPosition(entity.func_233580_cy_());
        }
        if (entity != this.entity && entity instanceof ServerPlayerEntity) {
            this.markTerminalChanged();
        }
        this.entity = entity;
        this.stack = stack;
        if (this.upgrade != upgrade) {
            this.upgrade = upgrade;
            this.invalidatePeripheral();
        }
    }

    @Override
    public void tickServer() {
        super.tickServer();
        this.tracking.removeIf(player -> !player.func_70089_S() || player.field_70170_p != this.getWorld());
        boolean sendState = this.hasOutputChanged() || this.lightChanged;
        this.lightChanged = false;
        if (sendState) {
            this.tracking.addAll(this.getWorld().func_217369_A());
            NetworkHandler.sendToPlayers(new PocketComputerDataMessage(this, false), this.tracking);
        } else {
            ArrayList<ServerPlayerEntity> added = new ArrayList<ServerPlayerEntity>();
            for (ServerPlayerEntity player2 : this.getWorld().func_217369_A()) {
                if (!this.tracking.add(player2)) continue;
                added.add(player2);
            }
            if (!added.isEmpty()) {
                NetworkHandler.sendToPlayers(new PocketComputerDataMessage(this, false), added);
            }
        }
    }

    @Override
    protected void onTerminalChanged() {
        super.onTerminalChanged();
        if (this.entity instanceof ServerPlayerEntity && this.entity.func_70089_S()) {
            NetworkHandler.sendToPlayer((ServerPlayerEntity)this.entity, new PocketComputerDataMessage(this, true));
        }
    }

    @Override
    protected void onRemoved() {
        super.onRemoved();
        NetworkHandler.sendToAllPlayers(new PocketComputerDeletedClientMessage(this.getInstanceID()));
    }
}

