/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.event.TurtleAction;
import dan200.computercraft.api.turtle.event.TurtleActionEvent;
import dan200.computercraft.shared.turtle.core.TurnDirection;
import javax.annotation.Nonnull;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class TurtleTurnCommand
implements ITurtleCommand {
    private final TurnDirection direction;

    public TurtleTurnCommand(TurnDirection direction) {
        this.direction = direction;
    }

    @Override
    @Nonnull
    public TurtleCommandResult execute(@Nonnull ITurtleAccess turtle) {
        TurtleActionEvent event = new TurtleActionEvent(turtle, TurtleAction.TURN);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return TurtleCommandResult.failure(event.getFailureMessage());
        }
        switch (this.direction) {
            case LEFT: {
                turtle.setDirection(turtle.getDirection().func_176735_f());
                turtle.playAnimation(TurtleAnimation.TURN_LEFT);
                return TurtleCommandResult.success();
            }
            case RIGHT: {
                turtle.setDirection(turtle.getDirection().func_176746_e());
                turtle.playAnimation(TurtleAnimation.TURN_RIGHT);
                return TurtleCommandResult.success();
            }
        }
        return TurtleCommandResult.failure("Unknown direction");
    }
}

