/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.items;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.turtle.blocks.ITurtleTile;
import dan200.computercraft.shared.turtle.items.ItemTurtle;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public final class TurtleItemFactory {
    private TurtleItemFactory() {
    }

    @Nonnull
    public static ItemStack create(ITurtleTile turtle) {
        ITurtleAccess access = turtle.getAccess();
        return TurtleItemFactory.create(turtle.getComputerID(), turtle.getLabel(), turtle.getColour(), turtle.getFamily(), access.getUpgrade(TurtleSide.LEFT), access.getUpgrade(TurtleSide.RIGHT), access.getFuelLevel(), turtle.getOverlay());
    }

    @Nonnull
    public static ItemStack create(int id, String label, int colour, ComputerFamily family, ITurtleUpgrade leftUpgrade, ITurtleUpgrade rightUpgrade, int fuelLevel, ResourceLocation overlay) {
        switch (family) {
            case NORMAL: {
                return ((ItemTurtle)Registry.ModItems.TURTLE_NORMAL.get()).create(id, label, colour, leftUpgrade, rightUpgrade, fuelLevel, overlay);
            }
            case ADVANCED: {
                return ((ItemTurtle)Registry.ModItems.TURTLE_ADVANCED.get()).create(id, label, colour, leftUpgrade, rightUpgrade, fuelLevel, overlay);
            }
        }
        return ItemStack.field_190927_a;
    }
}

