/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.wired;

import dan200.computercraft.api.network.IPacketReceiver;
import dan200.computercraft.api.network.Packet;
import dan200.computercraft.api.network.wired.IWiredElement;
import dan200.computercraft.api.network.wired.IWiredNetwork;
import dan200.computercraft.api.network.wired.IWiredNode;
import dan200.computercraft.api.network.wired.IWiredSender;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.wired.WiredNetwork;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import javax.annotation.Nonnull;

public final class WiredNode
implements IWiredNode {
    private Set<IPacketReceiver> receivers;
    final IWiredElement element;
    Map<String, IPeripheral> peripherals = Collections.emptyMap();
    final HashSet<WiredNode> neighbours = new HashSet();
    volatile WiredNetwork network;

    public WiredNode(IWiredElement element) {
        this.element = element;
        this.network = new WiredNetwork(this);
    }

    @Override
    public synchronized void addReceiver(@Nonnull IPacketReceiver receiver) {
        if (this.receivers == null) {
            this.receivers = new HashSet<IPacketReceiver>();
        }
        this.receivers.add(receiver);
    }

    @Override
    public synchronized void removeReceiver(@Nonnull IPacketReceiver receiver) {
        if (this.receivers != null) {
            this.receivers.remove(receiver);
        }
    }

    synchronized void tryTransmit(Packet packet, double packetDistance, boolean packetInterdimensional, double range, boolean interdimensional) {
        if (this.receivers == null) {
            return;
        }
        for (IPacketReceiver receiver : this.receivers) {
            if (!packetInterdimensional) {
                double receiveRange = Math.max(range, receiver.getRange());
                if (!interdimensional && !receiver.isInterdimensional() && !(packetDistance < receiveRange)) continue;
                receiver.receiveSameDimension(packet, packetDistance + this.element.getPosition().func_72438_d(receiver.getPosition()));
                continue;
            }
            if (!interdimensional && !receiver.isInterdimensional()) continue;
            receiver.receiveDifferentDimension(packet);
        }
    }

    @Override
    public boolean isWireless() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transmitSameDimension(@Nonnull Packet packet, double range) {
        Objects.requireNonNull(packet, "packet cannot be null");
        if (!(packet.getSender() instanceof IWiredSender) || ((IWiredSender)packet.getSender()).getNode() != this) {
            throw new IllegalArgumentException("Sender is not in the network");
        }
        this.acquireReadLock();
        try {
            WiredNetwork.transmitPacket(this, packet, range, false);
        }
        finally {
            this.network.lock.readLock().unlock();
        }
    }

    @Override
    public void transmitInterdimensional(@Nonnull Packet packet) {
        Objects.requireNonNull(packet, "packet cannot be null");
        if (!(packet.getSender() instanceof IWiredSender) || ((IWiredSender)packet.getSender()).getNode() != this) {
            throw new IllegalArgumentException("Sender is not in the network");
        }
        this.acquireReadLock();
        try {
            WiredNetwork.transmitPacket(this, packet, 0.0, true);
        }
        finally {
            this.network.lock.readLock().unlock();
        }
    }

    @Override
    @Nonnull
    public IWiredElement getElement() {
        return this.element;
    }

    @Override
    @Nonnull
    public IWiredNetwork getNetwork() {
        return this.network;
    }

    public String toString() {
        return "WiredNode{@" + this.element.getPosition() + " (" + this.element.getClass().getSimpleName() + ")}";
    }

    private void acquireReadLock() {
        WiredNetwork currentNetwork = this.network;
        while (true) {
            Lock lock = currentNetwork.lock.readLock();
            lock.lock();
            if (currentNetwork == this.network) {
                return;
            }
            lock.unlock();
        }
    }
}

