/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.lightoverlay.common.fabric;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Function;
import me.shedaniel.architectury.event.events.GuiEvent;
import me.shedaniel.architectury.event.events.client.ClientTickEvent;
import me.shedaniel.architectury.platform.Platform;
import me.shedaniel.architectury.registry.KeyBindings;
import me.shedaniel.lightoverlay.common.fabric.ChunkData;
import me.shedaniel.lightoverlay.common.fabric.CubicChunkPos;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3481;
import net.minecraft.class_3494;
import net.minecraft.class_3528;
import net.minecraft.class_3532;
import net.minecraft.class_3562;
import net.minecraft.class_3675;
import net.minecraft.class_3726;
import net.minecraft.class_4184;
import net.minecraft.class_4493;
import net.minecraft.class_4590;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.apache.logging.log4j.LogManager;
import org.lwjgl.opengl.GL11;

public class LightOverlay {
    public static final DecimalFormat FORMAT = new DecimalFormat("#.#");
    private static final String KEYBIND_CATEGORY = "key.lightoverlay.category";
    private static final class_2960 ENABLE_OVERLAY_KEYBIND = new class_2960("lightoverlay", "enable_overlay");
    public static int reach = 12;
    public static int crossLevel = 7;
    public static int secondaryLevel = -1;
    public static int lowerCrossLevel = -1;
    public static int higherCrossLevel = -1;
    public static boolean caching = false;
    public static boolean showNumber = false;
    public static boolean smoothLines = true;
    public static boolean underwater = false;
    public static boolean mushroom = false;
    public static boolean useListWhileCaching = true;
    public static float lineWidth = 1.0f;
    public static int yellowColor = 0xFFFF00;
    public static int redColor = 0xFF0000;
    public static int secondaryColor = 255;
    public static File configFile;
    private static class_304 enableOverlay;
    private static boolean enabled;
    private static final class_3528<class_1299<class_1297>> TESTING_ENTITY_TYPE;
    private static int threadNumber;
    public static class_4604 frustum;
    private static final ThreadPoolExecutor EXECUTOR;
    private static final Set<CubicChunkPos> POS;
    private static final Set<CubicChunkPos> CALCULATING_POS;
    private static final Map<CubicChunkPos, ChunkData> CHUNK_MAP;
    private static final class_310 CLIENT;
    private static long ticks;
    private static final class_3528<MethodHandle> IS_FRUSTUM_VISIBLE;
    public static final byte CROSS_YELLOW = 0;
    public static final byte CROSS_RED = 1;
    public static final byte CROSS_SECONDARY = 2;
    public static final byte CROSS_NONE = 2;

    public static void register() {
        configFile = new File(Platform.getConfigFolder().toFile(), "lightoverlay.properties");
        LightOverlay.loadConfig(configFile);
        enableOverlay = LightOverlay.createKeyBinding(ENABLE_OVERLAY_KEYBIND, class_3675.class_307.field_1668, 296, KEYBIND_CATEGORY);
        KeyBindings.registerKeyBinding((class_304)enableOverlay);
        LightOverlay.registerDebugRenderer(() -> {
            if (enabled) {
                class_746 playerEntity = LightOverlay.CLIENT.field_1724;
                int playerPosX = (int)playerEntity.method_23317() >> 4;
                int playerPosZ = (int)playerEntity.method_23321() >> 4;
                class_3726 collisionContext = class_3726.method_16195((class_1297)playerEntity);
                class_638 world = LightOverlay.CLIENT.field_1687;
                class_2338 playerPos = new class_2338(playerEntity.method_23317(), playerEntity.method_23318(), playerEntity.method_23321());
                class_4184 camera = LightOverlay.CLIENT.field_1773.method_19418();
                if (showNumber) {
                    RenderSystem.enableTexture();
                    RenderSystem.depthMask((boolean)true);
                    class_2338.class_2339 mutable = new class_2338.class_2339();
                    class_2338.class_2339 downMutable = new class_2338.class_2339();
                    for (Map.Entry<CubicChunkPos, ChunkData> entry : CHUNK_MAP.entrySet()) {
                        if (caching && (class_3532.method_15382((int)(entry.getKey().x - playerPosX)) > LightOverlay.getChunkRange() || class_3532.method_15382((int)(entry.getKey().z - playerPosZ)) > LightOverlay.getChunkRange())) continue;
                        for (Long2ByteMap.Entry objectEntry : entry.getValue().data().long2ByteEntrySet()) {
                            mutable.method_10103(class_2338.method_10061((long)objectEntry.getLongKey()), class_2338.method_10071((long)objectEntry.getLongKey()), class_2338.method_10083((long)objectEntry.getLongKey()));
                            if (!mutable.method_19771((class_2382)playerPos, (double)reach) || frustum != null && !LightOverlay.isFrustumVisible(frustum, mutable.method_10263(), mutable.method_10264(), mutable.method_10260(), mutable.method_10263() + 1, mutable.method_10263() + 1, mutable.method_10263() + 1)) continue;
                            downMutable.method_10103(mutable.method_10263(), mutable.method_10264() - 1, mutable.method_10260());
                            LightOverlay.renderLevel(CLIENT, camera, (class_1937)world, (class_2338)mutable, (class_2338)downMutable, objectEntry.getByteValue(), collisionContext);
                        }
                    }
                    RenderSystem.enableDepthTest();
                } else {
                    boolean useList = useListWhileCaching && caching;
                    RenderSystem.enableDepthTest();
                    RenderSystem.disableTexture();
                    RenderSystem.enableBlend();
                    RenderSystem.enableCull();
                    RenderSystem.blendFunc((class_4493.class_4535)class_4493.class_4535.field_22541, (class_4493.class_4534)class_4493.class_4534.field_22523);
                    if (smoothLines) {
                        GL11.glEnable((int)2848);
                    }
                    GL11.glLineWidth((float)lineWidth);
                    if (!useList) {
                        GL11.glBegin((int)1);
                    }
                    class_2338.class_2339 mutable = new class_2338.class_2339();
                    if (useList) {
                        GL11.glTranslated((double)(-camera.method_19326().field_1352), (double)(-camera.method_19326().field_1351 + 0.01), (double)(-camera.method_19326().field_1350));
                    }
                    for (Map.Entry<CubicChunkPos, ChunkData> entry : CHUNK_MAP.entrySet()) {
                        CubicChunkPos chunkPos = entry.getKey();
                        if (caching && (class_3532.method_15382((int)(chunkPos.x - playerPosX)) > LightOverlay.getChunkRange() || class_3532.method_15382((int)(chunkPos.z - playerPosZ)) > LightOverlay.getChunkRange())) continue;
                        if (useList) {
                            if (frustum != null && !LightOverlay.isFrustumVisible(frustum, chunkPos.getMinBlockX(), chunkPos.getMinBlockY(), chunkPos.getMinBlockZ(), chunkPos.getMaxBlockX(), chunkPos.getMaxBlockY(), chunkPos.getMaxBlockZ())) continue;
                            entry.getValue().renderList((class_1937)world, collisionContext);
                            continue;
                        }
                        for (Long2ByteMap.Entry objectEntry : entry.getValue().data().long2ByteEntrySet()) {
                            byte crossType = objectEntry.getByteValue();
                            mutable.method_10103(class_2338.method_10061((long)objectEntry.getLongKey()), class_2338.method_10071((long)objectEntry.getLongKey()), class_2338.method_10083((long)objectEntry.getLongKey()));
                            if (!mutable.method_19771((class_2382)playerPos, (double)reach) || frustum != null && !LightOverlay.isFrustumVisible(frustum, mutable.method_10263(), mutable.method_10264(), mutable.method_10260(), mutable.method_10263() + 1, mutable.method_10263() + 1, mutable.method_10263() + 1)) continue;
                            int color = crossType == 1 ? redColor : (crossType == 0 ? yellowColor : secondaryColor);
                            LightOverlay.renderCross(camera, (class_1937)world, (class_2338)mutable, color, collisionContext);
                        }
                    }
                    if (!useList) {
                        GL11.glEnd();
                    }
                    RenderSystem.disableBlend();
                    RenderSystem.enableTexture();
                    if (smoothLines) {
                        GL11.glDisable((int)2848);
                    }
                }
            }
        });
        GuiEvent.DEBUG_TEXT_LEFT.register(list -> {
            if (enabled) {
                if (caching) {
                    list.add(String.format("[Light Overlay] Chunks to queue: %02d", POS.size()));
                } else {
                    list.add("[Light Overlay] Enabled");
                }
            } else {
                list.add("[Light Overlay] Disabled");
            }
        });
        ClientTickEvent.CLIENT_POST.register(LightOverlay::tick);
    }

    private static void processChunk(CubicChunkPos pos, int playerPosX, int playerPosY, int playerPosZ, class_3726 context) {
        CALCULATING_POS.remove(pos);
        if (class_3532.method_15382((int)(pos.x - playerPosX)) > LightOverlay.getChunkRange() || class_3532.method_15382((int)(pos.y - playerPosY)) > LightOverlay.getChunkRange() || class_3532.method_15382((int)(pos.z - playerPosZ)) > LightOverlay.getChunkRange() || POS.contains(pos)) {
            return;
        }
        try {
            LightOverlay.calculateChunk(LightOverlay.CLIENT.field_1687.method_2935().method_2857(pos.x, pos.z, class_2806.field_12803, false), (class_1937)LightOverlay.CLIENT.field_1687, pos, context);
        }
        catch (Throwable throwable) {
            LogManager.getLogger().throwing(throwable);
        }
    }

    public static void queueChunkAndNear(CubicChunkPos pos) {
        for (int xOffset = -1; xOffset <= 1; ++xOffset) {
            for (int yOffset = -1; yOffset <= 1; ++yOffset) {
                for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                    LightOverlay.queueChunk(new CubicChunkPos(pos.x + xOffset, pos.y + yOffset, pos.z + zOffset));
                }
            }
        }
    }

    public static void queueChunk(CubicChunkPos pos) {
        if (enabled && caching && !CALCULATING_POS.contains(pos)) {
            POS.add(pos);
        }
    }

    public static int getChunkRange() {
        return Math.max(class_3532.method_15386((float)((float)reach / 16.0f)), 1);
    }

    private static void calculateChunk(class_2818 chunk, class_1937 world, CubicChunkPos chunkPos, class_3726 collisionContext) {
        if (world != null && chunk != null) {
            ChunkData chunkData = new ChunkData();
            class_3562 block = world.method_22336().method_15562(class_1944.field_9282);
            class_3562 sky = showNumber ? null : world.method_22336().method_15562(class_1944.field_9284);
            for (class_2338 pos : class_2338.method_10094((int)chunkPos.getMinBlockX(), (int)chunkPos.getMinBlockY(), (int)chunkPos.getMinBlockZ(), (int)chunkPos.getMaxBlockX(), (int)chunkPos.getMaxBlockY(), (int)chunkPos.getMaxBlockZ())) {
                class_2338 down = pos.method_10074();
                if (showNumber) {
                    int level = LightOverlay.getCrossLevel(pos, down, (class_1922)chunk, block, collisionContext);
                    if (level < 0) continue;
                    chunkData.data().put(pos.method_10063(), (byte)level);
                    continue;
                }
                class_1959 biome = !mushroom ? world.method_23753(pos) : null;
                byte type = LightOverlay.getCrossType(pos, biome, down, (class_1922)chunk, block, sky, collisionContext);
                if (type == 2) continue;
                chunkData.data().put(pos.method_10063(), type);
            }
            CHUNK_MAP.put(chunkPos, chunkData);
        } else {
            ChunkData data = CHUNK_MAP.remove(chunkPos);
            if (data != null) {
                data.close();
            }
        }
    }

    public static byte getCrossType(class_2338 pos, class_1959 biome, class_2338 down, class_1922 world, class_3562 block, class_3562 sky, class_3726 entityContext) {
        class_2680 blockBelowState = world.method_8320(down);
        class_2680 blockUpperState = world.method_8320(pos);
        class_265 upperCollisionShape = blockUpperState.method_26194(world, pos, entityContext);
        if (!underwater && !blockUpperState.method_26227().method_15769()) {
            return 2;
        }
        if (class_2248.method_9501((class_265)upperCollisionShape, (class_2350)class_2350.field_11036)) {
            return 2;
        }
        if (blockUpperState.method_26219()) {
            return 2;
        }
        if (upperCollisionShape.method_1105(class_2350.class_2351.field_11052) > 0.0) {
            return 2;
        }
        if (blockUpperState.method_26204().method_9525((class_3494)class_3481.field_15463)) {
            return 2;
        }
        if (!blockBelowState.method_26170(world, down, (class_1299)TESTING_ENTITY_TYPE.method_15332())) {
            return 2;
        }
        if (!mushroom && class_1959.class_1961.field_9365 == biome.method_8688()) {
            return 2;
        }
        int blockLightLevel = block.method_15543(pos);
        int skyLightLevel = sky.method_15543(pos);
        if (blockLightLevel > higherCrossLevel) {
            return 2;
        }
        if (skyLightLevel > higherCrossLevel) {
            return 0;
        }
        return (byte)(lowerCrossLevel >= 0 && blockLightLevel > lowerCrossLevel ? 2 : 1);
    }

    public static int getCrossLevel(class_2338 pos, class_2338 down, class_1922 world, class_3562 view, class_3726 collisionContext) {
        class_2680 blockBelowState = world.method_8320(down);
        class_2680 blockUpperState = world.method_8320(pos);
        class_265 collisionShape = blockBelowState.method_26194(world, down, collisionContext);
        class_265 upperCollisionShape = blockUpperState.method_26194(world, pos, collisionContext);
        if (!underwater && !blockUpperState.method_26227().method_15769()) {
            return -1;
        }
        if (!blockBelowState.method_26227().method_15769()) {
            return -1;
        }
        if (blockBelowState.method_26215()) {
            return -1;
        }
        if (class_2248.method_9501((class_265)upperCollisionShape, (class_2350)class_2350.field_11033)) {
            return -1;
        }
        return view.method_15543(pos);
    }

    public static void renderCross(class_4184 camera, class_1937 world, class_2338 pos, int color, class_3726 collisionContext) {
        double cameraX = camera.method_19326().field_1352;
        double cameraY = camera.method_19326().field_1351 - 0.005;
        double blockOffset = 0.0;
        class_265 upperOutlineShape = world.method_8320(pos).method_26172((class_1922)world, pos, collisionContext);
        if (!upperOutlineShape.method_1110()) {
            blockOffset += upperOutlineShape.method_1105(class_2350.class_2351.field_11052);
        }
        double cameraZ = camera.method_19326().field_1350;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        RenderSystem.color4f((float)((float)red / 255.0f), (float)((float)green / 255.0f), (float)((float)blue / 255.0f), (float)1.0f);
        GL11.glVertex3d((double)((double)x + 0.01 - cameraX), (double)((double)y - cameraY + blockOffset), (double)((double)z + 0.01 - cameraZ));
        GL11.glVertex3d((double)((double)x - 0.01 + 1.0 - cameraX), (double)((double)y - cameraY + blockOffset), (double)((double)z - 0.01 + 1.0 - cameraZ));
        GL11.glVertex3d((double)((double)x - 0.01 + 1.0 - cameraX), (double)((double)y - cameraY + blockOffset), (double)((double)z + 0.01 - cameraZ));
        GL11.glVertex3d((double)((double)x + 0.01 - cameraX), (double)((double)y - cameraY + blockOffset), (double)((double)z - 0.01 + 1.0 - cameraZ));
    }

    public static void renderLevel(class_310 client, class_4184 camera, class_1937 world, class_2338 pos, class_2338 down, byte level, class_3726 collisionContext) {
        String text = String.valueOf(level);
        class_327 font = client.field_1772;
        double cameraX = camera.method_19326().field_1352;
        double cameraY = camera.method_19326().field_1351;
        class_265 upperOutlineShape = world.method_8320(down).method_26172((class_1922)world, down, collisionContext);
        if (!upperOutlineShape.method_1110()) {
            cameraY += 1.0 - upperOutlineShape.method_1105(class_2350.class_2351.field_11052);
        }
        double cameraZ = camera.method_19326().field_1350;
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)((float)((double)((float)pos.method_10263() + 0.5f) - cameraX)), (float)((float)((double)pos.method_10264() - cameraY) + 0.005f), (float)((float)((double)((float)pos.method_10260() + 0.5f) - cameraZ)));
        RenderSystem.rotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderSystem.normal3f((float)0.0f, (float)1.0f, (float)0.0f);
        float size = 0.07f;
        RenderSystem.scalef((float)(-size), (float)(-size), (float)size);
        float float_3 = (float)(-font.method_1727(text)) / 2.0f + 0.4f;
        RenderSystem.enableAlphaTest();
        class_4597.class_4598 source = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        font.method_27521(text, float_3, -3.5f, level > higherCrossLevel ? -16505852 : (lowerCrossLevel >= 0 && level > lowerCrossLevel ? -16750849 : -9236207), false, class_4590.method_22931().method_22936(), (class_4597)source, false, 0, 0xF000F0);
        source.method_22993();
        RenderSystem.popMatrix();
    }

    public static void loadConfig(File file) {
        try {
            redColor = 0xFF0000;
            yellowColor = 0xFFFF00;
            secondaryColor = 255;
            if (!file.exists() || !file.canRead()) {
                LightOverlay.saveConfig(file);
            }
            FileInputStream fis = new FileInputStream(file);
            Properties properties = new Properties();
            properties.load(fis);
            fis.close();
            reach = Integer.parseInt((String)properties.computeIfAbsent("reach", (Function<? super Object, ?>)((Function<Object, Object>)a -> "12")));
            crossLevel = Integer.parseInt((String)properties.computeIfAbsent("crossLevel", (Function<? super Object, ?>)((Function<Object, Object>)a -> "7")));
            secondaryLevel = Integer.parseInt((String)properties.computeIfAbsent("secondaryLevel", (Function<? super Object, ?>)((Function<Object, Object>)a -> "-1")));
            caching = ((String)properties.computeIfAbsent("caching", (Function<? super Object, ?>)((Function<Object, Object>)a -> "false"))).equalsIgnoreCase("true");
            showNumber = ((String)properties.computeIfAbsent("showNumber", (Function<? super Object, ?>)((Function<Object, Object>)a -> "false"))).equalsIgnoreCase("true");
            smoothLines = ((String)properties.computeIfAbsent("smoothLines", (Function<? super Object, ?>)((Function<Object, Object>)a -> "true"))).equalsIgnoreCase("true");
            underwater = ((String)properties.computeIfAbsent("underwater", (Function<? super Object, ?>)((Function<Object, Object>)a -> "false"))).equalsIgnoreCase("true");
            mushroom = ((String)properties.computeIfAbsent("mushroom", (Function<? super Object, ?>)((Function<Object, Object>)a -> "false"))).equalsIgnoreCase("true");
            useListWhileCaching = ((String)properties.computeIfAbsent("useListWhileCaching", (Function<? super Object, ?>)((Function<Object, Object>)a -> "true"))).equalsIgnoreCase("true");
            lineWidth = Float.parseFloat((String)properties.computeIfAbsent("lineWidth", (Function<? super Object, ?>)((Function<Object, Object>)a -> "1")));
            int r = Integer.parseInt((String)properties.computeIfAbsent("yellowColorRed", (Function<? super Object, ?>)((Function<Object, Object>)a -> "255")));
            int g = Integer.parseInt((String)properties.computeIfAbsent("yellowColorGreen", (Function<? super Object, ?>)((Function<Object, Object>)a -> "255")));
            int b = Integer.parseInt((String)properties.computeIfAbsent("yellowColorBlue", (Function<? super Object, ?>)((Function<Object, Object>)a -> "0")));
            yellowColor = (r << 16) + (g << 8) + b;
            r = Integer.parseInt((String)properties.computeIfAbsent("redColorRed", (Function<? super Object, ?>)((Function<Object, Object>)a -> "255")));
            g = Integer.parseInt((String)properties.computeIfAbsent("redColorGreen", (Function<? super Object, ?>)((Function<Object, Object>)a -> "0")));
            b = Integer.parseInt((String)properties.computeIfAbsent("redColorBlue", (Function<? super Object, ?>)((Function<Object, Object>)a -> "0")));
            redColor = (r << 16) + (g << 8) + b;
            r = Integer.parseInt((String)properties.computeIfAbsent("secondaryColorRed", (Function<? super Object, ?>)((Function<Object, Object>)a -> "0")));
            g = Integer.parseInt((String)properties.computeIfAbsent("secondaryColorGreen", (Function<? super Object, ?>)((Function<Object, Object>)a -> "0")));
            b = Integer.parseInt((String)properties.computeIfAbsent("secondaryColorBlue", (Function<? super Object, ?>)((Function<Object, Object>)a -> "255")));
            secondaryColor = (r << 16) + (g << 8) + b;
            LightOverlay.saveConfig(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            reach = 12;
            crossLevel = 7;
            secondaryLevel = -1;
            lineWidth = 1.0f;
            redColor = 0xFF0000;
            yellowColor = 0xFFFF00;
            secondaryColor = 255;
            caching = false;
            showNumber = false;
            smoothLines = true;
            underwater = false;
            mushroom = false;
            useListWhileCaching = true;
            try {
                LightOverlay.saveConfig(file);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (secondaryLevel >= crossLevel) {
            System.err.println("[Light Overlay] Secondary Level is higher than Cross Level");
        }
        lowerCrossLevel = Math.min(crossLevel, secondaryLevel);
        higherCrossLevel = Math.max(crossLevel, secondaryLevel);
        for (ChunkData data : CHUNK_MAP.values()) {
            data.close();
        }
        CHUNK_MAP.clear();
        POS.clear();
    }

    public static void saveConfig(File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file, false);
        fos.write("# Light Overlay Config".getBytes());
        fos.write("\n".getBytes());
        fos.write(("reach=" + reach).getBytes());
        fos.write("\n".getBytes());
        fos.write(("crossLevel=" + crossLevel).getBytes());
        fos.write("\n".getBytes());
        fos.write(("secondaryLevel=" + secondaryLevel).getBytes());
        fos.write("\n".getBytes());
        fos.write(("caching=" + caching).getBytes());
        fos.write("\n".getBytes());
        fos.write(("showNumber=" + showNumber).getBytes());
        fos.write("\n".getBytes());
        fos.write(("smoothLines=" + smoothLines).getBytes());
        fos.write("\n".getBytes());
        fos.write(("underwater=" + underwater).getBytes());
        fos.write("\n".getBytes());
        fos.write(("mushroom=" + mushroom).getBytes());
        fos.write("\n".getBytes());
        fos.write(("useListWhileCaching=" + useListWhileCaching).getBytes());
        fos.write("\n".getBytes());
        fos.write(("lineWidth=" + FORMAT.format(lineWidth)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("yellowColorRed=" + (yellowColor >> 16 & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("yellowColorGreen=" + (yellowColor >> 8 & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("yellowColorBlue=" + (yellowColor & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("redColorRed=" + (redColor >> 16 & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("redColorGreen=" + (redColor >> 8 & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("redColorBlue=" + (redColor & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("secondaryColorRed=" + (secondaryColor >> 16 & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("secondaryColorGreen=" + (secondaryColor >> 8 & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("secondaryColorBlue=" + (secondaryColor & 0xFF)).getBytes());
        fos.close();
    }

    private static class_304 createKeyBinding(class_2960 id, class_3675.class_307 type, int code, String category) {
        return new class_304("key." + id.method_12836() + "." + id.method_12832(), type, code, category);
    }

    private static boolean isFrustumVisible(class_4604 frustum, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        try {
            return ((MethodHandle)IS_FRUSTUM_VISIBLE.method_15332()).invokeExact(frustum, minX, minY, minZ, maxX, maxY, maxZ);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    private static void registerDebugRenderer(Runnable runnable) {
        try {
            Class.forName("me.shedaniel.lightoverlay." + Platform.getModLoader() + ".LightOverlayImpl").getDeclaredField("debugRenderer").set(null, runnable);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void tick(class_310 minecraft) {
        block24: {
            while (enableOverlay.method_1436()) {
                enabled = !enabled;
            }
            try {
                ++ticks;
                if (LightOverlay.CLIENT.field_1724 == null || !enabled) {
                    POS.clear();
                    CALCULATING_POS.clear();
                    EXECUTOR.getQueue().clear();
                    for (ChunkData data : CHUNK_MAP.values()) {
                        data.close();
                    }
                    CHUNK_MAP.clear();
                    break block24;
                }
                class_746 player = LightOverlay.CLIENT.field_1724;
                class_638 world = LightOverlay.CLIENT.field_1687;
                class_3726 collisionContext = class_3726.method_16195((class_1297)player);
                if (!caching) {
                    CALCULATING_POS.clear();
                    POS.clear();
                    for (ChunkData data : CHUNK_MAP.values()) {
                        data.close();
                    }
                    CHUNK_MAP.clear();
                    class_2338 playerPos = player.method_24515();
                    class_3562 block = world.method_22336().method_15562(class_1944.field_9282);
                    class_3562 sky = showNumber ? null : world.method_22336().method_15562(class_1944.field_9284);
                    class_2338.class_2339 downPos = new class_2338.class_2339();
                    Iterable iterate = class_2338.method_10094((int)(playerPos.method_10263() - reach), (int)(playerPos.method_10264() - reach), (int)(playerPos.method_10260() - reach), (int)(playerPos.method_10263() + reach), (int)(playerPos.method_10264() + reach), (int)(playerPos.method_10260() + reach));
                    ChunkData chunkData = new ChunkData();
                    CHUNK_MAP.put(new CubicChunkPos(0, 0, 0), chunkData);
                    for (class_2338 blockPos : iterate) {
                        downPos.method_10103(blockPos.method_10263(), blockPos.method_10264() - 1, blockPos.method_10260());
                        if (showNumber) {
                            int level = LightOverlay.getCrossLevel(blockPos, (class_2338)downPos, (class_1922)world, block, collisionContext);
                            if (level < 0) continue;
                            chunkData.data().put(blockPos.method_10063(), (byte)level);
                            continue;
                        }
                        class_1959 biome = !mushroom ? world.method_23753(blockPos) : null;
                        byte type = LightOverlay.getCrossType(blockPos, biome, (class_2338)downPos, (class_1922)world, block, sky, collisionContext);
                        if (type == 2) continue;
                        chunkData.data().put(blockPos.method_10063(), type);
                    }
                    break block24;
                }
                int playerPosX = (int)player.method_23317() >> 4;
                int playerPosY = (int)player.method_23318() >> 4;
                int playerPosZ = (int)player.method_23321() >> 4;
                for (int chunkX = playerPosX - LightOverlay.getChunkRange(); chunkX <= playerPosX + LightOverlay.getChunkRange(); ++chunkX) {
                    for (int chunkY = Math.max(playerPosY - LightOverlay.getChunkRange(), 0); chunkY <= playerPosY + LightOverlay.getChunkRange() && chunkY <= 15; ++chunkY) {
                        for (int chunkZ = playerPosZ - LightOverlay.getChunkRange(); chunkZ <= playerPosZ + LightOverlay.getChunkRange(); ++chunkZ) {
                            CubicChunkPos chunkPos;
                            if (class_3532.method_15382((int)(chunkX - playerPosX)) > LightOverlay.getChunkRange() || class_3532.method_15382((int)(chunkY - playerPosY)) > LightOverlay.getChunkRange() || class_3532.method_15382((int)(chunkZ - playerPosZ)) > LightOverlay.getChunkRange() || CHUNK_MAP.containsKey(chunkPos = new CubicChunkPos(chunkX, chunkY, chunkZ))) continue;
                            LightOverlay.queueChunk(chunkPos);
                        }
                    }
                }
                for (int p = 0; p < 3 && EXECUTOR.getQueue().size() < Runtime.getRuntime().availableProcessors(); ++p) {
                    double d1 = Double.MAX_VALUE;
                    double d2 = Double.MAX_VALUE;
                    double d3 = Double.MAX_VALUE;
                    CubicChunkPos c1 = null;
                    CubicChunkPos c2 = null;
                    CubicChunkPos c3 = null;
                    Set<CubicChunkPos> set = POS;
                    synchronized (set) {
                        Iterator<CubicChunkPos> iterator = POS.iterator();
                        while (iterator.hasNext()) {
                            int k;
                            int j;
                            CubicChunkPos pos = iterator.next();
                            if (class_3532.method_15382((int)(pos.x - playerPosX)) > LightOverlay.getChunkRange() || class_3532.method_15382((int)(pos.y - playerPosY)) > LightOverlay.getChunkRange() || class_3532.method_15382((int)(pos.z - playerPosZ)) > LightOverlay.getChunkRange() || CALCULATING_POS.contains(pos)) {
                                iterator.remove();
                                continue;
                            }
                            if (!LightOverlay.isFrustumVisible(frustum, pos.getMinBlockX(), pos.getMinBlockY(), pos.getMinBlockZ(), pos.getMaxBlockX(), pos.getMaxBlockY(), pos.getMaxBlockZ())) continue;
                            int i = Math.abs(pos.x - playerPosX);
                            double distance = Math.sqrt(i * i + (j = Math.abs(pos.y - playerPosY)) * j + (k = Math.abs(pos.z - playerPosZ)) * k);
                            if (distance < d1) {
                                d3 = d2;
                                d2 = d1;
                                d1 = distance;
                                c3 = c2;
                                c2 = c1;
                                c1 = pos;
                                iterator.remove();
                                continue;
                            }
                            if (distance < d2) {
                                d3 = d2;
                                d2 = distance;
                                c3 = c2;
                                c2 = pos;
                                iterator.remove();
                                continue;
                            }
                            if (!(distance < d3)) continue;
                            d3 = distance;
                            c3 = pos;
                            iterator.remove();
                        }
                    }
                    CubicChunkPos finalC1 = c1;
                    CubicChunkPos finalC2 = c2;
                    CubicChunkPos finalC3 = c3;
                    if (finalC1 == null) continue;
                    CALCULATING_POS.add(finalC1);
                    if (finalC2 != null) {
                        CALCULATING_POS.add(finalC2);
                        if (finalC3 != null) {
                            CALCULATING_POS.add(finalC3);
                        }
                    }
                    EXECUTOR.submit(() -> {
                        int playerPosX1 = (int)LightOverlay.CLIENT.field_1724.method_23317() >> 4;
                        int playerPosY1 = (int)LightOverlay.CLIENT.field_1724.method_23318() >> 4;
                        int playerPosZ1 = (int)LightOverlay.CLIENT.field_1724.method_23321() >> 4;
                        if (finalC1 != null) {
                            LightOverlay.processChunk(finalC1, playerPosX1, playerPosY1, playerPosZ1, collisionContext);
                        }
                        if (finalC2 != null) {
                            LightOverlay.processChunk(finalC2, playerPosX1, playerPosY1, playerPosZ1, collisionContext);
                        }
                        if (finalC3 != null) {
                            LightOverlay.processChunk(finalC3, playerPosX1, playerPosY1, playerPosZ1, collisionContext);
                        }
                    });
                }
                if (ticks % 50L == 0L) {
                    Iterator<Map.Entry<CubicChunkPos, ChunkData>> iterator = CHUNK_MAP.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<CubicChunkPos, ChunkData> entry = iterator.next();
                        if (class_3532.method_15382((int)(entry.getKey().x - playerPosX)) <= LightOverlay.getChunkRange() * 2 && class_3532.method_15382((int)(entry.getKey().y - playerPosY)) <= LightOverlay.getChunkRange() * 2 && class_3532.method_15382((int)(entry.getKey().z - playerPosZ)) <= LightOverlay.getChunkRange() * 2) continue;
                        entry.getValue().close();
                        iterator.remove();
                    }
                }
            }
            catch (Throwable throwable) {
                LogManager.getLogger().throwing(throwable);
            }
        }
    }

    static {
        enabled = false;
        TESTING_ENTITY_TYPE = new class_3528(() -> class_1299.class_1300.method_5902((class_1311)class_1311.field_6302).method_17687(0.0f, 0.0f).method_5904().method_5905(null));
        threadNumber = 0;
        EXECUTOR = (ThreadPoolExecutor)Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), r -> {
            Thread thread = new Thread(r, "light-overlay-" + threadNumber++);
            thread.setDaemon(true);
            return thread;
        });
        POS = Collections.synchronizedSet(new HashSet());
        CALCULATING_POS = Collections.synchronizedSet(new HashSet());
        CHUNK_MAP = Maps.newConcurrentMap();
        CLIENT = class_310.method_1551();
        ticks = 0L;
        IS_FRUSTUM_VISIBLE = new class_3528(() -> {
            try {
                return MethodHandles.lookup().findStatic(Class.forName("me.shedaniel.lightoverlay." + Platform.getModLoader() + ".LightOverlayImpl"), "isFrustumVisible", MethodType.methodType(Boolean.TYPE, class_4604.class, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE));
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

