/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.lightoverlay.common.forge;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Function;
import me.shedaniel.architectury.event.events.GuiEvent;
import me.shedaniel.architectury.event.events.client.ClientTickEvent;
import me.shedaniel.architectury.platform.Platform;
import me.shedaniel.architectury.registry.KeyBindings;
import me.shedaniel.lightoverlay.common.forge.ChunkData;
import me.shedaniel.lightoverlay.common.forge.CubicChunkPos;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.LazyValue;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.lighting.IWorldLightListener;
import org.apache.logging.log4j.LogManager;
import org.lwjgl.opengl.GL11;

public class LightOverlay {
    public static final DecimalFormat FORMAT = new DecimalFormat("#.#");
    private static final String KEYBIND_CATEGORY = "key.lightoverlay.category";
    private static final ResourceLocation ENABLE_OVERLAY_KEYBIND = new ResourceLocation("lightoverlay", "enable_overlay");
    public static int reach = 12;
    public static int crossLevel = 7;
    public static int secondaryLevel = -1;
    public static int lowerCrossLevel = -1;
    public static int higherCrossLevel = -1;
    public static boolean caching = false;
    public static boolean showNumber = false;
    public static boolean smoothLines = true;
    public static boolean underwater = false;
    public static boolean mushroom = false;
    public static boolean useListWhileCaching = true;
    public static float lineWidth = 1.0f;
    public static int yellowColor = 0xFFFF00;
    public static int redColor = 0xFF0000;
    public static int secondaryColor = 255;
    public static File configFile;
    private static KeyBinding enableOverlay;
    private static boolean enabled;
    private static final LazyValue<EntityType<Entity>> TESTING_ENTITY_TYPE;
    private static int threadNumber;
    public static ClippingHelper frustum;
    private static final ThreadPoolExecutor EXECUTOR;
    private static final Set<CubicChunkPos> POS;
    private static final Set<CubicChunkPos> CALCULATING_POS;
    private static final Map<CubicChunkPos, ChunkData> CHUNK_MAP;
    private static final Minecraft CLIENT;
    private static long ticks;
    private static final LazyValue<MethodHandle> IS_FRUSTUM_VISIBLE;
    public static final byte CROSS_YELLOW = 0;
    public static final byte CROSS_RED = 1;
    public static final byte CROSS_SECONDARY = 2;
    public static final byte CROSS_NONE = 2;

    public static void register() {
        configFile = new File(Platform.getConfigFolder().toFile(), "lightoverlay.properties");
        LightOverlay.loadConfig(configFile);
        enableOverlay = LightOverlay.createKeyBinding(ENABLE_OVERLAY_KEYBIND, InputMappings.Type.KEYSYM, 296, KEYBIND_CATEGORY);
        KeyBindings.registerKeyBinding((KeyBinding)enableOverlay);
        LightOverlay.registerDebugRenderer(() -> {
            if (enabled) {
                ClientPlayerEntity playerEntity = LightOverlay.CLIENT.field_71439_g;
                int playerPosX = (int)playerEntity.func_226277_ct_() >> 4;
                int playerPosZ = (int)playerEntity.func_226281_cx_() >> 4;
                ISelectionContext collisionContext = ISelectionContext.func_216374_a((Entity)playerEntity);
                ClientWorld world = LightOverlay.CLIENT.field_71441_e;
                BlockPos playerPos = new BlockPos(playerEntity.func_226277_ct_(), playerEntity.func_226278_cu_(), playerEntity.func_226281_cx_());
                ActiveRenderInfo camera = LightOverlay.CLIENT.field_71460_t.func_215316_n();
                if (showNumber) {
                    RenderSystem.enableTexture();
                    RenderSystem.depthMask((boolean)true);
                    BlockPos.Mutable mutable = new BlockPos.Mutable();
                    BlockPos.Mutable downMutable = new BlockPos.Mutable();
                    for (Map.Entry<CubicChunkPos, ChunkData> entry : CHUNK_MAP.entrySet()) {
                        if (caching && (MathHelper.func_76130_a((int)(entry.getKey().x - playerPosX)) > LightOverlay.getChunkRange() || MathHelper.func_76130_a((int)(entry.getKey().z - playerPosZ)) > LightOverlay.getChunkRange())) continue;
                        for (Long2ByteMap.Entry objectEntry : entry.getValue().data().long2ByteEntrySet()) {
                            mutable.func_181079_c(BlockPos.func_218290_b((long)objectEntry.getLongKey()), BlockPos.func_218274_c((long)objectEntry.getLongKey()), BlockPos.func_218282_d((long)objectEntry.getLongKey()));
                            if (!mutable.func_218141_a((Vector3i)playerPos, (double)reach) || frustum != null && !LightOverlay.isFrustumVisible(frustum, mutable.func_177958_n(), mutable.func_177956_o(), mutable.func_177952_p(), mutable.func_177958_n() + 1, mutable.func_177958_n() + 1, mutable.func_177958_n() + 1)) continue;
                            downMutable.func_181079_c(mutable.func_177958_n(), mutable.func_177956_o() - 1, mutable.func_177952_p());
                            LightOverlay.renderLevel(CLIENT, camera, (World)world, (BlockPos)mutable, (BlockPos)downMutable, objectEntry.getByteValue(), collisionContext);
                        }
                    }
                    RenderSystem.enableDepthTest();
                } else {
                    boolean useList = useListWhileCaching && caching;
                    RenderSystem.enableDepthTest();
                    RenderSystem.disableTexture();
                    RenderSystem.enableBlend();
                    RenderSystem.enableCull();
                    RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                    if (smoothLines) {
                        GL11.glEnable((int)2848);
                    }
                    GL11.glLineWidth((float)lineWidth);
                    if (!useList) {
                        GL11.glBegin((int)1);
                    }
                    BlockPos.Mutable mutable = new BlockPos.Mutable();
                    if (useList) {
                        GL11.glTranslated((double)(-camera.func_216785_c().field_72450_a), (double)(-camera.func_216785_c().field_72448_b + 0.01), (double)(-camera.func_216785_c().field_72449_c));
                    }
                    for (Map.Entry<CubicChunkPos, ChunkData> entry : CHUNK_MAP.entrySet()) {
                        CubicChunkPos chunkPos = entry.getKey();
                        if (caching && (MathHelper.func_76130_a((int)(chunkPos.x - playerPosX)) > LightOverlay.getChunkRange() || MathHelper.func_76130_a((int)(chunkPos.z - playerPosZ)) > LightOverlay.getChunkRange())) continue;
                        if (useList) {
                            if (frustum != null && !LightOverlay.isFrustumVisible(frustum, chunkPos.getMinBlockX(), chunkPos.getMinBlockY(), chunkPos.getMinBlockZ(), chunkPos.getMaxBlockX(), chunkPos.getMaxBlockY(), chunkPos.getMaxBlockZ())) continue;
                            entry.getValue().renderList((World)world, collisionContext);
                            continue;
                        }
                        for (Long2ByteMap.Entry objectEntry : entry.getValue().data().long2ByteEntrySet()) {
                            byte crossType = objectEntry.getByteValue();
                            mutable.func_181079_c(BlockPos.func_218290_b((long)objectEntry.getLongKey()), BlockPos.func_218274_c((long)objectEntry.getLongKey()), BlockPos.func_218282_d((long)objectEntry.getLongKey()));
                            if (!mutable.func_218141_a((Vector3i)playerPos, (double)reach) || frustum != null && !LightOverlay.isFrustumVisible(frustum, mutable.func_177958_n(), mutable.func_177956_o(), mutable.func_177952_p(), mutable.func_177958_n() + 1, mutable.func_177958_n() + 1, mutable.func_177958_n() + 1)) continue;
                            int color = crossType == 1 ? redColor : (crossType == 0 ? yellowColor : secondaryColor);
                            LightOverlay.renderCross(camera, (World)world, (BlockPos)mutable, color, collisionContext);
                        }
                    }
                    if (!useList) {
                        GL11.glEnd();
                    }
                    RenderSystem.disableBlend();
                    RenderSystem.enableTexture();
                    if (smoothLines) {
                        GL11.glDisable((int)2848);
                    }
                }
            }
        });
        GuiEvent.DEBUG_TEXT_LEFT.register(list -> {
            if (enabled) {
                if (caching) {
                    list.add(String.format("[Light Overlay] Chunks to queue: %02d", POS.size()));
                } else {
                    list.add("[Light Overlay] Enabled");
                }
            } else {
                list.add("[Light Overlay] Disabled");
            }
        });
        ClientTickEvent.CLIENT_POST.register(LightOverlay::tick);
    }

    private static void processChunk(CubicChunkPos pos, int playerPosX, int playerPosY, int playerPosZ, ISelectionContext context) {
        CALCULATING_POS.remove(pos);
        if (MathHelper.func_76130_a((int)(pos.x - playerPosX)) > LightOverlay.getChunkRange() || MathHelper.func_76130_a((int)(pos.y - playerPosY)) > LightOverlay.getChunkRange() || MathHelper.func_76130_a((int)(pos.z - playerPosZ)) > LightOverlay.getChunkRange() || POS.contains(pos)) {
            return;
        }
        try {
            LightOverlay.calculateChunk(LightOverlay.CLIENT.field_71441_e.func_72863_F().func_212849_a_(pos.x, pos.z, ChunkStatus.field_222617_m, false), (World)LightOverlay.CLIENT.field_71441_e, pos, context);
        }
        catch (Throwable throwable) {
            LogManager.getLogger().throwing(throwable);
        }
    }

    public static void queueChunkAndNear(CubicChunkPos pos) {
        for (int xOffset = -1; xOffset <= 1; ++xOffset) {
            for (int yOffset = -1; yOffset <= 1; ++yOffset) {
                for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                    LightOverlay.queueChunk(new CubicChunkPos(pos.x + xOffset, pos.y + yOffset, pos.z + zOffset));
                }
            }
        }
    }

    public static void queueChunk(CubicChunkPos pos) {
        if (enabled && caching && !CALCULATING_POS.contains(pos)) {
            POS.add(pos);
        }
    }

    public static int getChunkRange() {
        return Math.max(MathHelper.func_76123_f((float)((float)reach / 16.0f)), 1);
    }

    private static void calculateChunk(Chunk chunk, World world, CubicChunkPos chunkPos, ISelectionContext collisionContext) {
        if (world != null && chunk != null) {
            ChunkData chunkData = new ChunkData();
            IWorldLightListener block = world.func_225524_e_().func_215569_a(LightType.BLOCK);
            IWorldLightListener sky = showNumber ? null : world.func_225524_e_().func_215569_a(LightType.SKY);
            for (BlockPos pos : BlockPos.func_191531_b((int)chunkPos.getMinBlockX(), (int)chunkPos.getMinBlockY(), (int)chunkPos.getMinBlockZ(), (int)chunkPos.getMaxBlockX(), (int)chunkPos.getMaxBlockY(), (int)chunkPos.getMaxBlockZ())) {
                BlockPos down = pos.func_177977_b();
                if (showNumber) {
                    int level = LightOverlay.getCrossLevel(pos, down, (IBlockReader)chunk, block, collisionContext);
                    if (level < 0) continue;
                    chunkData.data().put(pos.func_218275_a(), (byte)level);
                    continue;
                }
                Biome biome = !mushroom ? world.func_226691_t_(pos) : null;
                byte type = LightOverlay.getCrossType(pos, biome, down, (IBlockReader)chunk, block, sky, collisionContext);
                if (type == 2) continue;
                chunkData.data().put(pos.func_218275_a(), type);
            }
            CHUNK_MAP.put(chunkPos, chunkData);
        } else {
            ChunkData data = CHUNK_MAP.remove(chunkPos);
            if (data != null) {
                data.close();
            }
        }
    }

    public static byte getCrossType(BlockPos pos, Biome biome, BlockPos down, IBlockReader world, IWorldLightListener block, IWorldLightListener sky, ISelectionContext entityContext) {
        BlockState blockBelowState = world.func_180495_p(down);
        BlockState blockUpperState = world.func_180495_p(pos);
        VoxelShape upperCollisionShape = blockUpperState.func_215685_b(world, pos, entityContext);
        if (!underwater && !blockUpperState.func_204520_s().func_206888_e()) {
            return 2;
        }
        if (Block.func_208061_a((VoxelShape)upperCollisionShape, (Direction)Direction.UP)) {
            return 2;
        }
        if (blockUpperState.func_185897_m()) {
            return 2;
        }
        if (upperCollisionShape.func_197758_c(Direction.Axis.Y) > 0.0) {
            return 2;
        }
        if (blockUpperState.func_177230_c().func_203417_a((ITag)BlockTags.field_203437_y)) {
            return 2;
        }
        if (!blockBelowState.func_215688_a(world, down, (EntityType)TESTING_ENTITY_TYPE.func_179281_c())) {
            return 2;
        }
        if (!mushroom && Biome.Category.MUSHROOM == biome.func_201856_r()) {
            return 2;
        }
        int blockLightLevel = block.func_215611_b(pos);
        int skyLightLevel = sky.func_215611_b(pos);
        if (blockLightLevel > higherCrossLevel) {
            return 2;
        }
        if (skyLightLevel > higherCrossLevel) {
            return 0;
        }
        return (byte)(lowerCrossLevel >= 0 && blockLightLevel > lowerCrossLevel ? 2 : 1);
    }

    public static int getCrossLevel(BlockPos pos, BlockPos down, IBlockReader world, IWorldLightListener view, ISelectionContext collisionContext) {
        BlockState blockBelowState = world.func_180495_p(down);
        BlockState blockUpperState = world.func_180495_p(pos);
        VoxelShape collisionShape = blockBelowState.func_215685_b(world, down, collisionContext);
        VoxelShape upperCollisionShape = blockUpperState.func_215685_b(world, pos, collisionContext);
        if (!underwater && !blockUpperState.func_204520_s().func_206888_e()) {
            return -1;
        }
        if (!blockBelowState.func_204520_s().func_206888_e()) {
            return -1;
        }
        if (blockBelowState.func_196958_f()) {
            return -1;
        }
        if (Block.func_208061_a((VoxelShape)upperCollisionShape, (Direction)Direction.DOWN)) {
            return -1;
        }
        return view.func_215611_b(pos);
    }

    public static void renderCross(ActiveRenderInfo camera, World world, BlockPos pos, int color, ISelectionContext collisionContext) {
        double cameraX = camera.func_216785_c().field_72450_a;
        double cameraY = camera.func_216785_c().field_72448_b - 0.005;
        double blockOffset = 0.0;
        VoxelShape upperOutlineShape = world.func_180495_p(pos).func_215700_a((IBlockReader)world, pos, collisionContext);
        if (!upperOutlineShape.func_197766_b()) {
            blockOffset += upperOutlineShape.func_197758_c(Direction.Axis.Y);
        }
        double cameraZ = camera.func_216785_c().field_72449_c;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        RenderSystem.color4f((float)((float)red / 255.0f), (float)((float)green / 255.0f), (float)((float)blue / 255.0f), (float)1.0f);
        GL11.glVertex3d((double)((double)x + 0.01 - cameraX), (double)((double)y - cameraY + blockOffset), (double)((double)z + 0.01 - cameraZ));
        GL11.glVertex3d((double)((double)x - 0.01 + 1.0 - cameraX), (double)((double)y - cameraY + blockOffset), (double)((double)z - 0.01 + 1.0 - cameraZ));
        GL11.glVertex3d((double)((double)x - 0.01 + 1.0 - cameraX), (double)((double)y - cameraY + blockOffset), (double)((double)z + 0.01 - cameraZ));
        GL11.glVertex3d((double)((double)x + 0.01 - cameraX), (double)((double)y - cameraY + blockOffset), (double)((double)z - 0.01 + 1.0 - cameraZ));
    }

    public static void renderLevel(Minecraft client, ActiveRenderInfo camera, World world, BlockPos pos, BlockPos down, byte level, ISelectionContext collisionContext) {
        String text = String.valueOf(level);
        FontRenderer font = client.field_71466_p;
        double cameraX = camera.func_216785_c().field_72450_a;
        double cameraY = camera.func_216785_c().field_72448_b;
        VoxelShape upperOutlineShape = world.func_180495_p(down).func_215700_a((IBlockReader)world, down, collisionContext);
        if (!upperOutlineShape.func_197766_b()) {
            cameraY += 1.0 - upperOutlineShape.func_197758_c(Direction.Axis.Y);
        }
        double cameraZ = camera.func_216785_c().field_72449_c;
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)((float)((double)((float)pos.func_177958_n() + 0.5f) - cameraX)), (float)((float)((double)pos.func_177956_o() - cameraY) + 0.005f), (float)((float)((double)((float)pos.func_177952_p() + 0.5f) - cameraZ)));
        RenderSystem.rotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderSystem.normal3f((float)0.0f, (float)1.0f, (float)0.0f);
        float size = 0.07f;
        RenderSystem.scalef((float)(-size), (float)(-size), (float)size);
        float float_3 = (float)(-font.func_78256_a(text)) / 2.0f + 0.4f;
        RenderSystem.enableAlphaTest();
        IRenderTypeBuffer.Impl source = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        font.func_228079_a_(text, float_3, -3.5f, level > higherCrossLevel ? -16505852 : (lowerCrossLevel >= 0 && level > lowerCrossLevel ? -16750849 : -9236207), false, TransformationMatrix.func_227983_a_().func_227988_c_(), (IRenderTypeBuffer)source, false, 0, 0xF000F0);
        source.func_228461_a_();
        RenderSystem.popMatrix();
    }

    public static void loadConfig(File file) {
        try {
            redColor = 0xFF0000;
            yellowColor = 0xFFFF00;
            secondaryColor = 255;
            if (!file.exists() || !file.canRead()) {
                LightOverlay.saveConfig(file);
            }
            FileInputStream fis = new FileInputStream(file);
            Properties properties = new Properties();
            properties.load(fis);
            fis.close();
            reach = Integer.parseInt((String)properties.computeIfAbsent("reach", (Function<? super Object, ?>)((Function<Object, Object>)a -> "12")));
            crossLevel = Integer.parseInt((String)properties.computeIfAbsent("crossLevel", (Function<? super Object, ?>)((Function<Object, Object>)a -> "7")));
            secondaryLevel = Integer.parseInt((String)properties.computeIfAbsent("secondaryLevel", (Function<? super Object, ?>)((Function<Object, Object>)a -> "-1")));
            caching = ((String)properties.computeIfAbsent("caching", (Function<? super Object, ?>)((Function<Object, Object>)a -> "false"))).equalsIgnoreCase("true");
            showNumber = ((String)properties.computeIfAbsent("showNumber", (Function<? super Object, ?>)((Function<Object, Object>)a -> "false"))).equalsIgnoreCase("true");
            smoothLines = ((String)properties.computeIfAbsent("smoothLines", (Function<? super Object, ?>)((Function<Object, Object>)a -> "true"))).equalsIgnoreCase("true");
            underwater = ((String)properties.computeIfAbsent("underwater", (Function<? super Object, ?>)((Function<Object, Object>)a -> "false"))).equalsIgnoreCase("true");
            mushroom = ((String)properties.computeIfAbsent("mushroom", (Function<? super Object, ?>)((Function<Object, Object>)a -> "false"))).equalsIgnoreCase("true");
            useListWhileCaching = ((String)properties.computeIfAbsent("useListWhileCaching", (Function<? super Object, ?>)((Function<Object, Object>)a -> "true"))).equalsIgnoreCase("true");
            lineWidth = Float.parseFloat((String)properties.computeIfAbsent("lineWidth", (Function<? super Object, ?>)((Function<Object, Object>)a -> "1")));
            int r = Integer.parseInt((String)properties.computeIfAbsent("yellowColorRed", (Function<? super Object, ?>)((Function<Object, Object>)a -> "255")));
            int g = Integer.parseInt((String)properties.computeIfAbsent("yellowColorGreen", (Function<? super Object, ?>)((Function<Object, Object>)a -> "255")));
            int b = Integer.parseInt((String)properties.computeIfAbsent("yellowColorBlue", (Function<? super Object, ?>)((Function<Object, Object>)a -> "0")));
            yellowColor = (r << 16) + (g << 8) + b;
            r = Integer.parseInt((String)properties.computeIfAbsent("redColorRed", (Function<? super Object, ?>)((Function<Object, Object>)a -> "255")));
            g = Integer.parseInt((String)properties.computeIfAbsent("redColorGreen", (Function<? super Object, ?>)((Function<Object, Object>)a -> "0")));
            b = Integer.parseInt((String)properties.computeIfAbsent("redColorBlue", (Function<? super Object, ?>)((Function<Object, Object>)a -> "0")));
            redColor = (r << 16) + (g << 8) + b;
            r = Integer.parseInt((String)properties.computeIfAbsent("secondaryColorRed", (Function<? super Object, ?>)((Function<Object, Object>)a -> "0")));
            g = Integer.parseInt((String)properties.computeIfAbsent("secondaryColorGreen", (Function<? super Object, ?>)((Function<Object, Object>)a -> "0")));
            b = Integer.parseInt((String)properties.computeIfAbsent("secondaryColorBlue", (Function<? super Object, ?>)((Function<Object, Object>)a -> "255")));
            secondaryColor = (r << 16) + (g << 8) + b;
            LightOverlay.saveConfig(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            reach = 12;
            crossLevel = 7;
            secondaryLevel = -1;
            lineWidth = 1.0f;
            redColor = 0xFF0000;
            yellowColor = 0xFFFF00;
            secondaryColor = 255;
            caching = false;
            showNumber = false;
            smoothLines = true;
            underwater = false;
            mushroom = false;
            useListWhileCaching = true;
            try {
                LightOverlay.saveConfig(file);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (secondaryLevel >= crossLevel) {
            System.err.println("[Light Overlay] Secondary Level is higher than Cross Level");
        }
        lowerCrossLevel = Math.min(crossLevel, secondaryLevel);
        higherCrossLevel = Math.max(crossLevel, secondaryLevel);
        for (ChunkData data : CHUNK_MAP.values()) {
            data.close();
        }
        CHUNK_MAP.clear();
        POS.clear();
    }

    public static void saveConfig(File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file, false);
        fos.write("# Light Overlay Config".getBytes());
        fos.write("\n".getBytes());
        fos.write(("reach=" + reach).getBytes());
        fos.write("\n".getBytes());
        fos.write(("crossLevel=" + crossLevel).getBytes());
        fos.write("\n".getBytes());
        fos.write(("secondaryLevel=" + secondaryLevel).getBytes());
        fos.write("\n".getBytes());
        fos.write(("caching=" + caching).getBytes());
        fos.write("\n".getBytes());
        fos.write(("showNumber=" + showNumber).getBytes());
        fos.write("\n".getBytes());
        fos.write(("smoothLines=" + smoothLines).getBytes());
        fos.write("\n".getBytes());
        fos.write(("underwater=" + underwater).getBytes());
        fos.write("\n".getBytes());
        fos.write(("mushroom=" + mushroom).getBytes());
        fos.write("\n".getBytes());
        fos.write(("useListWhileCaching=" + useListWhileCaching).getBytes());
        fos.write("\n".getBytes());
        fos.write(("lineWidth=" + FORMAT.format(lineWidth)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("yellowColorRed=" + (yellowColor >> 16 & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("yellowColorGreen=" + (yellowColor >> 8 & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("yellowColorBlue=" + (yellowColor & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("redColorRed=" + (redColor >> 16 & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("redColorGreen=" + (redColor >> 8 & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("redColorBlue=" + (redColor & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("secondaryColorRed=" + (secondaryColor >> 16 & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("secondaryColorGreen=" + (secondaryColor >> 8 & 0xFF)).getBytes());
        fos.write("\n".getBytes());
        fos.write(("secondaryColorBlue=" + (secondaryColor & 0xFF)).getBytes());
        fos.close();
    }

    private static KeyBinding createKeyBinding(ResourceLocation id, InputMappings.Type type, int code, String category) {
        return new KeyBinding("key." + id.func_110624_b() + "." + id.func_110623_a(), type, code, category);
    }

    private static boolean isFrustumVisible(ClippingHelper frustum, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        try {
            return ((MethodHandle)IS_FRUSTUM_VISIBLE.func_179281_c()).invokeExact(frustum, minX, minY, minZ, maxX, maxY, maxZ);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    private static void registerDebugRenderer(Runnable runnable) {
        try {
            Class.forName("me.shedaniel.lightoverlay." + Platform.getModLoader() + ".LightOverlayImpl").getDeclaredField("debugRenderer").set(null, runnable);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void tick(Minecraft minecraft) {
        block24: {
            while (enableOverlay.func_151468_f()) {
                enabled = !enabled;
            }
            try {
                ++ticks;
                if (LightOverlay.CLIENT.field_71439_g == null || !enabled) {
                    POS.clear();
                    CALCULATING_POS.clear();
                    EXECUTOR.getQueue().clear();
                    for (ChunkData data : CHUNK_MAP.values()) {
                        data.close();
                    }
                    CHUNK_MAP.clear();
                    break block24;
                }
                ClientPlayerEntity player = LightOverlay.CLIENT.field_71439_g;
                ClientWorld world = LightOverlay.CLIENT.field_71441_e;
                ISelectionContext collisionContext = ISelectionContext.func_216374_a((Entity)player);
                if (!caching) {
                    CALCULATING_POS.clear();
                    POS.clear();
                    for (ChunkData data : CHUNK_MAP.values()) {
                        data.close();
                    }
                    CHUNK_MAP.clear();
                    BlockPos playerPos = player.func_233580_cy_();
                    IWorldLightListener block = world.func_225524_e_().func_215569_a(LightType.BLOCK);
                    IWorldLightListener sky = showNumber ? null : world.func_225524_e_().func_215569_a(LightType.SKY);
                    BlockPos.Mutable downPos = new BlockPos.Mutable();
                    Iterable iterate = BlockPos.func_191531_b((int)(playerPos.func_177958_n() - reach), (int)(playerPos.func_177956_o() - reach), (int)(playerPos.func_177952_p() - reach), (int)(playerPos.func_177958_n() + reach), (int)(playerPos.func_177956_o() + reach), (int)(playerPos.func_177952_p() + reach));
                    ChunkData chunkData = new ChunkData();
                    CHUNK_MAP.put(new CubicChunkPos(0, 0, 0), chunkData);
                    for (BlockPos blockPos : iterate) {
                        downPos.func_181079_c(blockPos.func_177958_n(), blockPos.func_177956_o() - 1, blockPos.func_177952_p());
                        if (showNumber) {
                            int level = LightOverlay.getCrossLevel(blockPos, (BlockPos)downPos, (IBlockReader)world, block, collisionContext);
                            if (level < 0) continue;
                            chunkData.data().put(blockPos.func_218275_a(), (byte)level);
                            continue;
                        }
                        Biome biome = !mushroom ? world.func_226691_t_(blockPos) : null;
                        byte type = LightOverlay.getCrossType(blockPos, biome, (BlockPos)downPos, (IBlockReader)world, block, sky, collisionContext);
                        if (type == 2) continue;
                        chunkData.data().put(blockPos.func_218275_a(), type);
                    }
                    break block24;
                }
                int playerPosX = (int)player.func_226277_ct_() >> 4;
                int playerPosY = (int)player.func_226278_cu_() >> 4;
                int playerPosZ = (int)player.func_226281_cx_() >> 4;
                for (int chunkX = playerPosX - LightOverlay.getChunkRange(); chunkX <= playerPosX + LightOverlay.getChunkRange(); ++chunkX) {
                    for (int chunkY = Math.max(playerPosY - LightOverlay.getChunkRange(), 0); chunkY <= playerPosY + LightOverlay.getChunkRange() && chunkY <= 15; ++chunkY) {
                        for (int chunkZ = playerPosZ - LightOverlay.getChunkRange(); chunkZ <= playerPosZ + LightOverlay.getChunkRange(); ++chunkZ) {
                            CubicChunkPos chunkPos;
                            if (MathHelper.func_76130_a((int)(chunkX - playerPosX)) > LightOverlay.getChunkRange() || MathHelper.func_76130_a((int)(chunkY - playerPosY)) > LightOverlay.getChunkRange() || MathHelper.func_76130_a((int)(chunkZ - playerPosZ)) > LightOverlay.getChunkRange() || CHUNK_MAP.containsKey(chunkPos = new CubicChunkPos(chunkX, chunkY, chunkZ))) continue;
                            LightOverlay.queueChunk(chunkPos);
                        }
                    }
                }
                for (int p = 0; p < 3 && EXECUTOR.getQueue().size() < Runtime.getRuntime().availableProcessors(); ++p) {
                    double d1 = Double.MAX_VALUE;
                    double d2 = Double.MAX_VALUE;
                    double d3 = Double.MAX_VALUE;
                    CubicChunkPos c1 = null;
                    CubicChunkPos c2 = null;
                    CubicChunkPos c3 = null;
                    Set<CubicChunkPos> set = POS;
                    synchronized (set) {
                        Iterator<CubicChunkPos> iterator = POS.iterator();
                        while (iterator.hasNext()) {
                            int k;
                            int j;
                            CubicChunkPos pos = iterator.next();
                            if (MathHelper.func_76130_a((int)(pos.x - playerPosX)) > LightOverlay.getChunkRange() || MathHelper.func_76130_a((int)(pos.y - playerPosY)) > LightOverlay.getChunkRange() || MathHelper.func_76130_a((int)(pos.z - playerPosZ)) > LightOverlay.getChunkRange() || CALCULATING_POS.contains(pos)) {
                                iterator.remove();
                                continue;
                            }
                            if (!LightOverlay.isFrustumVisible(frustum, pos.getMinBlockX(), pos.getMinBlockY(), pos.getMinBlockZ(), pos.getMaxBlockX(), pos.getMaxBlockY(), pos.getMaxBlockZ())) continue;
                            int i = Math.abs(pos.x - playerPosX);
                            double distance = Math.sqrt(i * i + (j = Math.abs(pos.y - playerPosY)) * j + (k = Math.abs(pos.z - playerPosZ)) * k);
                            if (distance < d1) {
                                d3 = d2;
                                d2 = d1;
                                d1 = distance;
                                c3 = c2;
                                c2 = c1;
                                c1 = pos;
                                iterator.remove();
                                continue;
                            }
                            if (distance < d2) {
                                d3 = d2;
                                d2 = distance;
                                c3 = c2;
                                c2 = pos;
                                iterator.remove();
                                continue;
                            }
                            if (!(distance < d3)) continue;
                            d3 = distance;
                            c3 = pos;
                            iterator.remove();
                        }
                    }
                    CubicChunkPos finalC1 = c1;
                    CubicChunkPos finalC2 = c2;
                    CubicChunkPos finalC3 = c3;
                    if (finalC1 == null) continue;
                    CALCULATING_POS.add(finalC1);
                    if (finalC2 != null) {
                        CALCULATING_POS.add(finalC2);
                        if (finalC3 != null) {
                            CALCULATING_POS.add(finalC3);
                        }
                    }
                    EXECUTOR.submit(() -> {
                        int playerPosX1 = (int)LightOverlay.CLIENT.field_71439_g.func_226277_ct_() >> 4;
                        int playerPosY1 = (int)LightOverlay.CLIENT.field_71439_g.func_226278_cu_() >> 4;
                        int playerPosZ1 = (int)LightOverlay.CLIENT.field_71439_g.func_226281_cx_() >> 4;
                        if (finalC1 != null) {
                            LightOverlay.processChunk(finalC1, playerPosX1, playerPosY1, playerPosZ1, collisionContext);
                        }
                        if (finalC2 != null) {
                            LightOverlay.processChunk(finalC2, playerPosX1, playerPosY1, playerPosZ1, collisionContext);
                        }
                        if (finalC3 != null) {
                            LightOverlay.processChunk(finalC3, playerPosX1, playerPosY1, playerPosZ1, collisionContext);
                        }
                    });
                }
                if (ticks % 50L == 0L) {
                    Iterator<Map.Entry<CubicChunkPos, ChunkData>> iterator = CHUNK_MAP.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<CubicChunkPos, ChunkData> entry = iterator.next();
                        if (MathHelper.func_76130_a((int)(entry.getKey().x - playerPosX)) <= LightOverlay.getChunkRange() * 2 && MathHelper.func_76130_a((int)(entry.getKey().y - playerPosY)) <= LightOverlay.getChunkRange() * 2 && MathHelper.func_76130_a((int)(entry.getKey().z - playerPosZ)) <= LightOverlay.getChunkRange() * 2) continue;
                        entry.getValue().close();
                        iterator.remove();
                    }
                }
            }
            catch (Throwable throwable) {
                LogManager.getLogger().throwing(throwable);
            }
        }
    }

    static {
        enabled = false;
        TESTING_ENTITY_TYPE = new LazyValue(() -> EntityType.Builder.func_220319_a((EntityClassification)EntityClassification.MONSTER).func_220321_a(0.0f, 0.0f).func_200706_c().func_206830_a(null));
        threadNumber = 0;
        EXECUTOR = (ThreadPoolExecutor)Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), r -> {
            Thread thread = new Thread(r, "light-overlay-" + threadNumber++);
            thread.setDaemon(true);
            return thread;
        });
        POS = Collections.synchronizedSet(new HashSet());
        CALCULATING_POS = Collections.synchronizedSet(new HashSet());
        CHUNK_MAP = Maps.newConcurrentMap();
        CLIENT = Minecraft.func_71410_x();
        ticks = 0L;
        IS_FRUSTUM_VISIBLE = new LazyValue(() -> {
            try {
                return MethodHandles.lookup().findStatic(Class.forName("me.shedaniel.lightoverlay." + Platform.getModLoader() + ".LightOverlayImpl"), "isFrustumVisible", MethodType.methodType(Boolean.TYPE, ClippingHelper.class, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE));
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

