/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.commands.dump;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.File;
import java.io.PrintStream;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import org.orecruncher.dsurround.DynamicSurroundings;
import org.orecruncher.dsurround.commands.CommandHelpers;
import org.orecruncher.environs.library.DimensionLibrary;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.tags.TagUtils;
import org.orecruncher.mobeffects.library.FootstepLibrary;
import org.orecruncher.sndctrl.library.AcousticLibrary;

public class DumpCommand {
    public static void register(@Nonnull CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"dsdump").requires(req -> req.func_197034_c(0))).then(Commands.func_197057_a((String)"acoustics").executes(cmd -> DumpCommand.dumpAcoustics((CommandSource)cmd.getSource())))).then(Commands.func_197057_a((String)"audioeffects").executes(cmd -> DumpCommand.dumpAudioEffects((CommandSource)cmd.getSource())))).then(Commands.func_197057_a((String)"blocks").executes(cmd -> DumpCommand.dumpBlocks((CommandSource)cmd.getSource())))).then(Commands.func_197057_a((String)"blocktags").executes(cmd -> DumpCommand.dumpBlockTags((CommandSource)cmd.getSource())))).then(Commands.func_197057_a((String)"biomes").executes(cmd -> DumpCommand.dumpBiomes((CommandSource)cmd.getSource())))).then(Commands.func_197057_a((String)"items").executes(cmd -> DumpCommand.dumpItems((CommandSource)cmd.getSource())))).then(Commands.func_197057_a((String)"footsteps").executes(cmd -> DumpCommand.dumpFootsteps((CommandSource)cmd.getSource())))).then(Commands.func_197057_a((String)"mobeffects").executes(cmd -> DumpCommand.dumpMobeffects((CommandSource)cmd.getSource())))).then(Commands.func_197057_a((String)"blockstates").executes(cmd -> DumpCommand.dumpBlockStates((CommandSource)cmd.getSource())))).then(Commands.func_197057_a((String)"dimensions").executes(cmd -> DumpCommand.dumpDimensions((CommandSource)cmd.getSource()))));
    }

    private static int dumpAcoustics(@Nonnull CommandSource source) {
        return DumpCommand.handle(source, "dump.acoustics", AcousticLibrary::dump);
    }

    private static int dumpAudioEffects(@Nonnull CommandSource source) {
        return DumpCommand.handle(source, "dump.audioeffects", DumpCommand::tbd);
    }

    private static int dumpBlocks(@Nonnull CommandSource source) {
        return DumpCommand.handle(source, "dump.blocks", DumpCommand::tbd);
    }

    private static int dumpBlockTags(@Nonnull CommandSource source) {
        return DumpCommand.handle(source, "dump.blocktags", TagUtils::dumpBlockTags);
    }

    private static int dumpBiomes(@Nonnull CommandSource source) {
        return DumpCommand.handle(source, "dump.biomes", DumpCommand::tbd);
    }

    private static int dumpFootsteps(@Nonnull CommandSource source) {
        return DumpCommand.handle(source, "dump.footsteps", FootstepLibrary::dump);
    }

    private static int dumpItems(@Nonnull CommandSource source) {
        return DumpCommand.handle(source, "dump.items", DumpCommand::tbd);
    }

    private static int dumpMobeffects(@Nonnull CommandSource source) {
        return DumpCommand.handle(source, "dump.mobeffects", DumpCommand::tbd);
    }

    private static int dumpBlockStates(@Nonnull CommandSource source) {
        return DumpCommand.handle(source, "dump.blockstates", DumpCommand::tbd);
    }

    private static int dumpDimensions(@Nonnull CommandSource source) {
        return DumpCommand.handle(source, "dump.dimensions", DimensionLibrary::dump);
    }

    private static int handle(@Nonnull CommandSource source, @Nonnull String cmdString, @Nonnull Supplier<Stream<String>> supplier) {
        try {
            if (GameUtils.getMC().func_71356_B()) {
                String operation = cmdString.substring(5);
                String fileName = operation + ".txt";
                File target = new File(DynamicSurroundings.DUMP_PATH, fileName);
                CommandHelpers.scheduleOnClientThread(() -> {
                    try (PrintStream out = new PrintStream(target);){
                        Stream strm = (Stream)supplier.get();
                        strm.forEach(out::println);
                        out.flush();
                    }
                    catch (Throwable t) {
                        DynamicSurroundings.LOGGER.error(t, "Error writing dump file '%s'", target.toString());
                    }
                });
                CommandHelpers.sendSuccess(source, "dump", operation, target.toString());
            } else {
                CommandHelpers.sendFailure(source, cmdString);
            }
        }
        catch (Throwable t) {
            CommandHelpers.sendFailure(source, cmdString);
        }
        return 0;
    }

    private static Stream<String> tbd() {
        ImmutableList result = ImmutableList.of((Object)"Not hooked up");
        return result.stream();
    }
}

